/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.title;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.Scenario;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ScenarioButton;
import java.util.ArrayList;
import java.util.List;

public class SceneScenarioSelect
extends SceneCommon {
    private Texture backGraund;
    private List<ScenarioButton> buttons;

    public SceneScenarioSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.buttons = new ArrayList<ScenarioButton>();
    }

    @Override
    public void load() {
        super.load();
        this.optionUse = true;
        this.loadFile();
    }

    @Override
    public void unLoad() {
        this.buttons.clear();
    }

    private void loadFile() {
        List<Scenario> list = this.getPlayerClient().getScenarios();
        list.forEach(scenario -> {
            ScenarioButton scenarioButton = new ScenarioButton(100, this.buttons.size() * 420 + 100, (Scenario)scenario);
            scenarioButton.setPrimaryClicked(windowClickable -> this.getPlayerClient().selectScenarioResponse(false, (Scenario)scenario));
            this.buttons.add(scenarioButton);
        });
    }

    @Override
    public void update() {
        super.update();
        this.buttons.forEach(scenarioButton -> scenarioButton.update());
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.buttons.forEach(scenarioButton -> scenarioButton.draw(this.bcontext));
    }

    @Override
    protected void exit() {
        this.getPlayerClient().selectScenarioResponse(true, null);
    }
}

