/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.title;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.SaveData;
import game.sengoku.data.SaveDataInterface;
import game.sengoku.main.KessenMain;
import game.sengoku.window.SaveDataSprite;
import game.sengoku.window.SaveDataWindow;
import game.sengoku.window.WindowClickable;
import java.util.ArrayList;
import java.util.List;

public class SceneSaveSelect
extends SceneCommon {
    private Texture backGraund;
    private List<SaveDataSprite> buttons;
    private SaveDataWindow saveDataWindow;

    public SceneSaveSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.buttons = new ArrayList<SaveDataSprite>();
        this.saveDataWindow = new SaveDataWindow(50, 400, "\u30bb\u30fc\u30d6\u3059\u308b\u30c7\u30fc\u30bf\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044");
    }

    @Override
    public void load() {
        super.load();
        this.loadFile();
    }

    @Override
    public void unLoad() {
        this.buttons.clear();
    }

    private void loadFile() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        Texture texture = (Texture)graphicPool.getResource("save01.png");
        Texture texture2 = (Texture)graphicPool.getResource("save02.png");
        Texture texture3 = (Texture)graphicPool.getResource("save03.png");
        List<SaveDataInterface> list = this.getPlayerClient().getSaveDatas();
        SaveData saveData = new SaveData("\u65b0\u3057\u3044\u30bb\u30fc\u30d6\u30d5\u30a1\u30a4\u30eb", "", 0L, "", "", null, null);
        SaveDataSprite saveDataSprite = new SaveDataSprite(40, 40, 50, 60, 60, texture3, texture3, (SaveDataInterface)saveData);
        saveDataSprite.setPrimaryClicked(windowClickable -> this.getPlayerClient().gameSaveRequest(true, false, null));
        saveDataSprite.setMouseEnter(arg_0 -> this.lambda$loadFile$1041((SaveDataInterface)saveData, arg_0));
        saveDataSprite.setMouseExit(windowClickable -> this.saveDataWindow.setSaveData(null));
        this.buttons.add(saveDataSprite);
        list.forEach(saveDataInterface -> {
            int n = this.buttons.size();
            Texture texture3 = saveDataInterface.isLatest() ? texture2 : texture;
            SaveDataSprite saveDataSprite = new SaveDataSprite(40 + n % 8 * 80, 40 + n / 8 * 80, 50, 60, 60, texture3, texture3, (SaveDataInterface)saveDataInterface);
            saveDataSprite.setPrimaryClicked(windowClickable -> this.getPlayerClient().gameSaveRequest(false, false, saveDataSprite.getSaveData()));
            saveDataSprite.setMouseEnter(windowClickable -> this.saveDataWindow.setSaveData(((SaveDataSprite)windowClickable).getSaveData()));
            saveDataSprite.setMouseExit(windowClickable -> this.saveDataWindow.setSaveData(null));
            this.buttons.add(saveDataSprite);
        });
    }

    @Override
    public void update() {
        super.update();
        if (this.getPlayerClient().getStatus() == 35 && this.getGameTemp().getMessages().isEmpty() && !this.messageWindow.isVisible()) {
            this.alert(0, () -> this.getPlayerClient().gameSaveEnd(), null, "\u30bb\u30fc\u30d6\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002", "\u30d5\u30a1\u30a4\u30eb\u540d\u306f" + this.getPlayerClient().getSavedFileName() + "\u3067\u3059\u3002");
        }
        this.saveDataWindow.update();
        this.buttons.forEach(saveDataSprite -> saveDataSprite.update());
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.saveDataWindow.draw(this.bcontext);
        this.buttons.forEach(saveDataSprite -> saveDataSprite.draw(this.bcontext));
    }

    @Override
    protected void exit() {
        this.getPlayerClient().gameSaveRequest(false, true, null);
    }

    private /* synthetic */ void lambda$loadFile$1041(SaveDataInterface saveDataInterface, WindowClickable windowClickable) {
        this.saveDataWindow.setSaveData(saveDataInterface);
    }
}

