/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.title;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.SaveDataInterface;
import game.sengoku.main.KessenMain;
import game.sengoku.window.SaveDataSprite;
import game.sengoku.window.SaveDataWindow;
import java.util.ArrayList;
import java.util.List;

public class SceneLoadSelect
extends SceneCommon {
    private Texture backGraund;
    private List<SaveDataSprite> buttons;
    private SaveDataWindow saveDataWindow;

    public SceneLoadSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.buttons = new ArrayList<SaveDataSprite>();
        this.saveDataWindow = new SaveDataWindow(50, 400, "\u30ed\u30fc\u30c9\u3059\u308b\u30c7\u30fc\u30bf\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044");
    }

    @Override
    public void load() {
        super.load();
        this.loadFile();
    }

    @Override
    public void unLoad() {
        this.buttons.clear();
    }

    private void loadFile() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        Texture texture = (Texture)graphicPool.getResource("save01.png");
        Texture texture2 = (Texture)graphicPool.getResource("save02.png");
        List<SaveDataInterface> list = this.getPlayerClient().getSaveDatas();
        list.forEach(saveDataInterface -> {
            int n = this.buttons.size();
            Texture texture3 = saveDataInterface.isLatest() ? texture2 : texture;
            SaveDataSprite saveDataSprite = new SaveDataSprite(40 + n % 8 * 80, 40 + n / 8 * 80, 50, 60, 60, texture3, texture3, (SaveDataInterface)saveDataInterface);
            saveDataSprite.setPrimaryClicked(windowClickable -> this.getPlayerClient().selectLoadResponse(false, (SaveDataInterface)saveDataInterface));
            saveDataSprite.setMouseEnter(windowClickable -> this.saveDataWindow.setSaveData(((SaveDataSprite)windowClickable).getSaveData()));
            saveDataSprite.setMouseExit(windowClickable -> this.saveDataWindow.setSaveData(null));
            this.buttons.add(saveDataSprite);
        });
    }

    @Override
    public void update() {
        super.update();
        this.saveDataWindow.update();
        this.buttons.forEach(saveDataSprite -> saveDataSprite.update());
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.saveDataWindow.draw(this.bcontext);
        this.buttons.forEach(saveDataSprite -> saveDataSprite.draw(this.bcontext));
    }

    @Override
    protected void exit() {
        this.getPlayerClient().selectLoadResponse(true, null);
    }
}

