/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.title;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameData;
import game.sengoku.data.GameDataV;
import game.sengoku.main.KessenMain;
import game.sengoku.window.CountrySelectButton;
import game.sengoku.window.WindowDaimyoSelectInfo;
import java.util.ArrayList;
import java.util.List;

public class SceneDaimyoSelect
extends SceneCommon {
    private Texture backGraund = null;
    private Texture minimap;
    private List<CountrySelectButton> buttons;
    private DaimyoV daimyo;
    private WindowDaimyoSelectInfo info;

    public SceneDaimyoSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.buttons = new ArrayList<CountrySelectButton>();
        this.daimyo = null;
        this.info = new WindowDaimyoSelectInfo(50, 450, 10, 700, 140, "", this.getGameDataV());
    }

    @Override
    public void load() {
        super.load();
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        GameData gameData = this.getGameData();
        this.minimap = (Texture)graphicPool.getResource(gameData.getMap().getImageMini());
        this.loadData();
    }

    private void loadData() {
        GameDataV gameDataV = this.getGameDataV();
        for (CountryV countryV : gameDataV.getCountries().values()) {
            countryV.update();
            CountrySelectButton countrySelectButton = new CountrySelectButton(countryV.getCountry(), gameDataV, countryV.getDaimyo().getColor(), countryV.getDaimyo().getColor());
            countrySelectButton.setMouseEnter(windowClickable -> {
                this.daimyo = ((CountrySelectButton)windowClickable).getCountryV().getDaimyo();
            });
            countrySelectButton.setMouseExit(windowClickable -> {
                this.daimyo = null;
            });
            countrySelectButton.setPrimaryClicked(windowClickable -> {
                if (this.daimyo != null) {
                    this.alert(1, () -> this.getPlayerClient().selectDaimyoResponse(false, this.daimyo.getId()), null, this.daimyo.getName() + "\u3067\u59cb\u3081\u307e\u3059\u304b\uff1f");
                }
            });
            this.buttons.add(countrySelectButton);
        }
    }

    @Override
    public void unLoad() {
        this.buttons.clear();
    }

    @Override
    public void update() {
        super.update();
        this.buttons.forEach(countrySelectButton -> countrySelectButton.update());
        if (this.daimyo != null) {
            this.info.setDaimyoId(this.daimyo.getId());
        } else {
            this.info.setDaimyoId(0);
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.bcontext.drawImage(this.minimap, 150, 10, 10);
        this.info.draw(this.bcontext);
        this.buttons.forEach(countrySelectButton -> countrySelectButton.draw(this.bcontext));
    }

    @Override
    protected void exit() {
        this.getPlayerClient().selectDaimyoResponse(true, 0);
    }
}

