/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.server;

import game.sengoku.common.AIDiplomacyUtil;
import game.sengoku.common.AIDomesticUtil;
import game.sengoku.common.AINegotiationUtil;
import game.sengoku.common.AITacticsUtil;
import game.sengoku.common.GameUtil;
import game.sengoku.data.AIUseObject;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.PlayerV;
import game.sengoku.game.GameTacticsUtil;
import game.sengoku.game.diplomacy.NegotiationAction;
import game.sengoku.game.diplomacy.StoreAction;
import game.sengoku.game.domestic.DomesticAction;
import game.sengoku.game.domestic.DomesticEvent;
import game.sengoku.game.domestic.DomesticEventResult;
import game.sengoku.game.tactics.TacticsAction;
import game.sengoku.server.GameClient;
import game.sengoku.server.PostBox;
import java.util.ArrayList;
import java.util.List;

public class GameAIClient
extends GameClient {
    private int negotiateCount = 0;
    private List<Integer> disNegotiateTargets = new ArrayList<Integer>();

    public GameAIClient(int n, PostBox postBox, PlayerV playerV) {
        super(n, postBox, playerV);
    }

    @Override
    protected void createDomesticEvent() {
        DomesticEvent domesticEvent = this.getGameTemp().getDomesticEvent();
        DomesticEventResult domesticEventResult = new DomesticEventResult(domesticEvent.getEventId(), this.getPlayer().getDaimyo().getId());
        if (domesticEvent.getEventId() == 4) {
            domesticEventResult.getArgs().add(this.getPlayer().getDaimyo().getAiType().getChristBaseTreat());
        } else {
            domesticEventResult.getArgs().addAll(domesticEvent.getArgs());
        }
        this.domesticEventResponse(domesticEventResult);
    }

    @Override
    protected void createDomesticAction() {
        DomesticAction domesticAction = new DomesticAction(this.getPlayer().getDaimyoId());
        AIDomesticUtil.createDomesticAction(this.getGameDataV(), this.getPlayer().getDaimyo(), this.getPlayer());
        domesticAction.getCommandList().addAll(this.getPlayer().getCommands());
        this.domesticActionResponse(domesticAction);
    }

    @Override
    protected void createTacticsAction() {
        AIDiplomacyUtil.updateAIUseObject(this.getGameDataV(), this.getPlayer(), this.getPlayer().getDaimyo());
        TacticsAction tacticsAction = new TacticsAction(this.getDaimyoV().getId());
        GameTacticsUtil.initTacticsAction(this.getGameDataV(), this.getDaimyoV().getId(), tacticsAction);
        AITacticsUtil.createTacticsAction(this.getGameDataV(), this.getPlayer(), this.getPlayer().getDaimyo(), tacticsAction);
        this.tacticsActionResponse(tacticsAction);
    }

    @Override
    protected void createTacticsResult() {
        this.tacticsResultResponse();
    }

    @Override
    protected void createDomesticStart() {
        this.domesticStartResponse();
    }

    @Override
    protected void createDomesticResult() {
        this.domesticResultResponse();
    }

    @Override
    protected void createDiplomacyStart() {
        this.negotiateCount = 0;
        this.disNegotiateTargets.clear();
        AIDiplomacyUtil.updateAIUseObject(this.getGameDataV(), this.getPlayer(), this.getPlayer().getDaimyo());
        this.diplomacyStartResponse();
    }

    @Override
    protected void createDiplomacyAction() {
        int n;
        List<Integer> list;
        List list2;
        if ((double)this.negotiateCount < Math.ceil(1.0 * (double)this.getGameDataV().getDaimyos().size() / 10.0)) {
            list2 = this.getPlayer().getDaimyo().getWars();
            for (DaimyoV daimyoV : list2) {
                if (this.disNegotiateTargets.contains(daimyoV.getId()) || !AIDiplomacyUtil.mustNonAggression(this.getGameDataV(), this.getPlayer(), this.getPlayer().getDaimyo(), daimyoV)) continue;
                this.diplomacyActionResponse(1, daimyoV.getId());
                this.disNegotiateTargets.add(daimyoV.getId());
                ++this.negotiateCount;
                return;
            }
            list = this.getGameTemp().getNegotiationDaimyoIds();
            while (!list.isEmpty()) {
                int n2 = GameUtil.getRandom(list);
                if (this.disNegotiateTargets.contains(n2)) {
                    list.remove((Object)n2);
                    continue;
                }
                AIUseObject aIUseObject = this.getPlayer().getAIUseObject();
                if (aIUseObject.getNotNegotiates().containsKey(n2)) {
                    list.remove((Object)n2);
                    continue;
                }
                n = AINegotiationUtil.judgeNegotiate(this.getGameDataV(), this.getPlayer(), this.getPlayer().getDaimyoId(), n2);
                if (n != 6) {
                    this.diplomacyActionResponse(n, n2);
                    ++this.negotiateCount;
                    return;
                }
                this.disNegotiateTargets.add(n2);
                list.remove((Object)n2);
            }
        }
        if (this.negotiateCount < 100) {
            this.negotiateCount = 100;
            int n3 = (Integer)GameUtil.getRandom(this.getPlayer().getDaimyo().getStoreIds());
            this.diplomacyActionResponse(5, n3);
            return;
        }
        list2 = this.getPlayer().getAIUseObject();
        list = new ArrayList();
        list.addAll(list2.getNotNegotiates().keySet());
        for (int n4 : list) {
            n = (Integer)list2.getNotNegotiates().get(n4);
            if (n <= 1) {
                list2.getNotNegotiates().remove(n4);
                continue;
            }
            list2.getNotNegotiates().put(n4, n - 1);
        }
        this.diplomacyActionResponse(6, 0);
    }

    @Override
    protected void createNegotiationStart() {
        int n = this.getGameTemp().getNegotiationDaimyoId();
        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(n);
        boolean bl = AIDiplomacyUtil.shouldStartNegotiation(this.getGameDataV(), this.getPlayer().getDaimyo(), daimyoV);
        this.negotiationResponse(this.getPlayer().getDaimyoId(), this.getGameTemp().getNegotiationDaimyoId(), bl);
    }

    @Override
    protected void createNegotiationAction() {
        NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
        if (negotiationAction.getSequenceNumber() <= 1) {
            AINegotiationUtil.createNegotiationActionWithSim(this.getGameDataV(), this.getPlayer(), negotiationAction);
            if (negotiationAction.isEmptyOr()) {
                negotiationAction.clear();
                AINegotiationUtil.createNegotiationAction(this.getGameDataV(), this.getPlayer(), negotiationAction);
            }
        } else {
            AINegotiationUtil.editNegotiationAction(this.getGameDataV(), this.getPlayer(), negotiationAction);
        }
        this.negotiationActionResponse(negotiationAction);
    }

    @Override
    protected void createNegotiationResult() {
        this.negotiationResultResponse();
    }

    @Override
    protected void createTacticsStart() {
        this.tacticsStartResponse();
    }

    @Override
    protected void createIntervalAction() {
        this.intervalActionResponse();
    }

    @Override
    protected void createTacticsEnd() {
        this.tacticsEndResponse();
    }

    @Override
    protected void createGameFinal() {
    }

    @Override
    protected void createStoreAction() {
        ArrayList<StoreAction> arrayList = new ArrayList<StoreAction>();
        AINegotiationUtil.selectBuy(this.getGameDataV(), this.getPlayer().getDaimyo(), arrayList);
        this.storeActionResponse(arrayList);
    }
}

