/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.main;

import game.sengoku.common.Scene;
import game.sengoku.data.DaimyoV;
import game.sengoku.game.SceneDaimyoFall;
import game.sengoku.game.SceneGameFinal;
import game.sengoku.game.SceneGameStart;
import game.sengoku.game.SceneInterval;
import game.sengoku.game.diplomacy.SceneDiplomacy;
import game.sengoku.game.diplomacy.SceneDiplomacyStart;
import game.sengoku.game.diplomacy.SceneNegotiation;
import game.sengoku.game.diplomacy.SceneStoreAmountSelect;
import game.sengoku.game.domestic.SceneDomestic;
import game.sengoku.game.domestic.SceneDomesticStart;
import game.sengoku.game.tactics.SceneTactics;
import game.sengoku.game.tactics.SceneTacticsResult;
import game.sengoku.game.tactics.SceneTacticsStart;
import game.sengoku.main.FlowControler;
import game.sengoku.server.GameClient;
import game.sengoku.title.SceneDaimyoSelect;
import game.sengoku.title.SceneLoadSelect;
import game.sengoku.title.SceneSaveSelect;
import game.sengoku.title.SceneScenarioSelect;
import game.sengoku.title.SceneTitle;

public class SceneSelector {
    public static final int SCENE_GAME_TITLE = 1;
    public static final int SCENE_SCENARIO_SELECT = 2;
    public static final int SCENE_DAIMYO_SELECT = 3;
    public static final int SCENE_LOAD_SELECT = 4;
    public static final int SCENE_GAME_START = 5;
    public static final int SCENE_GAME_EVENT = 15;
    public static final int SCENE_GAME_DOMESTIC = 6;
    public static final int SCENE_GAME_DIPLOMACY = 7;
    public static final int SCENE_GAME_NEGOTIATION = 8;
    public static final int SCENE_GAME_NEGOTIATION2 = 18;
    public static final int SCENE_GAME_STORE = 27;
    public static final int SCENE_GAME_TACTICS = 9;
    public static final int SCENE_GAME_END = 10;
    public static final int SCENE_GAME_DOMESTIC_START = 11;
    public static final int SCENE_GAME_DIPLOMACY_START = 12;
    public static final int SCENE_GAME_DIPLOMACY_START2 = 22;
    public static final int SCENE_GAME_TACTICS_START = 13;
    public static final int SCENE_GAME_TACTICS_RESULT = 14;
    public static final int SCENE_GAME_TACTICS_END = 26;
    public static final int SCENE_GAME_INTERVAL = 23;
    public static final int SCENE_GAME_FINAL = 25;
    public static final int SCENE_GAME_SAVE = 21;
    private int sceneId = -1;
    private boolean sceneChanged = true;
    private SceneTitle sceneTitle;
    private SceneTactics sceneTactics;
    private SceneTacticsStart sceneTacticsStart;
    private SceneTacticsResult sceneTacticsResult;
    private SceneScenarioSelect sceneScenarioSelect;
    private SceneLoadSelect sceneLoadSelect;
    private SceneDaimyoSelect sceneDaimyoSelect;
    private SceneGameStart sceneGameStart;
    private SceneSaveSelect sceneSaveSelect;
    private SceneDomestic sceneDomestic;
    private SceneDomesticStart sceneDomesticStart;
    private SceneDiplomacy sceneDiplomacy;
    private SceneDiplomacyStart sceneDiplomacyStart;
    private SceneNegotiation sceneNegotiation;
    private SceneDaimyoFall sceneDaimyoFall;
    private SceneGameFinal sceneGameFinal;
    private SceneInterval sceneInterval;
    private SceneStoreAmountSelect sceneStoreAmountSelect;
    private Scene scene = null;

    public int getSceneId() {
        return this.sceneId;
    }

    public void update() {
        this.sceneChanged = false;
        if (this.scene != null && this.scene.withHolding()) {
            return;
        }
        GameClient gameClient = FlowControler.getInstance().getPlayerClient();
        int n = 0;
        if (gameClient == null) {
            n = 1;
            this.sceneChanged = this.sceneId != n;
            this.sceneId = n;
            return;
        }
        switch (gameClient.getStatus()) {
            case 32: 
            case 33: {
                n = this.sceneId;
                break;
            }
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 21: {
                n = 2;
                break;
            }
            case 24: {
                n = 2;
                break;
            }
            case 22: {
                n = 3;
                break;
            }
            case 23: {
                n = 4;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 4: {
                n = 11;
                break;
            }
            case 3: {
                n = 11;
                break;
            }
            case 41: {
                n = 15;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 36: {
                n = 11;
                break;
            }
            case 37: {
                n = 12;
                break;
            }
            case 17: {
                n = 12;
                break;
            }
            case 18: {
                n = 7;
                break;
            }
            case 8: {
                n = 22;
                break;
            }
            case 9: {
                n = 18;
                break;
            }
            case 10: {
                n = 8;
                break;
            }
            case 44: {
                n = 27;
                break;
            }
            case 11: {
                n = 12;
                break;
            }
            case 12: {
                n = 13;
                break;
            }
            case 13: {
                n = 13;
                break;
            }
            case 14: {
                n = 9;
                break;
            }
            case 38: {
                n = 23;
                break;
            }
            case 39: {
                n = 23;
                break;
            }
            case 42: {
                n = 25;
                break;
            }
            case 43: {
                n = 25;
                break;
            }
            case 15: {
                n = 14;
                break;
            }
            case 16: {
                n = 14;
                break;
            }
            case 52: {
                n = 26;
                break;
            }
            case 30: {
                n = 10;
                break;
            }
            case 34: 
            case 35: {
                n = 21;
                break;
            }
            default: {
                throw new RuntimeException("invalid status = " + gameClient.getStatus());
            }
        }
        this.sceneChanged = this.sceneId != n;
        this.sceneId = n;
        if (gameClient.getGameTemp().isForceReLoad()) {
            this.sceneChanged = true;
            gameClient.getGameTemp().setForceReLoad(false);
        }
    }

    private DaimyoV getDaimyoV() {
        return this.getPlayerClient() == null ? null : this.getPlayerClient().getDaimyoV();
    }

    private GameClient getPlayerClient() {
        return FlowControler.getInstance().getPlayerClient();
    }

    public Scene getScene() {
        if (this.scene != null && this.sceneChanged) {
            this.scene.unLoad();
        }
        if (this.getDaimyoV() != null && this.getDaimyoV().isFall()) {
            if (this.sceneDaimyoFall == null) {
                this.sceneDaimyoFall = new SceneDaimyoFall();
            }
            this.scene = this.sceneDaimyoFall;
        } else {
            switch (this.sceneId) {
                case 1: {
                    if (this.sceneTitle == null) {
                        this.sceneTitle = new SceneTitle();
                    }
                    this.scene = this.sceneTitle;
                    break;
                }
                case 2: {
                    if (this.sceneScenarioSelect == null) {
                        this.sceneScenarioSelect = new SceneScenarioSelect();
                    }
                    this.scene = this.sceneScenarioSelect;
                    break;
                }
                case 3: {
                    if (this.sceneDaimyoSelect == null) {
                        this.sceneDaimyoSelect = new SceneDaimyoSelect();
                    }
                    this.scene = this.sceneDaimyoSelect;
                    break;
                }
                case 4: {
                    if (this.sceneLoadSelect == null) {
                        this.sceneLoadSelect = new SceneLoadSelect();
                    }
                    this.scene = this.sceneLoadSelect;
                    break;
                }
                case 5: {
                    if (this.sceneGameStart == null) {
                        this.sceneGameStart = new SceneGameStart();
                    }
                    this.scene = this.sceneGameStart;
                    break;
                }
                case 6: {
                    if (this.sceneDomestic == null) {
                        this.sceneDomestic = new SceneDomestic();
                    }
                    this.scene = this.sceneDomestic;
                    break;
                }
                case 7: {
                    if (this.sceneDiplomacy == null) {
                        this.sceneDiplomacy = new SceneDiplomacy();
                    }
                    this.scene = this.sceneDiplomacy;
                    break;
                }
                case 8: 
                case 18: {
                    if (this.sceneNegotiation == null) {
                        this.sceneNegotiation = new SceneNegotiation();
                    }
                    this.scene = this.sceneNegotiation;
                    break;
                }
                case 27: {
                    if (this.sceneStoreAmountSelect == null) {
                        this.sceneStoreAmountSelect = new SceneStoreAmountSelect();
                    }
                    this.scene = this.sceneStoreAmountSelect;
                    break;
                }
                case 21: {
                    if (this.sceneSaveSelect == null) {
                        this.sceneSaveSelect = new SceneSaveSelect();
                    }
                    this.scene = this.sceneSaveSelect;
                    break;
                }
                case 11: {
                    if (this.sceneDomesticStart == null) {
                        this.sceneDomesticStart = new SceneDomesticStart();
                    }
                    this.scene = this.sceneDomesticStart;
                    break;
                }
                case 15: {
                    if (this.sceneDomesticStart == null) {
                        this.sceneDomesticStart = new SceneDomesticStart();
                    }
                    this.scene = this.sceneDomesticStart;
                    break;
                }
                case 12: 
                case 22: {
                    if (this.sceneDiplomacyStart == null) {
                        this.sceneDiplomacyStart = new SceneDiplomacyStart();
                    }
                    this.scene = this.sceneDiplomacyStart;
                    break;
                }
                case 9: {
                    if (this.sceneTactics == null) {
                        this.sceneTactics = new SceneTactics();
                    }
                    this.scene = this.sceneTactics;
                    break;
                }
                case 13: {
                    if (this.sceneTacticsStart == null) {
                        this.sceneTacticsStart = new SceneTacticsStart();
                    }
                    this.scene = this.sceneTacticsStart;
                    break;
                }
                case 14: {
                    if (this.sceneTacticsResult == null) {
                        this.sceneTacticsResult = new SceneTacticsResult();
                    }
                    this.scene = this.sceneTacticsResult;
                    break;
                }
                case 26: {
                    if (this.sceneTacticsStart == null) {
                        this.sceneTacticsStart = new SceneTacticsStart();
                    }
                    this.scene = this.sceneTacticsStart;
                    break;
                }
                case 23: {
                    if (this.sceneInterval == null) {
                        this.sceneInterval = new SceneInterval();
                    }
                    this.scene = this.sceneInterval;
                    break;
                }
                case 25: {
                    if (this.sceneGameFinal == null) {
                        this.sceneGameFinal = new SceneGameFinal();
                    }
                    this.scene = this.sceneGameFinal;
                    break;
                }
                default: {
                    this.scene = null;
                }
            }
        }
        if (this.scene != null && this.sceneChanged) {
            this.scene.load();
        }
        this.sceneChanged = false;
        return this.scene;
    }
}

