/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.main;

import game.sengoku.data.AIUseObject;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.SaveData;
import game.sengoku.server.GameAIClient;
import game.sengoku.server.GameCenterServer;
import game.sengoku.server.GameClient;
import game.sengoku.server.GamePlayerClient;
import game.sengoku.server.GameServer;
import game.sengoku.server.PostBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FlowControler {
    protected PostBox post = null;
    protected GameServer server = null;
    protected GameCenterServer centerServer = null;
    protected List<GameClient> clients = new ArrayList<GameClient>();
    private static FlowControler instance = null;
    private GameClient playerClient = null;

    public static FlowControler getInstance() {
        if (instance == null) {
            instance = new FlowControler();
        }
        return instance;
    }

    public static void nullifyInstance() {
        instance = null;
    }

    private FlowControler() {
        this.post = new PostBox();
    }

    public void refresh() {
        this.post.refresh();
        this.clients.clear();
        this.server = new GameServer(2, this.post);
        this.centerServer = new GameCenterServer(1, this.post);
        this.server.init();
        this.centerServer.init();
        this.clients.forEach(gameClient -> gameClient.init());
    }

    public void update() {
        if (this.server != null) {
            this.server.update();
        }
        if (this.centerServer != null) {
            this.centerServer.update();
        }
        this.clients.forEach(gameClient -> gameClient.update());
    }

    public void createPlayer() {
        GamePlayerClient gamePlayerClient = new GamePlayerClient(100, this.post, new PlayerV(0, 0, 0, new AIUseObject()));
        this.clients.add(gamePlayerClient);
        this.playerClient = gamePlayerClient;
        gamePlayerClient.init();
    }

    public void createAIPlayers(GameDataV gameDataV, int n) {
        for (DaimyoV daimyoV : gameDataV.getDaimyos().values()) {
            if (n == daimyoV.getId()) continue;
            GameAIClient gameAIClient = new GameAIClient(100 + daimyoV.getId(), this.post, new PlayerV(daimyoV.getId(), daimyoV.getAiTypeId(), daimyoV.getId(), new AIUseObject()));
            gameAIClient.init(this.playerClient.getGameDataV());
            gameAIClient.gameJoinRequestAI();
            this.clients.add(gameAIClient);
        }
    }

    public void resetAIPlayers(GameDataV gameDataV, SaveData saveData) {
        List list = saveData.getPlayers();
        this.server.reset(gameDataV, saveData);
        list.forEach(playerV -> {
            if (playerV.getAiTypeId() == 0) {
                ((GamePlayerClient)this.playerClient).setPlayer((PlayerV)playerV);
                this.playerClient.init(gameDataV);
                this.playerClient.setStatus(39);
            } else {
                GameAIClient gameAIClient = new GameAIClient(100 + playerV.getId(), this.post, (PlayerV)playerV);
                gameAIClient.init(gameDataV);
                gameAIClient.setStatus(39);
                this.clients.add(gameAIClient);
            }
        });
    }

    public List<PlayerV> getPlayers() {
        return this.clients.stream().map(gameClient -> gameClient.getPlayer()).collect(Collectors.toList());
    }

    public Map<Integer, Integer> getPlayerStatus() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (GameClient gameClient : this.clients) {
        }
        return hashMap;
    }

    public GameClient getPlayerClient() {
        return this.playerClient;
    }

    public int getPlayerId(int n) {
        return this.clients.stream().filter(gameClient -> gameClient.getDaimyoV().getId() == n).findFirst().map(gameClient -> gameClient.getId()).orElse(-1);
    }

    public int getDaimyoId(int n) {
        return this.clients.stream().filter(gameClient -> gameClient.getId() == n).findFirst().map(gameClient -> gameClient.getDaimyoV().getId()).orElse(-1);
    }
}

