/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.tactics;

import game.base.common.Pair;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.DataTableHeaderItem;
import game.sengoku.common.DataTableRecord;
import game.sengoku.common.DataTableRecordItem;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.CountryV;
import game.sengoku.data.UnitType;
import game.sengoku.data.UnitV;
import game.sengoku.game.GameTacticsUtil;
import game.sengoku.game.SceneTableCommon;
import game.sengoku.game.tactics.TacticsAction;
import game.sengoku.game.tactics.TacticsActionEntry;
import game.sengoku.main.KessenMain;
import game.sengoku.window.WindowMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SceneTacticsOperationUnitSelect
extends SceneTableCommon {
    protected static final int ITEM_NAME = 1;
    protected static final int ITEM_UNIT_NAME = 2;
    protected static final int ITEM_DAIMYO = 3;
    protected static final int ITEM_KNIGHT = 4;
    protected static final int ITEM_COUNTRY = 5;
    protected static final int ITEM_SPOT = 6;
    protected static final int ITEM_SPEED = 7;
    protected static final int ITEM_ATTACK = 8;
    protected static final int ITEM_DEFENSE = 9;
    protected static final int ITEM_LEAVE = 10;
    protected static final int ITEM_MORAL = 11;
    protected static final int ITEM_OPERATION = 12;
    protected WindowMessage info;
    protected List<UnitV> units;
    protected Map<Integer, List<Pair<String, String>>> effects;

    public SceneTacticsOperationUnitSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.effects = new HashMap<Integer, List<Pair<String, String>>>();
        this.info = new WindowMessage(20, 10, 100, 700, 30, 877223628, GameFontUtil.FONT16, -269422081, this.getDefaultMessage());
    }

    protected String getDefaultMessage() {
        return "\u547d\u4ee4\u3059\u308b\u30e6\u30cb\u30c3\u30c8\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044";
    }

    @Override
    public void load() {
        super.load();
    }

    protected int[] getUnitsItems() {
        return new int[]{1, 2, 12, 3, 5, 4, 6, 10, 11, 7, 8, 9};
    }

    protected void loadData() {
        int n = this.getGameTemp().getCandidateCountryId();
        CountryV countryV = (CountryV)this.getGameDataV().getCountries().get(n);
        this.units = GameTacticsUtil.getOperationUnits(this.getGameDataV(), this.getDaimyo().getId());
    }

    @Override
    protected int getTopY() {
        return 50;
    }

    @Override
    protected int getRowMax() {
        return 10;
    }

    @Override
    protected int getColumnMax() {
        return 8;
    }

    @Override
    protected void createTable() {
        this.loadData();
        this.createTableUnits();
        this.dataTable.setFixItem(1);
    }

    protected void createTableUnits() {
        List<DataTableHeaderItem> list = this.dataTable.getHeader().getItems();
        list.clear();
        List<DataTableRecord> list2 = this.dataTable.getRecords();
        list2.clear();
        Object object = this.units.iterator();
        while (object.hasNext()) {
            UnitV object2 = object.next();
            list2.add(new DataTableRecord(object2.getId()));
        }
        block14: for (Object object3 : object = (Object)this.getUnitsItems()) {
            switch (object3) {
                case 1: {
                    list.add(new DataTableHeaderItem(120, "\u540d\u524d", dataTableHeaderItem -> this.setWeights(1, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, unitV.getName(), dataTableRecord.getId(), dataTable -> this.clickedUnit(unitV)));
                    });
                    continue block14;
                }
                case 2: {
                    list.add(new DataTableHeaderItem(120, "\u30e6\u30cb\u30c3\u30c8", dataTableHeaderItem -> this.setWeights(2, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, unitV.getUnit().getName(), unitV.getId(), dataTable -> this.clickedUnit(unitV)));
                    });
                    continue block14;
                }
                case 3: {
                    list.add(new DataTableHeaderItem(120, "\u5927\u540d", dataTableHeaderItem -> this.setWeights(3, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, unitV.getDaimyoId() == 0 ? "-" : unitV.getDaimyo().getName(), unitV.getDaimyoId()));
                    });
                    continue block14;
                }
                case 5: {
                    list.add(new DataTableHeaderItem(100, "\u6240\u5c5e\u56fd", dataTableHeaderItem -> this.setWeights(5, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(100, unitV.getCountryId() == 0 ? "-" : unitV.getCountry().getName(), unitV.getCountryId()));
                    });
                    continue block14;
                }
                case 6: {
                    list.add(new DataTableHeaderItem(100, "\u6ede\u5728\u5730\u70b9", dataTableHeaderItem -> this.setWeights(6, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(100, unitV.getSpotId() == 0 ? "-" : unitV.getSpot().getSpot().getName(), unitV.getSpotId()));
                    });
                    continue block14;
                }
                case 7: {
                    list.add(new DataTableHeaderItem(75, "\u884c\u52d5\u529b", dataTableHeaderItem -> this.setWeights(7, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(dataTableRecord.getId());
                        UnitType unitType = unitV.getUnit();
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + unitType.getSpeedRate(), unitType.getSpeedRate()));
                    });
                    continue block14;
                }
                case 8: {
                    list.add(new DataTableHeaderItem(75, "\u653b\u6483\u529b", dataTableHeaderItem -> this.setWeights(8, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(dataTableRecord.getId());
                        UnitType unitType = unitV.getUnit();
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + unitType.getAttackRate(), unitType.getAttackRate()));
                    });
                    continue block14;
                }
                case 9: {
                    list.add(new DataTableHeaderItem(75, "\u9632\u5fa1\u529b", dataTableHeaderItem -> this.setWeights(9, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(dataTableRecord.getId());
                        UnitType unitType = unitV.getUnit();
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + unitType.getDefenseRate(), unitType.getDefenseRate()));
                    });
                    continue block14;
                }
                case 10: {
                    list.add(new DataTableHeaderItem(75, "\u6b8b\u5175\u6570", dataTableHeaderItem -> this.setWeights(10, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + unitV.getLeave(), unitV.getLeave()));
                    });
                    continue block14;
                }
                case 11: {
                    list.add(new DataTableHeaderItem(65, "\u58eb\u6c17", dataTableHeaderItem -> this.setWeights(11, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(65, "" + unitV.getMorale(), unitV.getMorale()));
                    });
                    continue block14;
                }
                case 12: {
                    list.add(new DataTableHeaderItem(75, "\u547d\u4ee4", dataTableHeaderItem -> this.setWeights(12, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, this.getOperationName(unitV), 0));
                    });
                }
            }
        }
    }

    private String getOperationName(UnitV unitV) {
        TacticsAction tacticsAction = this.getGameTemp().getTacticsAction();
        if (tacticsAction != null) {
            TacticsActionEntry tacticsActionEntry = tacticsAction.getCommandMap().get(unitV.getId());
            switch (tacticsActionEntry.getCommandType()) {
                case 2: {
                    return "\u79fb\u52d5";
                }
                case 4: {
                    return "\u89e3\u6563";
                }
                case 3: {
                    return "\u7279\u6280";
                }
            }
            if (unitV.isBattle()) {
                return "\u6226\u95d8";
            }
        }
        return "-";
    }

    @Override
    protected void resetTable() {
        for (DataTableRecord dataTableRecord : this.dataTable.getRecords()) {
            dataTableRecord.setSelected(false);
            dataTableRecord.setDisabled(false);
        }
    }

    protected void clickedUnit(UnitV unitV) {
        if (unitV != null) {
            this.selectedUnit(unitV.getId());
        }
    }

    protected void selectedUnit(int n) {
        this.getGameTemp().setOperationUnitId(n);
        this.getGameTemp().setSubSceneId(1);
    }

    @Override
    protected int getItemIndex(int n) {
        int n2 = -1;
        int[] nArray = this.getUnitsItems();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    @Override
    public void unLoad() {
    }

    @Override
    public void update() {
        super.update();
        this.info.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.info.draw(this.bcontext);
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(1);
    }
}

