/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.sengoku.common.GameCommandCreator;
import game.sengoku.data.CommandV;
import game.sengoku.data.GiantV;
import game.sengoku.data.KnightV;
import game.sengoku.data.PlayerV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.domestic.SceneEmployBase;

public class SceneTreasureKnightSelect
extends SceneEmployBase {
    @Override
    protected String getDefaultMessage() {
        return "\u5bb6\u5b9d\u3092\u4e0e\u3048\u308b\u6b66\u5c06\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044";
    }

    @Override
    protected String getCancelMessage() {
        return "";
    }

    @Override
    protected String getDecideMessage() {
        return "\u3092\u306b\u5bb6\u5b9d\u3092\u4e0e\u3048\u307e\u3059\u304b\uff1f";
    }

    @Override
    protected void loadEmploiedData() {
        this.emploiedKnights.clear();
        this.emploiedGiants.clear();
    }

    @Override
    protected void loadData() {
        this.knights = GameCommandUtil.getKnightTreasures(this.getGameDataV(), this.getPlayer().getDaimyoId());
    }

    @Override
    protected void clickedKnight(KnightV knightV) {
        if (knightV != null) {
            this.selectedKnight(knightV.getId());
        }
    }

    @Override
    protected void clickedGiant(GiantV giantV) {
    }

    @Override
    protected void cancelKnight(int n) {
    }

    @Override
    protected void cancelGiant(int n) {
    }

    @Override
    protected void selectedKnight(int n) {
        int n2 = this.getGameTemp().getSelectedTreasureId();
        PlayerV playerV = this.getPlayer();
        CommandV commandV = GameCommandCreator.commandTreasure(0, n, n2);
        playerV.getCommands().add(commandV);
        this.getGameTemp().setSelectedTreasureId(0);
        this.getGameTemp().setSubSceneId(22);
    }

    @Override
    protected void selectedGiant(int n) {
    }

    @Override
    public void update() {
        super.update();
        this.kindKnight.setVisible(false);
        this.kindGiant.setVisible(false);
    }

    @Override
    protected void updateContent() {
        super.updateContent();
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(0);
    }

    @Override
    protected int costOfKnight(int n) {
        return 0;
    }

    @Override
    protected int costOfGiant(int n) {
        return 0;
    }

    @Override
    protected int[] getKnightsItems() {
        return new int[]{1, 13, 6, 7, 8};
    }

    @Override
    protected int[] getGiantsItems() {
        return new int[0];
    }
}

