/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameTemp;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.GiantV;
import game.sengoku.data.KnightV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.domestic.DomesticResearchUtil;
import game.sengoku.game.domestic.SceneEmployBase;
import game.sengoku.window.ButtonSprite;

public class SceneTechnologyKnightSelect
extends SceneEmployBase {
    private ButtonSprite cancelSelect = new ButtonSprite(50, 500, 100, 300, 30, -256, -52, GameFontUtil.FONT20, "\u7814\u7a76\u3092\u4e2d\u65ad\u3059\u308b", false, MouseSymbolLayerManager.LAYER_NORMAL);

    public SceneTechnologyKnightSelect() {
        this.cancelSelect.setFontColor(-319753729);
        this.cancelSelect.setPrimaryClicked(windowClickable -> this.selectedKnight(0));
    }

    @Override
    protected String getDefaultMessage() {
        return "\u7814\u7a76\u62c5\u5f53\u306b\u4efb\u547d\u3059\u308b\u6b66\u5c06\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044";
    }

    @Override
    protected String getCancelMessage() {
        return "\u306e\u4efb\u547d\u3092\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3059\u304b\uff1f";
    }

    @Override
    protected String getDecideMessage() {
        return "\u3092\u7814\u7a76\u62c5\u5f53\u306b\u4efb\u547d\u3057\u307e\u3059\u304b\uff1f";
    }

    @Override
    protected void loadEmploiedData() {
        this.emploiedKnights.clear();
        this.emploiedGiants.clear();
    }

    @Override
    protected void loadData() {
        this.knights = GameCommandUtil.getKnightResearchs(this.getGameDataV(), this.getPlayer().getDaimyoId(), this.getPlayer());
    }

    @Override
    protected void clickedKnight(KnightV knightV) {
        if (knightV != null) {
            this.selectedKnight(knightV.getId());
        }
    }

    @Override
    protected void clickedGiant(GiantV giantV) {
    }

    @Override
    protected void cancelKnight(int n) {
    }

    @Override
    protected void cancelGiant(int n) {
    }

    @Override
    protected void selectedKnight(int n) {
        GameTemp gameTemp = this.getGameTemp();
        if (n == 0) {
            DomesticResearchUtil.stop(gameTemp.getSelectedTechnologyId(), this.getPlayer());
        } else {
            DomesticResearchUtil.start(gameTemp.getSelectedTechnologyId(), n, this.getPlayer());
        }
        this.forward();
    }

    @Override
    protected void selectedGiant(int n) {
    }

    @Override
    public void update() {
        super.update();
        this.kindKnight.setVisible(false);
        this.kindGiant.setVisible(false);
        this.cancelSelect.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.cancelSelect.draw(this.bcontext);
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(16);
    }

    protected void forward() {
        this.getGameTemp().setSubSceneId(16);
    }

    @Override
    protected int costOfKnight(int n) {
        return 0;
    }

    @Override
    protected int costOfGiant(int n) {
        return 0;
    }

    @Override
    protected int[] getKnightsItems() {
        return new int[]{1, 6, 7, 8, 21};
    }

    @Override
    protected int[] getGiantsItems() {
        return new int[0];
    }
}

