/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.SceneCommon;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowMessage;
import game.sengoku.word.Paragraph;
import game.sengoku.word.Section;
import game.sengoku.word.Subsection;
import game.sengoku.word.Words;
import java.util.ArrayList;
import java.util.List;

public class SceneInfoWords
extends SceneCommon {
    private List<ButtonSprite> wordButtons;
    private WindowMessage explain;
    private int page = 0;

    public SceneInfoWords() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.wordButtons = new ArrayList<ButtonSprite>();
        this.explain = new WindowMessage(20, 380, 100, 760, 200, 877223628, GameFontUtil.FONT16, -269422081, "");
    }

    @Override
    public void load() {
        super.load();
        this.page = 0;
        this.createWordButtons();
        this.updateVisible();
    }

    public Words getWords() {
        return KessenMain.getInstance().getWords();
    }

    private void createWordButtons() {
        this.wordButtons.clear();
        Words words = this.getWords();
        for (Section section : words.getSection()) {
            for (Subsection subsection : section.getSubsection()) {
                ButtonSprite buttonSprite = new ButtonSprite(0, 0, 1000, 100, 22, -256, 1768520959, GameFontUtil.FONT16, subsection.getTitle(), true, MouseSymbolLayerManager.LAYER_NORMAL);
                buttonSprite.setFontColor(-319753729);
                buttonSprite.setMouseEnter(windowClickable -> this.setExplain(subsection));
                this.wordButtons.add(buttonSprite);
            }
        }
    }

    protected void setExplain(Subsection subsection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(subsection.getTitle());
        for (Paragraph paragraph : subsection.getParagraph()) {
            arrayList.add(paragraph.getText());
        }
        this.explain.setMessages(arrayList);
    }

    private void updateVisible() {
        int n = 0;
        for (ButtonSprite buttonSprite : this.wordButtons) {
            buttonSprite.setX(20 + n % 6 * 120);
            buttonSprite.setY(50 + n / 6 * 30);
            ++n;
        }
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(this.getGameTemp().getReturnSubSceneId());
    }

    @Override
    public void unLoad() {
        super.unLoad();
        this.wordButtons.clear();
    }

    @Override
    public void update() {
        super.update();
        this.wordButtons.forEach(buttonSprite -> buttonSprite.update());
        this.explain.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.wordButtons.forEach(buttonSprite -> buttonSprite.draw(this.bcontext));
        this.explain.draw(this.bcontext);
    }
}

