/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.sengoku.common.DataTableHeaderItem;
import game.sengoku.common.DataTableRecord;
import game.sengoku.common.DataTableRecordItem;
import game.sengoku.data.DaimyoV;
import game.sengoku.game.SceneTableCommon;
import java.util.List;
import java.util.stream.Collectors;

public class SceneInfoRanking
extends SceneTableCommon {
    private static final int ROW_MAX = 13;
    private static final int COLUMN_MAX = 8;
    protected static final int ITEM_NAME = 1;
    protected static final int ITEM_FAME = 2;
    protected static final int ITEM_IMPACT = 3;
    protected static final int ITEM_FOOD = 4;
    protected static final int ITEM_COUNTRY = 5;
    protected static final int ITEM_COMMERCE = 6;
    protected static final int ITEM_POPULATION = 7;
    protected static final int ITEM_CULTURE = 8;
    protected static final int ITEM_ARMY = 9;
    protected static final int ITEM_CHRIST = 10;
    protected static final int ITEM_TECHNOLOGIES = 11;
    protected static final int ITEM_CULTURES = 12;
    protected static final int ITEM_MONEY = 13;
    protected static final int ITEM_GUN = 14;
    protected static final int ITEM_HORSE = 15;
    protected static final int ITEM_IRON = 16;
    protected static final int ITEM_GUNPOWDER = 17;
    protected static final int ITEM_SALTPETER = 18;
    protected List<DaimyoV> daimyos;

    @Override
    public void load() {
        super.load();
    }

    protected int[] getDaimyoItems() {
        return new int[]{1, 5, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
    }

    private void loadData() {
        this.daimyos = this.getGameDataV().getDaimyos().values().stream().filter(daimyoV -> !daimyoV.isFall()).collect(Collectors.toList());
    }

    @Override
    protected int getTopY() {
        return 10;
    }

    @Override
    protected int getRowMax() {
        return 13;
    }

    @Override
    protected int getColumnMax() {
        return 8;
    }

    @Override
    protected void createTable() {
        this.loadData();
        this.createTableDaimyos();
        this.dataTable.setFixItem(1);
    }

    protected void createTableDaimyos() {
        List<DataTableHeaderItem> list = this.dataTable.getHeader().getItems();
        list.clear();
        List<DataTableRecord> list2 = this.dataTable.getRecords();
        list2.clear();
        Object object = this.daimyos.iterator();
        while (object.hasNext()) {
            DaimyoV object2 = object.next();
            list2.add(new DataTableRecord(object2.getId()));
        }
        block21: for (Object object3 : object = (Object)this.getDaimyoItems()) {
            switch (object3) {
                case 1: {
                    list.add(new DataTableHeaderItem(120, "\u540d\u524d", dataTableHeaderItem -> this.setWeights(1, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, daimyoV.getName(), dataTableRecord.getId()));
                    });
                    continue block21;
                }
                case 2: {
                    list.add(new DataTableHeaderItem(75, "\u540d\u58f0", dataTableHeaderItem -> this.setWeights(2, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getFame(), daimyoV.getFame()));
                    });
                    continue block21;
                }
                case 3: {
                    list.add(new DataTableHeaderItem(75, "\u6b66\u5a01", dataTableHeaderItem -> this.setWeights(3, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getImpact(), daimyoV.getImpact()));
                    });
                    continue block21;
                }
                case 5: {
                    list.add(new DataTableHeaderItem(75, "\u6240\u5c5e\u56fd", dataTableHeaderItem -> this.setWeights(5, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getCountries().size(), daimyoV.getCountries().size()));
                    });
                    continue block21;
                }
                case 4: {
                    list.add(new DataTableHeaderItem(75, "\u8fb2\u696d", dataTableHeaderItem -> this.setWeights(4, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getFoodAmount(), daimyoV.getFoodAmount()));
                    });
                    continue block21;
                }
                case 6: {
                    list.add(new DataTableHeaderItem(75, "\u5546\u696d", dataTableHeaderItem -> this.setWeights(6, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getCommerce(), daimyoV.getCommerce()));
                    });
                    continue block21;
                }
                case 7: {
                    list.add(new DataTableHeaderItem(75, "\u4eba\u53e3", dataTableHeaderItem -> this.setWeights(7, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getPopulationAmount(), daimyoV.getPopulationAmount()));
                    });
                    continue block21;
                }
                case 8: {
                    list.add(new DataTableHeaderItem(75, "\u6587\u5316", dataTableHeaderItem -> this.setWeights(8, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getCultureArv(), daimyoV.getCultureArv()));
                    });
                    continue block21;
                }
                case 9: {
                    list.add(new DataTableHeaderItem(75, "\u5175\u529b", dataTableHeaderItem -> this.setWeights(9, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getArmyAmount(), daimyoV.getArmyAmount()));
                    });
                    continue block21;
                }
                case 10: {
                    list.add(new DataTableHeaderItem(75, "\u57fa\u7763", dataTableHeaderItem -> this.setWeights(10, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getChrist(), daimyoV.getChrist()));
                    });
                    continue block21;
                }
                case 11: {
                    list.add(new DataTableHeaderItem(75, "\u6280\u8853\u6570", dataTableHeaderItem -> this.setWeights(11, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getTechnologyIds().size(), daimyoV.getTechnologyIds().size()));
                    });
                    continue block21;
                }
                case 12: {
                    list.add(new DataTableHeaderItem(75, "\u6587\u5316\u6570", dataTableHeaderItem -> this.setWeights(12, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getCultureIds().size(), daimyoV.getCultureIds().size()));
                    });
                    continue block21;
                }
                case 13: {
                    list.add(new DataTableHeaderItem(75, "\u91d1\u92ad", dataTableHeaderItem -> this.setWeights(13, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getMoney(), daimyoV.getMoney()));
                    });
                    continue block21;
                }
                case 14: {
                    list.add(new DataTableHeaderItem(75, "\u9244\u7832", dataTableHeaderItem -> this.setWeights(14, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getGun(), daimyoV.getGun()));
                    });
                    continue block21;
                }
                case 15: {
                    list.add(new DataTableHeaderItem(75, "\u99ac", dataTableHeaderItem -> this.setWeights(15, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getHorse(), daimyoV.getHorse()));
                    });
                    continue block21;
                }
                case 16: {
                    list.add(new DataTableHeaderItem(75, "\u9244", dataTableHeaderItem -> this.setWeights(16, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getIron(), daimyoV.getIron()));
                    });
                    continue block21;
                }
                case 17: {
                    list.add(new DataTableHeaderItem(75, "\u706b\u85ac", dataTableHeaderItem -> this.setWeights(17, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getGunpowder(), daimyoV.getGunpowder()));
                    });
                    continue block21;
                }
                case 18: {
                    list.add(new DataTableHeaderItem(75, "\u785d\u77f3", dataTableHeaderItem -> this.setWeights(18, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + daimyoV.getSaltpeter(), daimyoV.getSaltpeter()));
                    });
                }
            }
        }
    }

    @Override
    protected void resetTable() {
        for (DataTableRecord dataTableRecord : this.dataTable.getRecords()) {
            dataTableRecord.setSelected(false);
            dataTableRecord.setDisabled(false);
        }
    }

    @Override
    protected int getItemIndex(int n) {
        int n2 = -1;
        int[] nArray = this.getDaimyoItems();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    @Override
    public void unLoad() {
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(this.getGameTemp().getReturnSubSceneId());
    }
}

