/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.RelationUtil;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameData;
import game.sengoku.data.Justice;
import game.sengoku.data.RelationV;
import game.sengoku.data.UnmodifiableReration;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.CountrySelectButton;
import game.sengoku.window.WindowCountryDetailInfo;
import game.sengoku.window.WindowCountryInfo;
import game.sengoku.window.WindowDaimyoDetailInfo;
import game.sengoku.window.WindowDaimyoInfo;
import game.sengoku.window.WindowJusticeInfo;
import game.sengoku.window.WindowRelationInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SceneInfoDetail
extends SceneCommon {
    private static final int COUNTRY_INFO = 1;
    private static final int DAIMYO_INFO = 2;
    private static final int RELATION_INFO = 3;
    private static final int JUSTICE_INFO = 4;
    private static final int RELATION_ALLIANCE = 1;
    private static final int RELATION_FRIENDSHIP = 2;
    private Texture minimap;
    private List<CountrySelectButton> countryInfoButtons;
    private List<CountrySelectButton> daimyoInfoButtons;
    private List<CountrySelectButton> relationInfoButtons;
    private List<CountrySelectButton> justiceInfoButtons;
    private ButtonSprite countryInfoSelect;
    private ButtonSprite daimyoInfoSelect;
    private ButtonSprite relationInfoSelect;
    private ButtonSprite justiceInfoSelect;
    private ButtonSprite relationAlliance;
    private ButtonSprite relationFriendShip;
    private WindowCountryInfo countryInfoWindow;
    private WindowDaimyoInfo daimyoInfoWindow;
    private WindowRelationInfo relationInfoWindow;
    private WindowJusticeInfo justiceInfoWindow;
    private WindowCountryDetailInfo windowCountryDetailInfo;
    private WindowDaimyoDetailInfo windowDaimyoDetailInfo;
    private Map<Integer, List<Justice>> justiceMap;
    private int mode = -1;
    private int submode = -1;
    private int mouseIgnore = 0;
    private int lastDaimyoId = 0;

    public SceneInfoDetail() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        GameData gameData = this.getGameData();
        this.minimap = (Texture)graphicPool.getResource(gameData.getMap().getImageMini());
        this.countryInfoButtons = new ArrayList<CountrySelectButton>();
        this.daimyoInfoButtons = new ArrayList<CountrySelectButton>();
        this.relationInfoButtons = new ArrayList<CountrySelectButton>();
        this.justiceInfoButtons = new ArrayList<CountrySelectButton>();
        this.countryInfoSelect = new ButtonSprite(130, 410, 100, 60, 30, 65484, 1768520959, GameFontUtil.FONT22, "\u56fd", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.countryInfoSelect.setPrimaryClicked(windowClickable -> this.setMode(1));
        this.countryInfoSelect.setFontColor(-319753729);
        this.daimyoInfoSelect = new ButtonSprite(290, 410, 100, 60, 30, 65484, 1768520959, GameFontUtil.FONT22, "\u5927\u540d", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.daimyoInfoSelect.setPrimaryClicked(windowClickable -> this.setMode(2));
        this.daimyoInfoSelect.setFontColor(-319753729);
        this.relationInfoSelect = new ButtonSprite(450, 410, 100, 60, 30, 65484, 1768520959, GameFontUtil.FONT22, "\u5916\u4ea4", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.relationInfoSelect.setPrimaryClicked(windowClickable -> this.setMode(3));
        this.relationInfoSelect.setFontColor(-319753729);
        this.justiceInfoSelect = new ButtonSprite(610, 410, 100, 100, 30, 65484, 1768520959, GameFontUtil.FONT22, "\u5927\u7fa9\u540d\u5206", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.justiceInfoSelect.setPrimaryClicked(windowClickable -> this.setMode(4));
        this.justiceInfoSelect.setFontColor(-319753729);
        this.relationAlliance = new ButtonSprite(710, 40, 200, 80, 25, -235801635, 1768520959, GameFontUtil.FONT16, "\u5916\u4ea4\u95a2\u4fc2", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.relationAlliance.setPrimaryClicked(windowClickable -> this.setMode(3, 1));
        this.relationAlliance.setFontColor(255);
        this.relationFriendShip = new ButtonSprite(710, 70, 200, 80, 25, -235801635, 1768520959, GameFontUtil.FONT16, "\u53cb\u597d\u5ea6", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.relationFriendShip.setPrimaryClicked(windowClickable -> this.setMode(3, 2));
        this.relationFriendShip.setFontColor(255);
        this.countryInfoWindow = new WindowCountryInfo(50, 450, 10, 700, 140, 0, "", this.getGameDataV(), this.getPlayer());
        this.daimyoInfoWindow = new WindowDaimyoInfo(50, 450, 10, 700, 140, 0, "", this.getGameDataV(), this.getPlayer());
        this.relationInfoWindow = new WindowRelationInfo(50, 450, 10, 700, 140, 0, "", this.getGameDataV());
        this.justiceInfoWindow = new WindowJusticeInfo(50, 450, 10, 700, 140, 0, "", this.getGameDataV(), this.getPlayer());
        this.windowCountryDetailInfo = new WindowCountryDetailInfo(50, 20, 200, 700, 500, this.getGameDataV(), this.getPlayer());
        this.windowCountryDetailInfo.onClose(windowClickable -> this.closeMiddle());
        this.windowDaimyoDetailInfo = new WindowDaimyoDetailInfo(50, 20, 200, 700, 500, this.getGameDataV(), this.getPlayer());
        this.windowDaimyoDetailInfo.onClose(windowClickable -> this.closeMiddle());
        this.justiceMap = new HashMap<Integer, List<Justice>>();
    }

    @Override
    public void load() {
        super.load();
        this.countryInfoWindow.setCountryId(-1);
        this.daimyoInfoWindow.setDaimyoId(-1);
        this.relationInfoWindow.setDaimyoId(-1);
        this.justiceInfoWindow.setDaimyoId(-1);
        this.mode = -1;
        this.submode = -1;
        this.lastDaimyoId = this.getPlayer().getDaimyoId();
        this.setMode(1, 1);
    }

    public void setMode(int n) {
        this.setMode(n, this.submode);
    }

    public void setMode(int n, int n2) {
        if (this.mode != n || this.submode != n2) {
            this.mode = n;
            this.submode = n2;
            switch (n) {
                case 1: {
                    this.createCountryInfo();
                    this.updateVisible();
                    break;
                }
                case 2: {
                    this.createDaimyoInfo();
                    this.updateVisible();
                    break;
                }
                case 3: {
                    this.createRelationInfo();
                    this.updateVisible();
                    break;
                }
                case 4: {
                    this.createJusticeInfo();
                    this.updateVisible();
                }
            }
        }
    }

    private void updateVisible() {
        if (this.getMiddleWindow() == null) {
            block0 : switch (this.mode) {
                case 1: {
                    this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(true));
                    this.daimyoInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
                    this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
                    this.justiceInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
                    this.countryInfoWindow.setVisible(true);
                    this.daimyoInfoWindow.setVisible(false);
                    this.relationInfoWindow.setVisible(false);
                    this.justiceInfoWindow.setVisible(false);
                    this.countryInfoSelect.setVisible(true);
                    this.daimyoInfoSelect.setVisible(true);
                    this.relationInfoSelect.setVisible(true);
                    this.justiceInfoSelect.setVisible(true);
                    this.countryInfoSelect.setNormalColor(1768520959);
                    this.daimyoInfoSelect.setNormalColor(65484);
                    this.relationInfoSelect.setNormalColor(65484);
                    this.justiceInfoSelect.setNormalColor(65484);
                    this.relationAlliance.setVisible(false);
                    this.relationFriendShip.setVisible(false);
                    break;
                }
                case 2: {
                    this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
                    this.daimyoInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(true));
                    this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
                    this.justiceInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
                    this.countryInfoWindow.setVisible(false);
                    this.daimyoInfoWindow.setVisible(true);
                    this.relationInfoWindow.setVisible(false);
                    this.justiceInfoWindow.setVisible(false);
                    this.countryInfoSelect.setVisible(true);
                    this.daimyoInfoSelect.setVisible(true);
                    this.relationInfoSelect.setVisible(true);
                    this.justiceInfoSelect.setVisible(true);
                    this.countryInfoSelect.setNormalColor(65484);
                    this.daimyoInfoSelect.setNormalColor(1768520959);
                    this.relationInfoSelect.setNormalColor(65484);
                    this.justiceInfoSelect.setNormalColor(65484);
                    this.relationAlliance.setVisible(false);
                    this.relationFriendShip.setVisible(false);
                    break;
                }
                case 3: {
                    this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
                    this.daimyoInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
                    this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(true));
                    this.justiceInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
                    this.countryInfoWindow.setVisible(false);
                    this.daimyoInfoWindow.setVisible(false);
                    this.relationInfoWindow.setVisible(true);
                    this.justiceInfoWindow.setVisible(false);
                    this.countryInfoSelect.setVisible(true);
                    this.daimyoInfoSelect.setVisible(true);
                    this.relationInfoSelect.setVisible(true);
                    this.justiceInfoSelect.setVisible(true);
                    this.countryInfoSelect.setNormalColor(65484);
                    this.daimyoInfoSelect.setNormalColor(65484);
                    this.relationInfoSelect.setNormalColor(1768520959);
                    this.relationInfoWindow.setDaimyoId(this.lastDaimyoId);
                    this.justiceInfoSelect.setNormalColor(65484);
                    this.relationAlliance.setVisible(true);
                    this.relationFriendShip.setVisible(true);
                    switch (this.submode) {
                        case 1: {
                            this.relationAlliance.setNormalColor(1768520959);
                            this.relationFriendShip.setNormalColor(-235801635);
                            break block0;
                        }
                        case 2: {
                            this.relationAlliance.setNormalColor(-235801635);
                            this.relationFriendShip.setNormalColor(1768520959);
                        }
                    }
                    break;
                }
                case 4: {
                    this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
                    this.daimyoInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
                    this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
                    this.justiceInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(true));
                    this.countryInfoWindow.setVisible(false);
                    this.daimyoInfoWindow.setVisible(false);
                    this.relationInfoWindow.setVisible(false);
                    this.justiceInfoWindow.setVisible(true);
                    this.countryInfoSelect.setVisible(true);
                    this.daimyoInfoSelect.setVisible(true);
                    this.relationInfoSelect.setVisible(true);
                    this.justiceInfoSelect.setVisible(true);
                    this.countryInfoSelect.setNormalColor(65484);
                    this.daimyoInfoSelect.setNormalColor(65484);
                    this.relationInfoSelect.setNormalColor(65484);
                    this.justiceInfoSelect.setNormalColor(1768520959);
                    this.relationAlliance.setVisible(false);
                    this.relationFriendShip.setVisible(false);
                }
            }
        } else {
            this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
            this.daimyoInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
            this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
            this.justiceInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(false));
            this.countryInfoWindow.setVisible(false);
            this.daimyoInfoWindow.setVisible(false);
            this.relationInfoWindow.setVisible(false);
            this.justiceInfoWindow.setVisible(false);
            this.countryInfoSelect.setVisible(false);
            this.daimyoInfoSelect.setVisible(false);
            this.relationInfoSelect.setVisible(false);
            this.justiceInfoSelect.setVisible(false);
            this.relationAlliance.setVisible(false);
            this.relationFriendShip.setVisible(false);
        }
    }

    private void createCountryInfo() {
        this.countryInfoButtons.clear();
        for (CountryV countryV : this.getGameDataV().getCountries().values()) {
            int n = this.getColor(countryV);
            CountrySelectButton countrySelectButton = new CountrySelectButton(countryV.getCountry(), this.getGameDataV(), n, n);
            countrySelectButton.setMouseEnter(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                this.countryInfoWindow.setCountryId(countryV.getId());
            });
            countrySelectButton.setMouseExit(windowClickable -> this.countryInfoWindow.setCountryId(-1));
            countrySelectButton.setPrimaryClicked(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                if (countryV != null) {
                    this.countryClicked(countryV);
                }
            });
            this.countryInfoButtons.add(countrySelectButton);
        }
    }

    protected void countryClicked(CountryV countryV) {
        this.windowCountryDetailInfo.setCountryId(countryV.getId());
        this.windowCountryDetailInfo.setVisible(true);
        this.setMiddleWindow(this.windowCountryDetailInfo);
        this.updateVisible();
    }

    protected int getColor(CountryV countryV) {
        return countryV.getDaimyo().getColor();
    }

    private void createDaimyoInfo() {
        this.daimyoInfoButtons.clear();
        for (DaimyoV daimyoV : this.getGameDataV().getDaimyos().values()) {
            if (daimyoV.isFall()) continue;
            int n = this.getColor(daimyoV);
            CountrySelectButton countrySelectButton = new CountrySelectButton(((CountryV)daimyoV.getCountries().get(0)).getCountry(), this.getGameDataV(), n, n);
            countrySelectButton.setMouseEnter(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                this.daimyoInfoWindow.setDaimyoId(countryV.getDaimyoId());
            });
            countrySelectButton.setMouseExit(windowClickable -> this.daimyoInfoWindow.setDaimyoId(-1));
            countrySelectButton.setPrimaryClicked(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                if (countryV != null) {
                    this.daimyoClicked(countryV.getDaimyo());
                }
            });
            this.daimyoInfoButtons.add(countrySelectButton);
        }
    }

    protected void daimyoClicked(DaimyoV daimyoV) {
        this.windowDaimyoDetailInfo.setDaimyoId(daimyoV.getId());
        this.windowDaimyoDetailInfo.setVisible(true);
        this.setMiddleWindow(this.windowDaimyoDetailInfo);
        this.updateVisible();
    }

    protected int getColor(DaimyoV daimyoV) {
        return daimyoV.getColor();
    }

    private void createRelationInfo() {
        this.relationInfoButtons.clear();
        for (DaimyoV daimyoV : this.getGameDataV().getDaimyos().values()) {
            if (daimyoV.isFall()) continue;
            int n = this.getColor(daimyoV);
            CountrySelectButton countrySelectButton = new CountrySelectButton(((CountryV)daimyoV.getCountries().get(0)).getCountry(), this.getGameDataV(), n, n);
            countrySelectButton.setMouseEnter(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                this.relationInfoWindow.setTargetDaimyoId(countryV.getDaimyoId());
            });
            countrySelectButton.setMouseExit(windowClickable -> this.relationInfoWindow.setTargetDaimyoId(-1));
            countrySelectButton.setPrimaryClicked(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                if (countryV != null) {
                    this.relationClicked(countryV.getDaimyo());
                }
            });
            this.relationInfoButtons.add(countrySelectButton);
        }
        this.getRelationColors(this.lastDaimyoId);
    }

    protected void relationClicked(DaimyoV daimyoV) {
        this.lastDaimyoId = daimyoV.getId();
        this.relationInfoWindow.setDaimyoId(daimyoV.getId());
        this.getRelationColors(daimyoV.getId());
    }

    protected void getRelationColors(int n) {
        this.relationInfoWindow.setDaimyoId(n);
        this.relationInfoButtons.forEach(countrySelectButton -> {
            CountryV countryV = countrySelectButton.getCountryV();
            UnmodifiableReration unmodifiableReration = this.getGameDataV().getRelation(countryV.getDaimyoId(), n);
            int n2 = 0;
            n2 = this.submode == 1 ? RelationUtil.relationColor(unmodifiableReration) : RelationUtil.friendShipColor(unmodifiableReration);
            countrySelectButton.setNormalColor(n2);
            countrySelectButton.setOverColor(n2);
        });
    }

    protected int getColor(RelationV relationV) {
        return 65535;
    }

    private void createJusticeInfo() {
        this.justiceInfoButtons.clear();
        this.justiceMap.clear();
        for (DaimyoV daimyoV : this.getGameDataV().getDaimyos().values()) {
            if (daimyoV.isFall() || this.getDaimyo().getId() == daimyoV.getId()) continue;
            List list = this.getGameDataV().getJusticeList(this.getDaimyo().getId(), daimyoV.getId());
            this.justiceMap.put(daimyoV.getId(), list);
            int n = list.isEmpty() ? -1717986817 : -872362753;
            CountrySelectButton countrySelectButton = new CountrySelectButton(((CountryV)daimyoV.getCountries().get(0)).getCountry(), this.getGameDataV(), n, n);
            countrySelectButton.setMouseEnter(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                this.justiceInfoWindow.setDaimyoId(countryV.getDaimyoId());
            });
            countrySelectButton.setMouseExit(windowClickable -> this.justiceInfoWindow.setDaimyoId(-1));
            this.justiceInfoButtons.add(countrySelectButton);
        }
        this.justiceInfoWindow.setJusticeMap(this.justiceMap);
    }

    @Override
    protected void exit() {
        if (this.getMiddleWindow() == null) {
            if (this.mouseIgnore <= 0) {
                this.getGameTemp().setSubSceneId(this.getGameTemp().getReturnSubSceneId());
            }
        } else {
            this.closeMiddle();
        }
    }

    protected void closeMiddle() {
        this.windowCountryDetailInfo.setVisible(false);
        this.windowDaimyoDetailInfo.setVisible(false);
        this.setMiddleWindow(null);
        this.updateVisible();
        this.mouseIgnore = 3;
    }

    @Override
    public void unLoad() {
        super.unLoad();
        this.countryInfoButtons.clear();
        this.daimyoInfoButtons.clear();
        this.relationInfoButtons.clear();
        this.justiceInfoButtons.clear();
    }

    @Override
    public void update() {
        super.update();
        this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.update());
        this.daimyoInfoButtons.forEach(countrySelectButton -> countrySelectButton.update());
        this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.update());
        this.justiceInfoButtons.forEach(countrySelectButton -> countrySelectButton.update());
        this.countryInfoSelect.update();
        this.daimyoInfoSelect.update();
        this.relationInfoSelect.update();
        this.justiceInfoSelect.update();
        this.relationAlliance.update();
        this.relationFriendShip.update();
        this.countryInfoWindow.update();
        this.daimyoInfoWindow.update();
        this.relationInfoWindow.update();
        this.justiceInfoWindow.update();
        if (0 < this.mouseIgnore) {
            --this.mouseIgnore;
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        if (this.getMiddleWindow() == null) {
            this.bcontext.drawImage(this.minimap, 150, 10, 10);
        }
        this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.draw(this.bcontext));
        this.daimyoInfoButtons.forEach(countrySelectButton -> countrySelectButton.draw(this.bcontext));
        this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.draw(this.bcontext));
        this.justiceInfoButtons.forEach(countrySelectButton -> countrySelectButton.draw(this.bcontext));
        this.countryInfoSelect.draw(this.bcontext);
        this.daimyoInfoSelect.draw(this.bcontext);
        this.relationInfoSelect.draw(this.bcontext);
        this.justiceInfoSelect.draw(this.bcontext);
        this.relationAlliance.draw(this.bcontext);
        this.relationFriendShip.draw(this.bcontext);
        this.countryInfoWindow.draw(this.bcontext);
        this.daimyoInfoWindow.draw(this.bcontext);
        this.relationInfoWindow.draw(this.bcontext);
        this.justiceInfoWindow.draw(this.bcontext);
    }
}

