/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.sengoku.common.GameCommandCreator;
import game.sengoku.data.CommandV;
import game.sengoku.data.GiantV;
import game.sengoku.data.KnightV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.SpotV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.domestic.SceneEmployBase;

public class SceneEmploySelect
extends SceneEmployBase {
    public SceneEmploySelect() {
        this.commandKindKnight = 6;
        this.commandKindGiant = 7;
    }

    @Override
    protected void loadData() {
        this.knights = GameCommandUtil.getKnightEmploies(this.getGameDataV(), this.getPlayer().getDaimyoId());
        this.giants = GameCommandUtil.getGiantEmploies(this.getGameDataV(), this.getPlayer().getDaimyoId());
    }

    @Override
    protected void selectedKnight(int n) {
        PlayerV playerV = this.getPlayer();
        KnightV knightV = (KnightV)this.getGameDataV().getKnights().get(n);
        SpotV spotV = (SpotV)this.getGameDataV().getSpots().get(knightV.getSpotId());
        CommandV commandV = GameCommandCreator.commandEmployKnight(this.costOfKnight(n), n, spotV.getCountryId());
        playerV.getCommands().add(commandV);
        this.forceReLoad();
    }

    @Override
    protected void selectedGiant(int n) {
        PlayerV playerV = this.getPlayer();
        GiantV giantV = (GiantV)this.getGameDataV().getGiants().get(n);
        SpotV spotV = (SpotV)this.getGameDataV().getSpots().get(giantV.getSpotId());
        CommandV commandV = GameCommandCreator.commandEmployGiant(this.costOfGiant(n), n, spotV.getCountryId());
        playerV.getCommands().add(commandV);
        this.forceReLoad();
    }

    @Override
    protected int costOfKnight(int n) {
        KnightV knightV = (KnightV)this.getGameDataV().getKnights().get(n);
        return knightV.getHeadPay();
    }

    @Override
    protected int costOfGiant(int n) {
        GiantV giantV = (GiantV)this.getGameDataV().getGiants().get(n);
        return giantV.getHeadPay();
    }

    @Override
    protected int[] getKnightsItems() {
        return new int[]{1, 4, 10, 11, 6, 7, 8};
    }

    @Override
    protected int[] getGiantsItems() {
        return new int[]{1, 25, 4, 10, 11, 22, 23, 24};
    }
}

