/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.GiantV;
import game.sengoku.data.KnightV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.domestic.SceneEmployBase;
import game.sengoku.window.ButtonSprite;

public class SceneAssignSelect
extends SceneEmployBase {
    protected ButtonSprite commit = new ButtonSprite(500, 550, 100, 75, 25, -235801635, 1768520959, GameFontUtil.FONT20, "\u6c7a\u5b9a", true, MouseSymbolLayerManager.LAYER_NORMAL);

    public SceneAssignSelect() {
        this.commit.setPrimaryClicked(windowClickable -> this.commit());
    }

    @Override
    protected String getDefaultMessage() {
        return "\u914d\u5c5e\u3059\u308b\u6b66\u5c06\u3001\u6587\u5316\u4eba\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044";
    }

    @Override
    protected String getCancelMessage() {
        return "\u306e\u914d\u5c5e\u3092\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3059\u304b\uff1f";
    }

    @Override
    protected String getDecideMessage() {
        return "\u3092\u914d\u5c5e\u3057\u307e\u3059\u304b\uff1f";
    }

    protected void commit() {
        this.getGameTemp().getAssignKnightIds().clear();
        this.getGameTemp().getAssignKnightIds().addAll(this.emploiedKnights);
        this.getGameTemp().getAssignGiantIds().clear();
        this.getGameTemp().getAssignGiantIds().addAll(this.emploiedGiants);
        this.getGameTemp().setSubSceneId(8);
    }

    @Override
    protected void loadEmploiedData() {
        this.emploiedKnights.clear();
        this.emploiedGiants.clear();
        this.emploiedKnights.addAll(this.getGameTemp().getAssignKnightIds());
        this.emploiedGiants.addAll(this.getGameTemp().getAssignGiantIds());
        this.getGameTemp().getAssignKnightIds().clear();
        this.getGameTemp().getAssignGiantIds().clear();
    }

    @Override
    protected void loadData() {
        this.getGameTemp().getAssignKnightIds().clear();
        this.getGameTemp().getAssignGiantIds().clear();
        int n = this.getGameTemp().getAssignSelectedCountryId();
        this.knights = GameCommandUtil.getKnightAssigns(this.getGameDataV(), this.getPlayer().getDaimyoId(), n);
        this.giants = GameCommandUtil.getGiantAssigns(this.getGameDataV(), this.getPlayer().getDaimyoId(), n);
    }

    @Override
    protected void clickedKnight(KnightV knightV) {
        if (knightV != null) {
            if (this.emploiedKnights.contains(knightV.getId())) {
                this.cancelKnight(knightV.getId());
            } else {
                this.selectedKnight(knightV.getId());
            }
        }
    }

    @Override
    protected void clickedGiant(GiantV giantV) {
        if (giantV != null) {
            if (this.emploiedGiants.contains(giantV.getId())) {
                this.cancelGiant(giantV.getId());
            } else {
                this.selectedGiant(giantV.getId());
            }
        }
    }

    @Override
    protected void cancelKnight(int n) {
        this.emploiedKnights.removeIf(n2 -> n2 == n);
    }

    @Override
    protected void cancelGiant(int n) {
        this.emploiedGiants.removeIf(n2 -> n2 == n);
    }

    @Override
    protected void selectedKnight(int n) {
        if (!this.emploiedKnights.contains(n)) {
            this.emploiedKnights.add(n);
        }
    }

    @Override
    protected void selectedGiant(int n) {
        if (!this.emploiedGiants.contains(n)) {
            this.emploiedGiants.add(n);
        }
    }

    @Override
    public void update() {
        super.update();
        this.commit.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.commit.draw(this.bcontext);
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(6);
    }

    @Override
    protected int costOfKnight(int n) {
        return 0;
    }

    @Override
    protected int costOfGiant(int n) {
        return 0;
    }

    @Override
    protected int[] getKnightsItems() {
        return new int[]{1, 13, 11, 6, 7, 8};
    }

    @Override
    protected int[] getGiantsItems() {
        return new int[]{1, 11, 22, 23, 24};
    }
}

