/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy.semiscene;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.game.GameDiplomacyUtil;
import game.sengoku.game.diplomacy.NegotiationAction;
import game.sengoku.game.diplomacy.NegotiationActionEntry;
import game.sengoku.game.diplomacy.semiscene.SemiScene;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowMessage;
import java.util.List;

public class SemiSceneAlliance
extends SemiScene {
    private WindowMessage info;
    private ButtonSprite rental;
    private ButtonSprite rentalReturn;
    private ButtonSprite enemy;
    private ButtonSprite breakWith;
    private ButtonSprite toubatsu;

    public SemiSceneAlliance() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        int n = 1;
        this.rental = new ButtonSprite(75, 20 + 40 * n, 100, 90, 30, -256, 1768520959, GameFontUtil.FONT16, "\u4eba\u8cea", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.rental.setPrimaryClicked(windowClickable -> this.rental());
        this.rental.setMouseEnter(windowClickable -> this.info.setMessages("\u4eba\u8cea\u3092\u8981\u6c42\u3057\u307e\u3059"));
        this.rental.setFontColor(-319753729);
        this.rentalReturn = new ButtonSprite(75, 20 + 40 * ++n, 100, 90, 30, -256, 1768520959, GameFontUtil.FONT16, "\u4eba\u8cea\u8fd4\u9084", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.rentalReturn.setPrimaryClicked(windowClickable -> this.rentalReturn());
        this.rentalReturn.setMouseEnter(windowClickable -> this.info.setMessages("\u4eba\u8cea\u3092\u8fd4\u9084\u3057\u307e\u3059"));
        this.rentalReturn.setFontColor(-319753729);
        this.enemy = new ButtonSprite(75, 20 + 40 * ++n, 100, 90, 30, -256, 1768520959, GameFontUtil.FONT16, "\u6575\u5bfe", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.enemy.setPrimaryClicked(windowClickable -> this.enemy());
        this.enemy.setMouseEnter(windowClickable -> this.info.setMessages("\u7279\u5b9a\u306e\u5927\u540d\u5bb6\u3068\u6575\u5bfe\u3057\u3066\u3082\u3089\u3044\u307e\u3059"));
        this.enemy.setFontColor(-319753729);
        this.breakWith = new ButtonSprite(75, 20 + 40 * ++n, 100, 90, 30, -256, 1768520959, GameFontUtil.FONT16, "\u624b\u5207\u308a", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.breakWith.setPrimaryClicked(windowClickable -> this.breakWith());
        this.breakWith.setMouseEnter(windowClickable -> this.info.setMessages("\u540c\u76df\u4e2d\u306e\u5927\u540d\u5bb6\u3068\u624b\u3092\u5207\u3063\u3066\u3082\u3089\u3044\u307e\u3059"));
        this.breakWith.setFontColor(-319753729);
        this.toubatsu = new ButtonSprite(75, 20 + 40 * ++n, 100, 90, 30, -256, 1768520959, GameFontUtil.FONT16, "\u8a0e\u4f10", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.toubatsu.setPrimaryClicked(windowClickable -> this.toubatsu());
        this.toubatsu.setMouseEnter(windowClickable -> this.info.setMessages("\u7279\u5b9a\u306e\u5927\u540d\u5bb6\u306b\u8a0e\u4f10\u4ee4\u3092\u51fa\u3057\u3066\u3082\u3089\u3044\u307e\u3059"));
        this.toubatsu.setFontColor(-319753729);
        this.info = new WindowMessage(50, 450, 10, 600, 140);
    }

    @Override
    public void load() {
        super.load();
        this.updateFontColor();
        this.updateActives();
    }

    @Override
    public void unLoad() {
        super.unLoad();
    }

    @Override
    public void update() {
        super.update();
        this.info.update();
        this.rental.update();
        this.rentalReturn.update();
        this.enemy.update();
        this.breakWith.update();
        this.toubatsu.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.info.draw(this.bcontext);
        this.rental.draw(this.bcontext);
        this.rentalReturn.draw(this.bcontext);
        this.enemy.draw(this.bcontext);
        this.breakWith.draw(this.bcontext);
        this.toubatsu.draw(this.bcontext);
    }

    @Override
    protected void exit() {
    }

    private void rental() {
        if (this.getEntry().getRentalKnightIds().isEmpty()) {
            List<Integer> list = GameDiplomacyUtil.getKnightRentalIds(this.getGameDataV(), this.getGameTemp().getNegotiationEditDaimyoId());
            this.getGameTemp().getCandidateObjectIds().clear();
            this.getGameTemp().getCandidateObjectIds().addAll(list);
            this.getGameTemp().setCallBack(n -> {
                NegotiationActionEntry negotiationActionEntry = this.getEntry();
                negotiationActionEntry.getRentalKnightIds().add((Integer)n);
            });
            this.getGameTemp().setSubSceneId(4);
        } else {
            this.getEntry().getRentalKnightIds().clear();
        }
    }

    private void rentalReturn() {
        if (this.getEntry().getRentalReturnKnightIds().isEmpty()) {
            List<Integer> list = GameDiplomacyUtil.getKnightRentalReturn(this.getGameDataV(), this.getGameTemp().getNegotiationEditDaimyoId(), this.receiveDaimyoId());
            this.getGameTemp().getCandidateObjectIds().clear();
            this.getGameTemp().getCandidateObjectIds().addAll(list);
            this.getGameTemp().setCallBack(n -> {
                NegotiationActionEntry negotiationActionEntry = this.getEntry();
                negotiationActionEntry.getRentalReturnKnightIds().add((Integer)n);
            });
            this.getGameTemp().setSubSceneId(4);
        } else {
            this.getEntry().getRentalReturnKnightIds().clear();
        }
    }

    private void enemy() {
        if (this.getEntry().getEnemyToIds().isEmpty()) {
            List<Integer> list = GameDiplomacyUtil.getEnemyDaimyoIds(this.getGameDataV(), this.getGameTemp().getNegotiationEditDaimyoId(), this.receiveDaimyoId());
            this.getGameTemp().getCandidateObjectIds().clear();
            this.getGameTemp().getCandidateObjectIds().addAll(list);
            this.getGameTemp().setCallBack(n -> {
                NegotiationActionEntry negotiationActionEntry = this.getEntry();
                negotiationActionEntry.getEnemyToIds().add((Integer)n);
            });
            this.getGameTemp().setSubSceneId(3);
        } else {
            this.getEntry().getEnemyToIds().clear();
        }
    }

    private void breakWith() {
        if (this.getEntry().getBreakIds().isEmpty()) {
            List<Integer> list = GameDiplomacyUtil.getBreakDaimyoIds(this.getGameDataV(), this.getGameTemp().getNegotiationEditDaimyoId(), this.receiveDaimyoId());
            this.getGameTemp().getCandidateObjectIds().clear();
            this.getGameTemp().getCandidateObjectIds().addAll(list);
            this.getGameTemp().setCallBack(n -> {
                NegotiationActionEntry negotiationActionEntry = this.getEntry();
                negotiationActionEntry.getBreakIds().add((Integer)n);
            });
            this.getGameTemp().setSubSceneId(3);
        } else {
            this.getEntry().getBreakIds().clear();
        }
    }

    private void toubatsu() {
        if (this.getEntry().getToubatsuToIds().isEmpty()) {
            List<Integer> list = GameDiplomacyUtil.getToubatsuDaimyoIds(this.getGameDataV(), this.receiveDaimyoId());
            this.getGameTemp().getCandidateObjectIds().clear();
            this.getGameTemp().getCandidateObjectIds().addAll(list);
            this.getGameTemp().setCallBack(n -> {
                NegotiationActionEntry negotiationActionEntry = this.getEntry();
                negotiationActionEntry.getToubatsuToIds().add((Integer)n);
            });
            this.getGameTemp().setSubSceneId(3);
        } else {
            this.getEntry().getToubatsuToIds().clear();
        }
    }

    private void updateActives() {
        this.rental.setVisible(false);
        this.rentalReturn.setVisible(false);
        this.enemy.setVisible(false);
        this.breakWith.setVisible(false);
        this.toubatsu.setVisible(false);
        if (this.getGameTemp().getNegotiationEditDaimyoId() == this.getDaimyo().getId()) {
            this.rentalReturn.setVisible(GameDiplomacyUtil.canReturnRental(this.getGameDataV(), this.receiveDaimyoId(), this.getGameTemp().getNegotiationEditDaimyoId()));
        } else {
            this.rental.setVisible(GameDiplomacyUtil.canRental(this.getGameDataV(), this.receiveDaimyoId(), this.getGameTemp().getNegotiationEditDaimyoId()));
            this.enemy.setVisible(GameDiplomacyUtil.canEnemyToRequest(this.getGameDataV(), this.receiveDaimyoId(), this.getGameTemp().getNegotiationEditDaimyoId()));
            this.breakWith.setVisible(GameDiplomacyUtil.canBreakAllianceRequest(this.getGameDataV(), this.receiveDaimyoId(), this.getGameTemp().getNegotiationEditDaimyoId()));
            this.toubatsu.setVisible(GameDiplomacyUtil.canToubatsuRequest(this.getGameDataV(), this.receiveDaimyoId(), this.getGameTemp().getNegotiationEditDaimyoId()));
        }
    }

    private void updateFontColor() {
        NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
        if (!this.getEntry().getRentalKnightIds().isEmpty()) {
            this.rental.setFontColor(-69579521);
        } else {
            this.rental.setFontColor(-319753729);
        }
        if (!this.getEntry().getRentalReturnKnightIds().isEmpty()) {
            this.rentalReturn.setFontColor(-69579521);
        } else {
            this.rentalReturn.setFontColor(-319753729);
        }
        if (!this.getEntry().getEnemyToIds().isEmpty()) {
            this.enemy.setFontColor(-69579521);
        } else {
            this.enemy.setFontColor(-319753729);
        }
        if (!this.getEntry().getBreakIds().isEmpty()) {
            this.breakWith.setFontColor(-69579521);
        } else {
            this.breakWith.setFontColor(-319753729);
        }
        if (!this.getEntry().getToubatsuToIds().isEmpty()) {
            this.toubatsu.setFontColor(-69579521);
        } else {
            this.toubatsu.setFontColor(-319753729);
        }
    }
}

