/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.GameDataObject;
import game.sengoku.data.Present;
import game.sengoku.data.StoreV;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.Treasure;
import game.sengoku.data.TreasureV;
import game.sengoku.game.diplomacy.StoreAction;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.GameDataObjectButton;
import game.sengoku.window.PresentButton;
import game.sengoku.window.WindowMessage;
import game.sengoku.window.WindowMoney;
import game.sengoku.window.WindowStoreEntry;
import game.sengoku.window.WindowStoreResource;
import game.sengoku.window.WindowTechnology;
import game.sengoku.window.WindowTechnologyForStore;
import game.sengoku.window.WindowTreasure;
import java.util.ArrayList;
import java.util.List;

public class SceneStoreAmountSelect
extends SceneCommon {
    protected static final int TYPE_RESOURCE = 1;
    protected static final int TYPE_TREASURE = 2;
    protected static final int TYPE_TECHNOLOGY = 3;
    protected ButtonSprite kindResource;
    protected ButtonSprite kindTreasure;
    protected ButtonSprite kindTechnology;
    protected ButtonSprite commit;
    protected ButtonSprite cancel;
    protected WindowMoney moneyWindow;
    protected WindowMessage info;
    protected WindowTreasure windowTreasure;
    protected WindowTechnology windowTechnology;
    protected WindowStoreEntry windowStoreEntry;
    protected List<TreasureV> treasures;
    protected List<Integer> selectedTreasures;
    protected List<Integer> technologies;
    protected List<Present> selectedPresents;
    private List<GameDataObjectButton> treasureButtons;
    private List<PresentButton> technologyButtons;
    private WindowStoreResource input;
    private int kind = 1;

    public SceneStoreAmountSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.treasures = new ArrayList<TreasureV>();
        this.selectedTreasures = new ArrayList<Integer>();
        this.selectedPresents = new ArrayList<Present>();
        this.technologies = new ArrayList<Integer>();
        this.treasureButtons = new ArrayList<GameDataObjectButton>();
        this.technologyButtons = new ArrayList<PresentButton>();
        this.kindTreasure = new ButtonSprite(110, 550, 100, 75, 25, -235801635, 1768520959, GameFontUtil.FONT20, "\u5bb6\u5b9d", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.kindTreasure.setPrimaryClicked(windowClickable -> this.setKind(2));
        this.kindResource = new ButtonSprite(210, 550, 100, 75, 25, -235801635, 1768520959, GameFontUtil.FONT20, "\u8cc7\u6e90", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.kindResource.setPrimaryClicked(windowClickable -> this.setKind(1));
        this.kindTechnology = new ButtonSprite(310, 550, 100, 75, 25, -235801635, 1768520959, GameFontUtil.FONT20, "\u6280\u8853", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.kindTechnology.setPrimaryClicked(windowClickable -> this.setKind(3));
        this.commit = new ButtonSprite(510, 540, 100, 75, 35, -235801635, 1768520959, GameFontUtil.FONT20, "\u8cfc\u5165", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.commit.setPrimaryClicked(windowClickable -> this.commit());
        this.commit.setSoundId(11);
        this.cancel = new ButtonSprite(420, 540, 100, 75, 35, -235801635, 1768520959, GameFontUtil.FONT20, "\u9000\u51fa", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.cancel.setPrimaryClicked(windowClickable -> this.cancelBuy());
        this.cancel.setSoundId(6);
        this.moneyWindow = new WindowMoney(660, 550, 10, 120, 35);
        this.input = new WindowStoreResource(20, 50, 10, 560, 420, this.getGameDataV());
        this.windowTreasure = new WindowTreasure(220, 50, 10, 360, 420, "", this.getGameDataV());
        this.windowTechnology = new WindowTechnologyForStore(220, 50, 10, 360, 420, "", this.getGameDataV());
        this.windowStoreEntry = new WindowStoreEntry(600, 50, 10, 190, 420, this.getGameDataV());
        this.info = new WindowMessage(20, 10, 100, 700, 30, 877223628, GameFontUtil.FONT16, -269422081, this.getDefaultMessage());
    }

    protected String getDefaultMessage() {
        return "\u8cfc\u5165\u3059\u308b\u7269\u8cc7\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044";
    }

    @Override
    public void load() {
        super.load();
        this.loadData();
        this.selectedTreasures.clear();
        this.selectedPresents.clear();
        this.windowStoreEntry.clear();
    }

    public void setKind(int n) {
        if (this.kind != n) {
            this.kind = n;
        }
    }

    protected void loadData() {
        this.input.reset(this.getGameTemp().getSelectedObjectId(), this.getUsableMoney());
        StoreV storeV = (StoreV)this.getGameDataV().getStores().get(this.getGameTemp().getSelectedObjectId());
        this.treasures.clear();
        this.treasures.addAll(storeV.getTreatTreasures());
        this.treasureButtons.clear();
        this.technologyButtons.clear();
        this.windowStoreEntry.setDaimyoId(this.getDaimyo().getId());
        this.windowStoreEntry.setStoreId(this.getGameTemp().getSelectedObjectId());
        this.windowTreasure.setDaimyoId(this.getDaimyo().getId());
        this.treasures.stream().forEachOrdered(treasureV -> {
            int n = this.treasureButtons.size();
            GameDataObjectButton gameDataObjectButton = new GameDataObjectButton(20, 50 + 30 * n, (GameDataObject)treasureV.getTreasure());
            gameDataObjectButton.setMouseEnter(windowClickable -> {
                Treasure treasure = (Treasure)((GameDataObjectButton)windowClickable).getObject();
                this.windowTreasure.setTreasureId(treasure.getId());
            });
            gameDataObjectButton.setPrimaryClicked(windowClickable -> {
                Treasure treasure = (Treasure)((GameDataObjectButton)windowClickable).getObject();
                this.selectedTreasure(treasure.getId());
            });
            this.treasureButtons.add(gameDataObjectButton);
        });
        this.technologies.clear();
        storeV.getStore().getPresents().stream().forEachOrdered(present -> {
            if (!this.getDaimyo().getTechnologyIds().contains(present.getTechnologyId())) {
                int n = this.technologyButtons.size();
                PresentButton presentButton = new PresentButton(20, 50 + 70 * n, 100, 200, this.getGameDataV());
                presentButton.setPresent((Present)present);
                presentButton.setMouseEnter(windowClickable -> {
                    TechnologyV technologyV = ((PresentButton)windowClickable).getTechnology();
                    this.windowTechnology.setTechnology(technologyV);
                });
                presentButton.setMouseExit(windowClickable -> this.windowTechnology.setTechnology(null));
                presentButton.setPrimaryClicked(windowClickable -> this.selectedTechnology((Present)present));
                this.technologyButtons.add(presentButton);
            }
        });
    }

    @Override
    public void unLoad() {
    }

    private void selectedTreasure(int n) {
        if (this.selectedTreasures.contains(n)) {
            this.selectedTreasures.remove((Object)n);
        } else {
            this.selectedTreasures.add(n);
        }
        this.windowStoreEntry.getTreasures().clear();
        this.windowStoreEntry.getTreasures().addAll(this.selectedTreasures);
        this.windowStoreEntry.forceUpdate();
    }

    private void selectedTechnology(Present present) {
        if (this.selectedPresents.contains(present)) {
            this.selectedPresents.remove(present);
        } else {
            this.selectedPresents.add(present);
        }
        this.windowStoreEntry.getPresents().clear();
        this.windowStoreEntry.getPresents().addAll(this.selectedPresents);
        this.windowStoreEntry.forceUpdate();
    }

    @Override
    public void update() {
        super.update();
        switch (this.kind) {
            case 1: {
                this.kindResource.setNormalColor(1768520959);
                this.kindTreasure.setNormalColor(-235801635);
                this.kindTechnology.setNormalColor(-235801635);
                break;
            }
            case 2: {
                this.kindTreasure.setNormalColor(1768520959);
                this.kindResource.setNormalColor(-235801635);
                this.kindTechnology.setNormalColor(-235801635);
                break;
            }
            case 3: {
                this.kindTreasure.setNormalColor(-235801635);
                this.kindResource.setNormalColor(-235801635);
                this.kindTechnology.setNormalColor(1768520959);
            }
        }
        this.kindTreasure.update();
        this.kindResource.update();
        this.kindTechnology.update();
        this.moneyWindow.setMoney(this.getUsableMoney());
        this.moneyWindow.update();
        this.windowStoreEntry.setGun(this.input.getGun());
        this.windowStoreEntry.setHorse(this.input.getHorse());
        this.windowStoreEntry.setIron(this.input.getIron());
        this.windowStoreEntry.setGunpowder(this.input.getGunpowder());
        this.windowStoreEntry.setSaltpeter(this.input.getSaltpeter());
        this.windowStoreEntry.setUsableMoney(this.getUsableMoney());
        this.windowStoreEntry.update();
        this.info.update();
        this.commit.update();
        this.cancel.update();
        this.input.setVisible(false);
        this.treasureButtons.forEach(gameDataObjectButton -> gameDataObjectButton.setVisible(false));
        this.technologyButtons.forEach(presentButton -> presentButton.setVisible(false));
        this.windowTreasure.setVisible(false);
        this.windowTechnology.setVisible(false);
        switch (this.kind) {
            case 1: {
                this.input.setVisible(true);
                break;
            }
            case 2: {
                this.treasureButtons.forEach(gameDataObjectButton -> {
                    gameDataObjectButton.setVisible(true);
                    if (this.selectedTreasures.contains(gameDataObjectButton.getObjectId())) {
                        gameDataObjectButton.setFontColor(-69579521);
                    } else {
                        gameDataObjectButton.setFontColor(-319753729);
                    }
                });
                this.windowTreasure.setVisible(true);
                break;
            }
            case 3: {
                this.technologyButtons.forEach(presentButton -> {
                    presentButton.setVisible(true);
                    if (this.selectedPresents.contains(presentButton.getPresent())) {
                        presentButton.setNormalColor(1768520959);
                    } else {
                        presentButton.setNormalColor(-235801635);
                    }
                });
                this.windowTechnology.setVisible(true);
            }
        }
        this.input.update();
        this.treasureButtons.forEach(gameDataObjectButton -> gameDataObjectButton.update());
        this.technologyButtons.forEach(presentButton -> presentButton.update());
        this.windowTreasure.update();
        this.windowTechnology.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.kindTreasure.draw(this.bcontext);
        this.kindResource.draw(this.bcontext);
        this.kindTechnology.draw(this.bcontext);
        this.moneyWindow.draw(this.bcontext);
        this.windowStoreEntry.draw(this.bcontext);
        this.info.draw(this.bcontext);
        this.commit.draw(this.bcontext);
        this.cancel.draw(this.bcontext);
        switch (this.kind) {
            case 1: {
                this.input.draw(this.bcontext);
                break;
            }
            case 2: {
                this.treasureButtons.forEach(gameDataObjectButton -> gameDataObjectButton.draw(this.bcontext));
                this.windowTreasure.draw(this.bcontext);
                break;
            }
            case 3: {
                this.technologyButtons.forEach(presentButton -> presentButton.draw(this.bcontext));
                this.windowTechnology.draw(this.bcontext);
            }
        }
    }

    protected void cancelBuy() {
        this.selectedTreasures.clear();
        this.selectedPresents.clear();
        StoreAction storeAction = new StoreAction(0, this.getGameTemp().getSelectedObjectId(), 0, 0, 0, 0, 0, this.selectedTreasures, this.selectedPresents);
        this.getPlayerClient().storeActionResponse(storeAction);
    }

    protected void commit() {
        int n = this.windowStoreEntry.getPrice();
        if (n <= this.getUsableMoney()) {
            int n2 = this.windowStoreEntry.getFriendShip();
            if (0 <= n2) {
                StoreAction storeAction = new StoreAction(n, this.getGameTemp().getSelectedObjectId(), this.input.getGun(), this.input.getHorse(), this.input.getIron(), this.input.getGunpowder(), this.input.getSaltpeter(), this.selectedTreasures, this.selectedPresents);
                this.getPlayerClient().storeActionResponse(storeAction);
            } else {
                this.alert("\u53cb\u597d\u5ea6\u304c\u8db3\u308a\u307e\u305b\u3093\u3002");
            }
        } else {
            this.alert(0, "\u91d1\u92ad\u304c\u8db3\u308a\u307e\u305b\u3093\u3002");
        }
    }

    @Override
    protected void exit() {
    }
}

