/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameData;
import game.sengoku.data.RelationV;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.CountrySelectButton;
import game.sengoku.window.WindowRelationInfo;
import java.util.ArrayList;
import java.util.List;

public class SceneNegotiationTrade
extends SceneCommon {
    private Texture minimap;
    private List<CountrySelectButton> relationInfoButtons;
    private ButtonSprite info;
    private ButtonSprite commit;
    private WindowRelationInfo relationInfoWindow;

    public SceneNegotiationTrade() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        GameData gameData = this.getGameData();
        this.minimap = (Texture)graphicPool.getResource(gameData.getMap().getImageMini());
        this.relationInfoButtons = new ArrayList<CountrySelectButton>();
        this.info = new ButtonSprite(170, 410, 100, 60, 30, 65484, 1768520959, GameFontUtil.FONT22, "\u60c5\u5831", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.info.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(2));
        this.info.setFontColor(-319753729);
        this.commit = new ButtonSprite(570, 410, 100, 60, 30, 65484, 1768520959, GameFontUtil.FONT22, "\u5b8c\u4e86", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.commit.setPrimaryClicked(windowClickable -> this.getPlayerClient().diplomacyActionResponse(6, 0));
        this.commit.setFontColor(-319753729);
        this.relationInfoWindow = new WindowRelationInfo(50, 450, 10, 700, 140, 0, "\u5916\u4ea4\u3059\u308b\u5927\u540d\u5bb6\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002", this.getGameDataV());
    }

    @Override
    public void load() {
        super.load();
        this.relationInfoWindow.setDaimyoId(-1);
        this.setReceiveNotice(true);
        this.createRelationInfo();
        this.updateVisible();
    }

    private void updateVisible() {
        this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(true));
        this.relationInfoWindow.setVisible(true);
        this.info.setVisible(true);
        this.commit.setVisible(true);
        this.info.setNormalColor(65484);
        this.commit.setNormalColor(65484);
        this.relationInfoWindow.setDaimyoId(this.getPlayer().getDaimyoId());
    }

    protected int getColor(DaimyoV daimyoV) {
        return daimyoV.getColor();
    }

    private void createRelationInfo() {
        this.relationInfoButtons.clear();
        for (DaimyoV daimyoV : this.getGameDataV().getDaimyos().values()) {
            if (daimyoV.isFall()) continue;
            int n = this.getColor(daimyoV);
            CountrySelectButton countrySelectButton = new CountrySelectButton(((CountryV)daimyoV.getCountries().get(0)).getCountry(), this.getGameDataV(), n, n);
            countrySelectButton.setMouseEnter(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                this.relationInfoWindow.setTargetDaimyoId(countryV.getDaimyoId());
            });
            countrySelectButton.setMouseExit(windowClickable -> this.relationInfoWindow.setTargetDaimyoId(-1));
            countrySelectButton.setPrimaryClicked(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                if (countryV != null) {
                    this.relationClicked(countryV.getDaimyo());
                }
            });
            this.relationInfoButtons.add(countrySelectButton);
        }
    }

    protected void relationClicked(DaimyoV daimyoV) {
        this.getPlayerClient().diplomacyActionResponse(1, daimyoV.getId());
    }

    protected int getColor(RelationV relationV) {
        return 65535;
    }

    @Override
    protected void exit() {
    }

    @Override
    public void unLoad() {
        super.unLoad();
        this.relationInfoButtons.clear();
    }

    @Override
    public void update() {
        super.update();
        this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.update());
        this.info.update();
        this.commit.update();
        this.relationInfoWindow.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.bcontext.drawImage(this.minimap, 150, 10, 10);
        this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.draw(this.bcontext));
        this.info.draw(this.bcontext);
        this.commit.draw(this.bcontext);
        this.relationInfoWindow.draw(this.bcontext);
    }
}

