/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.GameDataObject;
import game.sengoku.data.RoleV;
import game.sengoku.main.KessenMain;
import game.sengoku.window.GameDataObjectButton;
import game.sengoku.window.WindowRoleInfo;
import java.util.ArrayList;
import java.util.List;

public class SceneNegotiationRoleSelect
extends SceneCommon {
    protected List<GameDataObjectButton> roleButtons;
    protected WindowRoleInfo info;
    protected List<RoleV> roles;

    public SceneNegotiationRoleSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.roles = new ArrayList<RoleV>();
        this.roleButtons = new ArrayList<GameDataObjectButton>();
        this.info = new WindowRoleInfo(50, 450, 10, 600, 140, "\u5f79\u8077\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002", this.getGameDataV());
    }

    @Override
    public void load() {
        super.load();
        this.loadData();
        this.createButton();
    }

    protected void loadData() {
        this.roles.clear();
        for (int n : this.getGameTemp().getCandidateObjectIds()) {
            this.roles.add((RoleV)this.getGameDataV().getRoles().get(n));
        }
    }

    protected void createButton() {
        this.roleButtons.clear();
        this.roles.stream().limit(60L).forEachOrdered(roleV -> {
            int n = this.roleButtons.size();
            GameDataObjectButton gameDataObjectButton = new GameDataObjectButton(75 + 130 * (n / 12), 30 + 30 * (n % 12), (GameDataObject)roleV, roleV.getName());
            gameDataObjectButton.setMouseEnter(windowClickable -> {
                GameDataObject gameDataObject = ((GameDataObjectButton)windowClickable).getObject();
                this.info.setId(gameDataObject.getId());
            });
            gameDataObjectButton.setMouseExit(windowClickable -> this.info.setId(-1));
            gameDataObjectButton.setPrimaryClicked(windowClickable -> {
                GameDataObject gameDataObject = ((GameDataObjectButton)windowClickable).getObject();
                this.clickedRole(gameDataObject.getId());
            });
            gameDataObjectButton.setFontColor(-84214785);
            this.roleButtons.add(gameDataObjectButton);
        });
    }

    protected void clickedRole(int n) {
        this.getGameTemp().setSelectedObjectId(n);
        this.exit();
    }

    @Override
    public void unLoad() {
        this.roleButtons.clear();
    }

    @Override
    public void update() {
        super.update();
        this.roleButtons.forEach(gameDataObjectButton -> gameDataObjectButton.update());
        this.info.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.info.draw(this.bcontext);
        this.roleButtons.forEach(gameDataObjectButton -> gameDataObjectButton.draw(this.bcontext));
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(2);
    }
}

