/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.SceneCommon;
import game.sengoku.game.GameDiplomacyUtil;
import game.sengoku.game.diplomacy.NegotiationAction;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowNegotiationEntry;
import game.sengoku.window.WindowYearInfo;

public class SceneNegotiationMenu
extends SceneCommon {
    private ButtonSprite editSelf;
    private ButtonSprite editTarget;
    private ButtonSprite info;
    private ButtonSprite commit;
    private ButtonSprite breaked;
    private WindowYearInfo year;
    private WindowNegotiationEntry selfEntry;
    private WindowNegotiationEntry targetEntry;
    private ButtonSprite alliance;
    private ButtonSprite nonAggression;
    private ButtonSprite threat;
    private ButtonSprite surrender;
    private ButtonSprite border;
    private ButtonSprite detente;
    private ButtonSprite toubatsuRemove;

    public SceneNegotiationMenu() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.editSelf = new ButtonSprite(120, 500, 100, 60, 30, 1097458124, 1768520959, GameFontUtil.FONT22, "\u7de8\u96c6", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.editSelf.setPrimaryClicked(windowClickable -> {
            this.getGameTemp().setSubSceneId(2);
            this.getGameTemp().setNegotiationEditDaimyoId(this.getDaimyo().getId());
        });
        this.editSelf.setFontColor(-319753729);
        this.selfEntry = new WindowNegotiationEntry(10, 10, 10, 280, 460, this.getPlayer().getDaimyoId(), this.getGameDataV());
        this.editTarget = new ButtonSprite(620, 500, 100, 60, 30, 1097458124, 1768520959, GameFontUtil.FONT22, "\u7de8\u96c6", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.editTarget.setPrimaryClicked(windowClickable -> {
            this.getGameTemp().setSubSceneId(2);
            this.getGameTemp().setNegotiationEditDaimyoId(this.getGameTemp().getNegotiationDaimyoId());
        });
        this.editTarget.setFontColor(-319753729);
        this.targetEntry = new WindowNegotiationEntry(510, 10, 10, 280, 460, this.getGameTemp().getNegotiationDaimyoId(), this.getGameDataV());
        this.info = new ButtonSprite(50, 550, 100, 75, 30, 1097458124, 1768520959, GameFontUtil.FONT22, "\u60c5\u5831", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.info.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(10));
        this.info.setFontColor(-319753729);
        this.commit = new ButtonSprite(150, 550, 100, 160, 30, 1097458124, 1768520959, GameFontUtil.FONT22, "\u3053\u306e\u5185\u5bb9\u3067\u4ea4\u6e09", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.commit.setPrimaryClicked(windowClickable -> {
            NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
            negotiationAction.setContinuous(true);
            this.getPlayerClient().negotiationActionResponse(negotiationAction);
        });
        this.commit.setFontColor(-319753729);
        this.commit.setSoundId(4);
        this.breaked = new ButtonSprite(350, 550, 100, 160, 30, 1097458124, 1768520959, GameFontUtil.FONT22, "\u4ea4\u6e09\u6253\u3061\u5207\u308a", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.breaked.setPrimaryClicked(windowClickable -> {
            NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
            negotiationAction.setContinuous(false);
            this.getPlayerClient().negotiationActionResponse(negotiationAction);
        });
        this.breaked.setFontColor(-319753729);
        this.breaked.setSoundId(6);
        this.year = new WindowYearInfo(300, 10, 100, 200, 80, this.getGameDataV().getWorld());
    }

    @Override
    public void load() {
        super.load();
        this.getGameTemp().setReturnSubSceneId(1);
        this.selfEntry.setDaimyoId(this.getDaimyo().getId());
        this.selfEntry.setNegotiationAction(this.getGameTemp().getNegotiationAction());
        this.selfEntry.forceUpdate();
        this.targetEntry.setDaimyoId(this.getGameTemp().getNegotiationDaimyoId());
        this.targetEntry.setNegotiationAction(this.getGameTemp().getNegotiationAction());
        this.targetEntry.forceUpdate();
        int n = 0;
        this.alliance = new ButtonSprite(310, 100 + 40 * n, 100, 160, 30, -256, 1768520959, GameFontUtil.FONT22, "\u540c\u76df\u8981\u8acb", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.alliance.setPrimaryClicked(windowClickable -> {
            NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
            if (negotiationAction.getSelfEntry().isAlliance()) {
                this.resetAlliance();
            } else {
                this.resetAlliance();
                negotiationAction.getSelfEntry().setAlliance(true);
                negotiationAction.getTargetEntry().setAlliance(true);
                this.alliance.setFontColor(-69579521);
            }
            this.selfEntry.forceUpdate();
            this.targetEntry.forceUpdate();
        });
        this.alliance.setFontColor(-319753729);
        this.nonAggression = new ButtonSprite(310, 100 + 40 * ++n, 100, 160, 30, -256, 1768520959, GameFontUtil.FONT22, "\u505c\u6226\u8981\u8acb", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.nonAggression.setPrimaryClicked(windowClickable -> {
            NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
            if (negotiationAction.getSelfEntry().isNonAggression()) {
                this.resetAlliance();
            } else {
                this.resetAlliance();
                negotiationAction.getSelfEntry().setNonAggression(true);
                negotiationAction.getTargetEntry().setNonAggression(true);
                this.nonAggression.setFontColor(-69579521);
            }
            this.selfEntry.forceUpdate();
            this.targetEntry.forceUpdate();
        });
        this.nonAggression.setFontColor(-319753729);
        this.threat = new ButtonSprite(310, 100 + 40 * ++n, 100, 160, 30, -256, 1768520959, GameFontUtil.FONT22, "\u5f93\u5c5e\u8981\u8acb", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.threat.setPrimaryClicked(windowClickable -> {
            NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
            if (negotiationAction.getSelfEntry().isThreat()) {
                this.resetAlliance();
            } else {
                this.resetAlliance();
                negotiationAction.getSelfEntry().setThreat(true);
                negotiationAction.getTargetEntry().setSurrender(true);
                this.threat.setFontColor(-69579521);
            }
            this.selfEntry.forceUpdate();
            this.targetEntry.forceUpdate();
        });
        this.threat.setFontColor(-319753729);
        this.surrender = new ButtonSprite(310, 100 + 40 * ++n, 100, 160, 30, -256, 1768520959, GameFontUtil.FONT22, "\u964d\u4f0f\u3059\u308b", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.surrender.setPrimaryClicked(windowClickable -> {
            NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
            if (negotiationAction.getSelfEntry().isSurrender()) {
                this.resetAlliance();
            } else {
                this.resetAlliance();
                negotiationAction.getSelfEntry().setSurrender(true);
                negotiationAction.getTargetEntry().setThreat(true);
                this.surrender.setFontColor(-69579521);
            }
            this.selfEntry.forceUpdate();
            this.targetEntry.forceUpdate();
        });
        this.surrender.setFontColor(-319753729);
        this.border = new ButtonSprite(310, 100 + 40 * ++n, 100, 160, 30, -256, 1768520959, GameFontUtil.FONT22, "\u56fd\u5883\u7d1b\u4e89\u89e3\u6c7a", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.border.setPrimaryClicked(windowClickable -> {
            NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
            if (negotiationAction.getSelfEntry().isBorder()) {
                negotiationAction.getSelfEntry().setBorder(false);
                negotiationAction.getTargetEntry().setBorder(false);
                this.border.setFontColor(-319753729);
            } else {
                negotiationAction.getSelfEntry().setBorder(true);
                negotiationAction.getTargetEntry().setBorder(true);
                this.border.setFontColor(-69579521);
            }
            this.selfEntry.forceUpdate();
            this.targetEntry.forceUpdate();
        });
        this.border.setFontColor(-319753729);
        this.detente = new ButtonSprite(310, 100 + 40 * ++n, 100, 160, 30, -256, 1768520959, GameFontUtil.FONT22, "\u548c\u89e3", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.detente.setPrimaryClicked(windowClickable -> {
            NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
            if (negotiationAction.getSelfEntry().isDetente()) {
                negotiationAction.getSelfEntry().setDetente(false);
                negotiationAction.getTargetEntry().setDetente(false);
                this.detente.setFontColor(-319753729);
            } else {
                negotiationAction.getSelfEntry().setDetente(true);
                negotiationAction.getTargetEntry().setDetente(true);
                this.detente.setFontColor(-69579521);
            }
            this.selfEntry.forceUpdate();
            this.targetEntry.forceUpdate();
        });
        this.detente.setFontColor(-319753729);
        this.toubatsuRemove = new ButtonSprite(310, 100 + 40 * ++n, 100, 160, 30, -256, 1768520959, GameFontUtil.FONT22, "\u8a0e\u4f10\u4ee4\u89e3\u9664", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.toubatsuRemove.setPrimaryClicked(windowClickable -> {
            NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
            if (!negotiationAction.getTargetEntry().getToubatsuRemoveIds().isEmpty()) {
                negotiationAction.getTargetEntry().getToubatsuRemoveIds().clear();
                this.toubatsuRemove.setFontColor(-319753729);
            } else {
                negotiationAction.getTargetEntry().getToubatsuRemoveIds().add(this.getDaimyo().getId());
                this.toubatsuRemove.setFontColor(-69579521);
            }
            this.selfEntry.forceUpdate();
            this.targetEntry.forceUpdate();
        });
        this.toubatsuRemove.setFontColor(-319753729);
        this.updateFontColor();
        this.updateActives();
    }

    private void updateActives() {
        int n = this.getDaimyo().getId();
        int n2 = this.getGameTemp().getNegotiationDaimyoId();
        this.alliance.setVisible(GameDiplomacyUtil.canAlliance(this.getGameDataV(), n, n2));
        this.nonAggression.setVisible(GameDiplomacyUtil.canNonAggression(this.getGameDataV(), n, n2));
        this.threat.setVisible(GameDiplomacyUtil.canTreat(this.getGameDataV(), n, n2));
        this.surrender.setVisible(GameDiplomacyUtil.canTreat(this.getGameDataV(), n, n2));
        this.border.setVisible(GameDiplomacyUtil.canBorderConflict(this.getGameDataV(), n, n2));
        this.detente.setVisible(GameDiplomacyUtil.canDetante(this.getGameDataV(), n, n2));
        this.toubatsuRemove.setVisible(GameDiplomacyUtil.canToubatsuRemove(this.getGameDataV(), n, n2));
    }

    private void updateFontColor() {
        NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
        if (negotiationAction.getSelfEntry().isAlliance()) {
            this.alliance.setFontColor(-69579521);
        } else {
            this.alliance.setFontColor(-319753729);
        }
        if (negotiationAction.getSelfEntry().isNonAggression()) {
            this.nonAggression.setFontColor(-69579521);
        } else {
            this.nonAggression.setFontColor(-319753729);
        }
        if (negotiationAction.getSelfEntry().isThreat()) {
            this.threat.setFontColor(-69579521);
        } else {
            this.threat.setFontColor(-319753729);
        }
        if (negotiationAction.getSelfEntry().isSurrender()) {
            this.surrender.setFontColor(-69579521);
        } else {
            this.surrender.setFontColor(-319753729);
        }
        if (negotiationAction.getSelfEntry().isBorder()) {
            this.border.setFontColor(-69579521);
        } else {
            this.border.setFontColor(-319753729);
        }
        if (negotiationAction.getSelfEntry().isDetente()) {
            this.detente.setFontColor(-69579521);
        } else {
            this.detente.setFontColor(-319753729);
        }
        if (!negotiationAction.getTargetEntry().getToubatsuRemoveIds().isEmpty()) {
            this.toubatsuRemove.setFontColor(-69579521);
        } else {
            this.toubatsuRemove.setFontColor(-319753729);
        }
    }

    private void resetAlliance() {
        NegotiationAction negotiationAction = this.getGameTemp().getNegotiationAction();
        negotiationAction.getSelfEntry().setAlliance(false);
        negotiationAction.getTargetEntry().setAlliance(false);
        negotiationAction.getSelfEntry().setNonAggression(false);
        negotiationAction.getTargetEntry().setNonAggression(false);
        negotiationAction.getSelfEntry().setThreat(false);
        negotiationAction.getTargetEntry().setSurrender(false);
        negotiationAction.getSelfEntry().setSurrender(false);
        negotiationAction.getTargetEntry().setThreat(false);
        negotiationAction.getSelfEntry().getToubatsuRemoveIds().clear();
        negotiationAction.getTargetEntry().getToubatsuRemoveIds().clear();
        this.threat.setFontColor(-319753729);
        this.surrender.setFontColor(-319753729);
        this.alliance.setFontColor(-319753729);
        this.nonAggression.setFontColor(-319753729);
        this.border.setFontColor(-319753729);
        this.detente.setFontColor(-319753729);
        this.toubatsuRemove.setFontColor(-319753729);
    }

    @Override
    protected void exit() {
    }

    @Override
    public void unLoad() {
        super.unLoad();
    }

    @Override
    public void update() {
        super.update();
        this.editSelf.update();
        this.editTarget.update();
        this.info.update();
        this.commit.update();
        this.breaked.update();
        this.selfEntry.update();
        this.targetEntry.update();
        this.alliance.update();
        this.nonAggression.update();
        this.threat.update();
        this.surrender.update();
        this.border.update();
        this.detente.update();
        this.toubatsuRemove.update();
        this.year.update();
        if (this.selfEntry.isChangeEntry() || this.targetEntry.isChangeEntry()) {
            this.selfEntry.forceUpdate();
            this.targetEntry.forceUpdate();
            this.updateFontColor();
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.editSelf.draw(this.bcontext);
        this.editTarget.draw(this.bcontext);
        this.info.draw(this.bcontext);
        this.commit.draw(this.bcontext);
        this.breaked.draw(this.bcontext);
        this.selfEntry.draw(this.bcontext);
        this.targetEntry.draw(this.bcontext);
        this.alliance.draw(this.bcontext);
        this.nonAggression.draw(this.bcontext);
        this.threat.draw(this.bcontext);
        this.surrender.draw(this.bcontext);
        this.border.draw(this.bcontext);
        this.detente.draw(this.bcontext);
        this.toubatsuRemove.draw(this.bcontext);
        this.year.draw(this.bcontext);
    }
}

