/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy;

import game.base.common.Tuple;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameData;
import game.sengoku.data.RelationV;
import game.sengoku.data.StoreV;
import game.sengoku.game.GameDiplomacyUtil;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.CountrySelectButton;
import game.sengoku.window.WindowClickable;
import game.sengoku.window.WindowCommandSelect;
import game.sengoku.window.WindowNegotiationInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class SceneDiplomacyMenu
extends SceneCommon {
    private Texture minimap;
    private List<CountrySelectButton> relationInfoButtons;
    private List<ButtonSprite> storeButtons;
    private ButtonSprite info;
    private ButtonSprite commit;
    private WindowNegotiationInfo relationInfoWindow;

    public SceneDiplomacyMenu() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        GameData gameData = this.getGameData();
        this.minimap = (Texture)graphicPool.getResource(gameData.getMap().getImageMini());
        this.relationInfoButtons = new ArrayList<CountrySelectButton>();
        this.storeButtons = new ArrayList<ButtonSprite>();
        this.info = new ButtonSprite(170, 410, 100, 60, 30, -235801635, 1768520959, GameFontUtil.FONT22, "\u60c5\u5831", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.info.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(2));
        this.commit = new ButtonSprite(570, 395, 100, 60, 45, -235801635, 1768520959, GameFontUtil.FONT22, "\u5b8c\u4e86", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.commit.setPrimaryClicked(windowClickable -> this.getPlayerClient().diplomacyActionResponse(6, 0));
        this.commit.setSoundId(4);
        this.relationInfoWindow = new WindowNegotiationInfo(50, 450, 10, 700, 140, 0, "\u5916\u4ea4\u3059\u308b\u5927\u540d\u5bb6\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002", this.getGameDataV());
    }

    @Override
    public void load() {
        super.load();
        this.getGameTemp().setReturnSubSceneId(1);
        this.optionUse = true;
        this.relationInfoWindow.setDaimyoId(-1);
        this.setReceiveNotice(true);
        this.setMiddleWindow(null);
        this.createRelationInfo();
        this.createStoreInfo();
        this.updateVisible();
    }

    private void updateVisible() {
        this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(true));
        this.relationInfoWindow.setVisible(true);
        this.info.setVisible(true);
        this.commit.setVisible(true);
        this.relationInfoWindow.setDaimyoId(this.getPlayer().getDaimyoId());
    }

    private int getColor(DaimyoV daimyoV) {
        return daimyoV.getColor();
    }

    private void createStoreInfo() {
        int n = 0;
        this.storeButtons.clear();
        for (int n2 : this.getGameTemp().getNegotiationStoreIds()) {
            StoreV storeV = (StoreV)this.getGameDataV().getStores().get(n2);
            ButtonSprite buttonSprite = new ButtonSprite(710, 10 + 30 * n, 200, 80, 25, -235801635, 1768520959, GameFontUtil.FONT16, storeV.getName(), true, MouseSymbolLayerManager.LAYER_NORMAL);
            ++n;
            buttonSprite.setFontColor(255);
            buttonSprite.setPrimaryClicked(windowClickable -> this.storeClicked(storeV));
            this.storeButtons.add(buttonSprite);
        }
    }

    private void createRelationInfo() {
        this.relationInfoButtons.clear();
        for (int n : this.getGameTemp().getNegotiationDaimyoIds()) {
            DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(n);
            int n2 = this.getColor(daimyoV);
            CountrySelectButton countrySelectButton = new CountrySelectButton(((CountryV)daimyoV.getCountries().get(0)).getCountry(), this.getGameDataV(), n2, n2);
            countrySelectButton.setMouseEnter(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                this.relationInfoWindow.setTargetDaimyoId(countryV.getDaimyoId());
            });
            countrySelectButton.setMouseExit(windowClickable -> this.relationInfoWindow.setTargetDaimyoId(-1));
            countrySelectButton.setPrimaryClicked(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                if (countryV != null) {
                    this.relationClicked(countryV.getDaimyo());
                }
            });
            this.relationInfoButtons.add(countrySelectButton);
        }
    }

    protected void storeClicked(StoreV storeV) {
        this.getPlayerClient().diplomacyActionResponse(5, storeV.getId());
    }

    protected void relationClicked(DaimyoV daimyoV) {
        ArrayList<Tuple<String, Integer, Consumer<WindowClickable>>> arrayList = new ArrayList<Tuple<String, Integer, Consumer<WindowClickable>>>();
        arrayList.add(new Tuple<String, Integer, Consumer<WindowClickable>>("\u53d6\u5f15\u3092\u3059\u308b", -319753729, windowClickable -> {
            this.getPlayerClient().diplomacyActionResponse(1, daimyoV.getId());
            this.setMiddleWindow(null);
        }));
        if (GameDiplomacyUtil.canBreakAlliance(this.getGameDataV(), this.getDaimyo().getId(), daimyoV.getId())) {
            arrayList.add(new Tuple<String, Integer, Consumer<WindowClickable>>("\u540c\u76df\u3092\u7834\u68c4\u3059\u308b", -319753729, windowClickable -> {
                this.getPlayerClient().diplomacyActionResponse(2, daimyoV.getId());
                this.setMiddleWindow(null);
            }));
        }
        if (GameDiplomacyUtil.canEnemyTo(this.getGameDataV(), this.getDaimyo().getId(), daimyoV.getId())) {
            arrayList.add(new Tuple<String, Integer, Consumer<WindowClickable>>("\u6575\u56fd\u306b\u6307\u5b9a\u3059\u308b", -319753729, windowClickable -> {
                this.getPlayerClient().diplomacyActionResponse(3, daimyoV.getId());
                this.setMiddleWindow(null);
            }));
        }
        if (GameDiplomacyUtil.canToubatsu(this.getGameDataV(), this.getDaimyo().getId(), daimyoV.getId())) {
            arrayList.add(new Tuple<String, Integer, Consumer<WindowClickable>>("\u8a0e\u4f10\u56fd\u306b\u6307\u5b9a", -319753729, windowClickable -> {
                this.getPlayerClient().diplomacyActionResponse(4, daimyoV.getId());
                this.setMiddleWindow(null);
            }));
        }
        arrayList.add(new Tuple<String, Integer, Consumer<WindowClickable>>("\u30ad\u30e3\u30f3\u30bb\u30eb", -319753729, windowClickable -> this.setMiddleWindow(null)));
        WindowCommandSelect windowCommandSelect = new WindowCommandSelect(300, 200, 200, 200, arrayList);
        this.setMiddleWindow(windowCommandSelect);
    }

    protected int getColor(RelationV relationV) {
        return 65535;
    }

    @Override
    protected void exit() {
    }

    @Override
    public void unLoad() {
        super.unLoad();
        this.storeButtons.clear();
        this.relationInfoButtons.clear();
    }

    @Override
    public void update() {
        super.update();
        if (this.getGameTemp().isNegotiationDaimyoIdChange()) {
            this.createRelationInfo();
            this.createStoreInfo();
            this.getGameTemp().setNegotiationDaimyoIdChange(false);
        }
        this.storeButtons.forEach(buttonSprite -> buttonSprite.update());
        this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.update());
        this.info.update();
        this.commit.update();
        this.relationInfoWindow.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.bcontext.drawImage(this.minimap, 150, 10, 10);
        this.storeButtons.forEach(buttonSprite -> buttonSprite.draw(this.bcontext));
        this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.draw(this.bcontext));
        this.info.draw(this.bcontext);
        this.commit.draw(this.bcontext);
        this.relationInfoWindow.draw(this.bcontext);
    }
}

