/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy;

import game.sengoku.common.AICalcUtil;
import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.TechnologyV;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class NegotiationValueTable {
    private int daimyoId = 0;
    private Map<Integer, Integer> cultureValues = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> technologyValues = new HashMap<Integer, Integer>();
    private double moneyValue = 0.0;
    private double gunValue = 0.0;
    private double horseValue = 0.0;
    private double gunpowderValue = 0.0;
    private double saltpeterValue = 0.0;
    private double ironValue = 0.0;
    private int gunDemand = 0;
    private int horseDemand = 0;
    private int gunpowderDemand = 0;
    private int saltpeterDemand = 0;
    private int ironDemand = 0;
    private int allianceValue = 0;

    public NegotiationValueTable(GameDataV gameDataV, DaimyoV daimyoV) {
        this.valuing(gameDataV, daimyoV);
    }

    private void valuing(GameDataV gameDataV, DaimyoV daimyoV) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (TechnologyV technologyV : gameDataV.getTechnologies().values()) {
            n = AICalcUtil.valuingTechnology(gameDataV, daimyoV.getAiType(), daimyoV, technologyV);
            this.technologyValues.put(technologyV.getId(), n);
            arrayList.add(n);
        }
        for (TechnologyV technologyV : gameDataV.getCultures().values()) {
            n = AICalcUtil.valuingCulture(gameDataV, daimyoV.getAiType(), daimyoV, (CultureV)technologyV);
            this.cultureValues.put(technologyV.getId(), n);
            arrayList.add(n);
        }
        this.moneyValue = 1.0;
        this.gunDemand = daimyoV.getArmyAmount() * daimyoV.getAiType().getDemandGun() - daimyoV.getGun() - daimyoV.getGunPlus() * 6;
        this.gunValue = gameDataV.getWorld().getPriceGun();
        this.horseDemand = daimyoV.getArmyAmount() * daimyoV.getAiType().getDemandHorse() - daimyoV.getHorse() - daimyoV.getHorsePlus() * 6;
        this.horseValue = gameDataV.getWorld().getPriceHorse();
        this.gunpowderDemand = daimyoV.getGun() * 3 - daimyoV.getGunpowder() - daimyoV.getGunpowderPlus() * 6;
        this.gunpowderValue = gameDataV.getWorld().getPriceGunpowder();
        this.saltpeterDemand = (daimyoV.getGunpowderPlus() - daimyoV.getSaltpeterPlus()) * 6 - daimyoV.getSaltpeter();
        this.saltpeterValue = gameDataV.getWorld().getPriceSaltpeter();
        this.ironDemand = (daimyoV.getGunPlus() - daimyoV.getIronPlus()) * 6 - daimyoV.getIron();
        this.ironValue = gameDataV.getWorld().getPriceIron();
        if (daimyoV.getGun() * 3 < daimyoV.getGunpowder()) {
            this.gunpowderDemand = daimyoV.getArmyAmount() * daimyoV.getAiType().getDemandGun() - daimyoV.getGunpowder();
            this.gunpowderDemand = Math.min(this.gunpowderDemand, this.gunDemand - 1);
        } else {
            this.gunDemand = this.gunpowderDemand / 3;
        }
        this.allianceValue = (int)Math.ceil(1200.0 * gameDataV.getWorld().getInflationRate());
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public Map<Integer, Integer> getCultureValues() {
        return this.cultureValues;
    }

    public Map<Integer, Integer> getTechnologyValues() {
        return this.technologyValues;
    }

    public double getMoneyValue() {
        return this.moneyValue;
    }

    public double getGunValue() {
        return this.gunValue;
    }

    public double getHorseValue() {
        return this.horseValue;
    }

    public double getSaltpeterValue() {
        return this.saltpeterValue;
    }

    public double getIronValue() {
        return this.ironValue;
    }

    public double getGunpowderValue() {
        return this.gunpowderValue;
    }

    public int getGunDemand() {
        return this.gunDemand;
    }

    public int getHorseDemand() {
        return this.horseDemand;
    }

    public int getGunpowderDemand() {
        return this.gunpowderDemand;
    }

    public int getSaltpeterDemand() {
        return this.saltpeterDemand;
    }

    public int getIronDemand() {
        return this.ironDemand;
    }

    public void setDaimyoId(int n) {
        this.daimyoId = n;
    }

    public int getAllianceValue() {
        return this.allianceValue;
    }
}

