/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy;

import game.sengoku.common.GameUtil;
import java.util.ArrayList;
import java.util.List;

public class NegotiationActionEntry {
    private int daimyoId = 0;
    private List<Integer> roleIds = new ArrayList<Integer>();
    private List<Integer> cultureIds = new ArrayList<Integer>();
    private List<Integer> technologyIds = new ArrayList<Integer>();
    private List<Integer> rentalKnightIds = new ArrayList<Integer>();
    private List<Integer> rentalReturnKnightIds = new ArrayList<Integer>();
    private int money = 0;
    private int gun = 0;
    private int horse = 0;
    private int iron = 0;
    private int saltpeter = 0;
    private int gunpowder = 0;
    private boolean alliance = false;
    private boolean non_aggression = false;
    private boolean threat = false;
    private boolean surrender = false;
    private boolean breakWith = false;
    private boolean border = false;
    private boolean detente = false;
    private List<Integer> breakIds = new ArrayList<Integer>();
    private List<Integer> enemyToIds = new ArrayList<Integer>();
    private List<Integer> toubatsuToIds = new ArrayList<Integer>();
    private List<Integer> toubatsuRemoveIds = new ArrayList<Integer>();

    public void copy(NegotiationActionEntry negotiationActionEntry) {
        this.roleIds.addAll(negotiationActionEntry.getRoleIds());
        this.cultureIds.addAll(negotiationActionEntry.getCultureIds());
        this.technologyIds.addAll(negotiationActionEntry.getTechnologyIds());
        this.rentalKnightIds.addAll(negotiationActionEntry.getRentalKnightIds());
        this.rentalReturnKnightIds.addAll(negotiationActionEntry.getRentalReturnKnightIds());
        this.breakIds.addAll(negotiationActionEntry.getBreakIds());
        this.enemyToIds.addAll(negotiationActionEntry.getEnemyToIds());
        this.toubatsuToIds.addAll(negotiationActionEntry.getToubatsuToIds());
        this.toubatsuRemoveIds.addAll(negotiationActionEntry.getToubatsuRemoveIds());
        this.money = negotiationActionEntry.getMoney();
        this.gun = negotiationActionEntry.getGun();
        this.horse = negotiationActionEntry.getHorse();
        this.gunpowder = negotiationActionEntry.getGunpowder();
        this.saltpeter = negotiationActionEntry.getSaltpeter();
        this.iron = negotiationActionEntry.getIron();
        this.alliance = negotiationActionEntry.isAlliance();
        this.non_aggression = negotiationActionEntry.isNonAggression();
        this.threat = negotiationActionEntry.isThreat();
        this.surrender = negotiationActionEntry.isSurrender();
        this.breakWith = negotiationActionEntry.isBreakWith();
        this.border = negotiationActionEntry.isBorder();
        this.detente = negotiationActionEntry.isDetente();
    }

    public boolean isEmpty() {
        return this.roleIds.isEmpty() && this.toubatsuToIds.isEmpty() && this.cultureIds.isEmpty() && this.technologyIds.isEmpty() && this.rentalKnightIds.isEmpty() && this.breakIds.isEmpty() && this.enemyToIds.isEmpty() && this.rentalReturnKnightIds.isEmpty() && this.toubatsuRemoveIds.isEmpty() && this.money == 0 && this.gun == 0 && this.horse == 0 && this.gunpowder == 0 && this.iron == 0 && this.saltpeter == 0 && !this.alliance && !this.non_aggression && !this.threat && !this.surrender && !this.breakWith && !this.border && !this.detente;
    }

    public void clear() {
        this.roleIds.clear();
        this.cultureIds.clear();
        this.technologyIds.clear();
        this.rentalKnightIds.clear();
        this.breakIds.clear();
        this.enemyToIds.clear();
        this.toubatsuToIds.clear();
        this.rentalReturnKnightIds.clear();
        this.toubatsuRemoveIds.clear();
        this.money = 0;
        this.gun = 0;
        this.horse = 0;
        this.iron = 0;
        this.saltpeter = 0;
        this.gunpowder = 0;
        this.alliance = false;
        this.non_aggression = false;
        this.threat = false;
        this.surrender = false;
        this.breakWith = false;
        this.border = false;
        this.detente = false;
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public List<Integer> getRoleIds() {
        return this.roleIds;
    }

    public List<Integer> getToubatsuToIds() {
        return this.toubatsuToIds;
    }

    public List<Integer> getCultureIds() {
        return this.cultureIds;
    }

    public List<Integer> getTechnologyIds() {
        return this.technologyIds;
    }

    public List<Integer> getRentalKnightIds() {
        return this.rentalKnightIds;
    }

    public List<Integer> getRentalReturnKnightIds() {
        return this.rentalReturnKnightIds;
    }

    public List<Integer> getToubatsuRemoveIds() {
        return this.toubatsuRemoveIds;
    }

    public int getMoney() {
        return this.money;
    }

    public int getGun() {
        return this.gun;
    }

    public int getHorse() {
        return this.horse;
    }

    public boolean isAlliance() {
        return this.alliance;
    }

    public boolean isNonAggression() {
        return this.non_aggression;
    }

    public boolean isThreat() {
        return this.threat;
    }

    public boolean isSurrender() {
        return this.surrender;
    }

    public boolean isBreakWith() {
        return this.breakWith;
    }

    public boolean isBorder() {
        return this.border;
    }

    public List<Integer> getBreakIds() {
        return this.breakIds;
    }

    public List<Integer> getEnemyToIds() {
        return this.enemyToIds;
    }

    public void setDaimyoId(int n) {
        this.daimyoId = n;
    }

    public void setMoney(int n) {
        this.money = n;
    }

    public void setGun(int n) {
        this.gun = n;
    }

    public void setHorse(int n) {
        this.horse = n;
    }

    public void setAlliance(boolean bl) {
        this.alliance = bl;
    }

    public void setNonAggression(boolean bl) {
        this.non_aggression = bl;
    }

    public void setThreat(boolean bl) {
        this.threat = bl;
    }

    public void setSurrender(boolean bl) {
        this.surrender = bl;
    }

    public void setBreakWith(boolean bl) {
        this.breakWith = bl;
    }

    public void setBorder(boolean bl) {
        this.border = bl;
    }

    public boolean isDetente() {
        return this.detente;
    }

    public void setDetente(boolean bl) {
        this.detente = bl;
    }

    public int getIron() {
        return this.iron;
    }

    public void setIron(int n) {
        this.iron = n;
    }

    public int getSaltpeter() {
        return this.saltpeter;
    }

    public void setSaltpeter(int n) {
        this.saltpeter = n;
    }

    public int getGunpowder() {
        return this.gunpowder;
    }

    public void setGunpowder(int n) {
        this.gunpowder = n;
    }

    public void validate() {
        GameUtil.uniqList(this.roleIds);
        GameUtil.uniqList(this.cultureIds);
        GameUtil.uniqList(this.technologyIds);
        GameUtil.uniqList(this.rentalKnightIds);
        GameUtil.uniqList(this.enemyToIds);
        GameUtil.uniqList(this.toubatsuToIds);
        GameUtil.uniqList(this.rentalReturnKnightIds);
        GameUtil.uniqList(this.toubatsuRemoveIds);
    }

    public String toString() {
        return "NegotiationActionEntry [daimyoId=" + this.daimyoId + "]";
    }
}

