/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.DataTable;
import game.sengoku.common.DataTableHeaderItem;
import game.sengoku.common.DataTableRecord;
import game.sengoku.common.DataTableRecordItem;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.SceneCommon;
import game.sengoku.main.KessenMain;
import game.sengoku.window.DataTableHeaderItemWindow;
import game.sengoku.window.DataTableRecordItemWindow;
import game.sengoku.window.SliderSprite;
import game.sengoku.window.VSliderSprite;
import java.util.ArrayList;
import java.util.List;

public abstract class SceneTableCommon
extends SceneCommon {
    protected List<DataTableHeaderItemWindow> labels;
    protected List<List<DataTableRecordItemWindow>> records;
    protected VSliderSprite vslider;
    protected SliderSprite slider;
    protected boolean recreate = false;
    protected DataTable dataTable;
    private int windowX = 0;

    public SceneTableCommon() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.labels = new ArrayList<DataTableHeaderItemWindow>();
        this.records = new ArrayList<List<DataTableRecordItemWindow>>();
        this.slider = new SliderSprite(10, 460, 100, 750, 30, false, MouseSymbolLayerManager.LAYER_NORMAL);
        this.slider.setValueChanged(() -> {
            this.recreate = true;
        });
        this.vslider = new VSliderSprite(760, this.getTopY() + 10, 100, 30, this.getRowMax() * 35 + 55, MouseSymbolLayerManager.LAYER_NORMAL);
        this.vslider.setValueChanged(() -> {
            this.recreate = true;
        });
        this.dataTable = new DataTable();
    }

    protected abstract int getTopY();

    protected abstract int getRowMax();

    protected abstract int getColumnMax();

    protected abstract void createTable();

    protected abstract void resetTable();

    @Override
    public void load() {
        super.load();
        this.createTable();
        this.createTableWindows();
        this.resetTable();
        this.resetTableWindows();
        this.recreate = false;
    }

    protected void createTableWindows() {
        this.labels.clear();
        this.records.clear();
        List<DataTableHeaderItem> list = this.dataTable.getHeader().getItems().subList(0, Math.min(this.dataTable.getHeader().getItems().size(), this.getColumnMax()));
        int n = 10;
        for (DataTableHeaderItem object22 : list) {
            DataTableHeaderItemWindow dataTableHeaderItemWindow = new DataTableHeaderItemWindow(n, this.getTopY() + 10, 100, object22.getLength(), 30, this.dataTable.getColorHeader(), this.dataTable.getColorHeader(), GameFontUtil.FONT16, this.dataTable.getFontColorHeader(), object22.getName());
            dataTableHeaderItemWindow.setItem(object22);
            this.labels.add(dataTableHeaderItemWindow);
            n += object22.getLength() + 3;
        }
        int n2 = 0;
        List<DataTableRecord> list2 = this.dataTable.getRecords().subList(0, Math.min(this.dataTable.getRecords().size(), this.getRowMax()));
        for (DataTableRecord dataTableRecord : list2) {
            ArrayList<DataTableRecordItemWindow> arrayList = new ArrayList<DataTableRecordItemWindow>();
            int n3 = this.getTopY() + 45 + n2 * 35;
            n = 10;
            List<DataTableRecordItem> list3 = dataTableRecord.getItems().subList(0, Math.min(dataTableRecord.getItems().size(), this.getColumnMax()));
            for (DataTableRecordItem dataTableRecordItem : list3) {
                DataTableRecordItemWindow dataTableRecordItemWindow = new DataTableRecordItemWindow(n, n3, 100, dataTableRecordItem.getLength(), 30, this.dataTable.getColor(), this.dataTable.getOverColor(), GameFontUtil.FONT16, this.dataTable.getFontColor(), dataTableRecordItem.getValue());
                dataTableRecordItemWindow.setItem(dataTableRecordItem);
                arrayList.add(dataTableRecordItemWindow);
                n += dataTableRecordItem.getLength() + 3;
            }
            this.records.add(arrayList);
            ++n2;
        }
        this.vslider.setX(n);
        this.vslider.setValueMin(0);
        this.vslider.setValueMax(Math.max(this.dataTable.getRecords().size() - this.getRowMax(), 0));
        this.vslider.setValue(0);
        this.slider.setY(this.getTopY() + 45 + (n2 + 1) * 35);
        this.slider.setValueMin(0);
        this.slider.setValueMax(Math.max(this.dataTable.getHeader().getItems().size() - this.getColumnMax(), 0));
        this.slider.setValue(0);
    }

    protected void resetTableWindows() {
        this.dataTable.update();
        List<DataTableHeaderItem> list2 = this.dataTable.getHeader().getItems();
        ArrayList<DataTableHeaderItem> arrayList = new ArrayList<DataTableHeaderItem>();
        if (0 < this.dataTable.getFixItem()) {
            arrayList.addAll(list2.subList(0, this.dataTable.getFixItem()));
            arrayList.addAll(list2.subList(this.slider.getValue() + this.dataTable.getFixItem(), list2.size()));
        } else {
            arrayList.addAll(list2.subList(this.slider.getValue(), list2.size()));
        }
        this.windowX = 10;
        GameUtil.zip(this.labels, arrayList, (dataTableHeaderItemWindow, dataTableHeaderItem) -> {
            dataTableHeaderItemWindow.setX(this.windowX);
            dataTableHeaderItemWindow.setWidth(dataTableHeaderItem.getLength());
            dataTableHeaderItemWindow.setMessages(dataTableHeaderItem.getName());
            dataTableHeaderItemWindow.setItem((DataTableHeaderItem)dataTableHeaderItem);
            this.windowX += dataTableHeaderItem.getLength() + 3;
        });
        List<DataTableRecord> list3 = this.dataTable.getRecords();
        List<DataTableRecord> list4 = list3.subList(this.vslider.getValue(), list3.size());
        GameUtil.zip(this.records, list4, (list, dataTableRecord) -> {
            int n = dataTableRecord.isDisabled() ? this.dataTable.getDisabledFontColor() : (dataTableRecord.isSelected() ? this.dataTable.getSelectedFontColor() : this.dataTable.getFontColor());
            List<DataTableRecordItem> list2 = dataTableRecord.getItems();
            ArrayList<DataTableRecordItem> arrayList = new ArrayList<DataTableRecordItem>();
            if (0 < this.dataTable.getFixItem()) {
                arrayList.addAll(list2.subList(0, this.dataTable.getFixItem()));
                arrayList.addAll(list2.subList(this.slider.getValue() + this.dataTable.getFixItem(), list2.size()));
            } else {
                arrayList.addAll(list2.subList(this.slider.getValue(), list2.size()));
            }
            this.windowX = 10;
            GameUtil.zip(list, arrayList, (dataTableRecordItemWindow, dataTableRecordItem) -> {
                dataTableRecordItemWindow.setX(this.windowX);
                dataTableRecordItemWindow.setWidth(dataTableRecordItem.getLength());
                dataTableRecordItemWindow.setMessages(dataTableRecordItem.getValue());
                dataTableRecordItemWindow.setFontColor(n);
                dataTableRecordItemWindow.setItem((DataTableRecordItem)dataTableRecordItem);
                this.windowX += dataTableRecordItem.getLength() + 3;
            });
        });
    }

    @Override
    public void update() {
        super.update();
        this.vslider.setVisible(this.vslider.getValueMin() < this.vslider.getValueMax());
        this.slider.setVisible(this.slider.getValueMin() < this.slider.getValueMax());
        this.vslider.update();
        this.slider.update();
        this.labels.forEach(dataTableHeaderItemWindow -> dataTableHeaderItemWindow.update());
        this.records.forEach(list -> list.forEach(dataTableRecordItemWindow -> dataTableRecordItemWindow.update()));
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.recreate) {
            this.resetTable();
            this.resetTableWindows();
            this.recreate = false;
        }
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.vslider.draw(this.bcontext);
        this.slider.draw(this.bcontext);
        this.labels.forEach(dataTableHeaderItemWindow -> dataTableHeaderItemWindow.draw(this.bcontext));
        this.records.forEach(list -> list.forEach(dataTableRecordItemWindow -> dataTableRecordItemWindow.draw(this.bcontext)));
    }

    protected void setWeights(int n, int n2) {
        int n3 = this.getItemIndex(n);
        if (n3 < 0) {
            return;
        }
        List<DataTableRecord> list = this.dataTable.getRecords();
        for (DataTableRecord dataTableRecord : list) {
            DataTableRecordItem dataTableRecordItem = dataTableRecord.getItems().get(n3);
            dataTableRecord.setWeight(dataTableRecordItem.getWeight() * n2);
        }
        this.recreate = true;
    }

    protected abstract int getItemIndex(int var1);
}

