/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.data.MapPosition;
import game.sengoku.data.SpotV;
import game.sengoku.game.HasIDSymbol;
import game.sengoku.game.SceneMapCommon;
import game.sengoku.main.KessenMain;
import java.util.List;

public abstract class SceneSpotSelector
extends SceneMapCommon {
    private Texture arraw;
    private int count = 0;

    public SceneSpotSelector() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.arraw = (Texture)graphicPool.getResource("arraw1.png");
        this.createSpotSymbols();
    }

    @Override
    public void load() {
        super.load();
        if (this.getGameTemp().getCenterSpotId() != 0) {
            SpotV spotV = (SpotV)this.getGameDataV().getSpots().get(this.getGameTemp().getCenterSpotId());
            MapPosition mapPosition = spotV.getPosition();
            this.shift(mapPosition.getX(), mapPosition.getY());
            this.getGameTemp().setCenterSpotId(0);
        }
        if (this.getGameTemp().getCandidateSpotIds().isEmpty()) {
            this.alert(0, () -> this.exit(), null, "\u5019\u88dc\u3068\u306a\u308b\u5730\u70b9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
    }

    protected void shiftCenter() {
        if (!this.getGameTemp().getCandidateSpotIds().isEmpty()) {
            int n = 0;
            int n2 = 0;
            for (int n3 : this.getGameTemp().getCandidateSpotIds()) {
                SpotV spotV = (SpotV)this.getGameDataV().getSpots().get(n3);
                MapPosition mapPosition = spotV.getPosition();
                n += mapPosition.getX();
                n2 += mapPosition.getY();
            }
            this.shift(n /= this.getGameTemp().getCandidateSpotIds().size(), n2 /= this.getGameTemp().getCandidateSpotIds().size(), true);
        }
    }

    @Override
    public void update() {
        super.update();
        ++this.count;
        List<Integer> list = this.getGameTemp().getCandidateSpotIds();
        HasIDSymbol hasIDSymbol2 = this.spotSymbols.parallelStream().filter(hasIDSymbol -> hasIDSymbol.getMouseSymbol().isMousePrimaryClicked()).filter(hasIDSymbol -> list.contains(hasIDSymbol.getId())).findAny().orElse(null);
        this.spotClicked(hasIDSymbol2);
    }

    protected abstract void spotClicked(HasIDSymbol var1);

    protected abstract void spotSelected(int var1);

    @Override
    public void selectSpot(int n) {
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        int n = 10 < this.count % 20 ? 20 - this.count % 20 : this.count % 20;
        List<Integer> list = this.getGameTemp().getCandidateSpotIds();
        this.getGameData().getMap().getPositions().forEach((n2, mapPosition) -> {
            if (list.contains(n2)) {
                this.bcontext.drawImage(this.arraw, 0, 0, 380, 380, mapPosition.getX() - 12 + x, mapPosition.getY() - 22 + y - n, 25, 25, 90);
            }
        });
    }

    protected abstract void forward();
}

