/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.base.common.HasAbsoluteXY;
import game.base.common.HasXY;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.BorderConflictV;
import game.sengoku.data.Build;
import game.sengoku.data.CountryV;
import game.sengoku.data.MapPosition;
import game.sengoku.data.SpotV;
import game.sengoku.data.UnitV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.GameTacticsUtil;
import game.sengoku.game.HasIDSymbol;
import game.sengoku.game.WorldMapSpriteSet;
import game.sengoku.main.KessenMain;
import game.sengoku.window.BorderConflictSprite;
import game.sengoku.window.ToggleButtonSprite;
import game.sengoku.window.UnitEffectSprite;
import game.sengoku.window.UnitSprite;
import game.sengoku.window.WindowMapInfo;
import game.sengoku.window.WindowMapUnitInfo;
import game.sengoku.window.WindowYearInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SceneMapCommon
extends SceneCommon
implements HasAbsoluteXY {
    protected WorldMapSpriteSet worldMapSpriteSet;
    protected List<HasIDSymbol> spotSymbols = new ArrayList<HasIDSymbol>();
    protected List<HasIDSymbol> buildSymbols = new ArrayList<HasIDSymbol>();
    protected int overSpotId = -1;
    protected int overBuildId = -1;
    protected int overUnitId = -1;
    protected static int x = -1000;
    protected static int y = -1000;
    protected boolean enableDrag = true;
    private static final int DRAG_SPEED = 5;
    protected WindowMapInfo info;
    protected WindowMapUnitInfo unitInfo;
    protected WindowYearInfo year;
    protected Set<Integer> visibles = new HashSet<Integer>();
    protected Map<Integer, UnitSprite> units = new HashMap<Integer, UnitSprite>();
    protected Map<Integer, UnitEffectSprite> uniteffects = new HashMap<Integer, UnitEffectSprite>();
    protected List<BorderConflictSprite> borderConflictSprites;
    private ToggleButtonSprite borderOption;
    private ToggleButtonSprite buildOption;

    public SceneMapCommon() {
        this.worldMapSpriteSet = WorldMapSpriteSet.getInstance(this.getGameData(), this.getGameDataV());
        this.year = new WindowYearInfo(590, 10, 1000, 200, 80, this.getGameDataV().getWorld());
        this.info = new WindowMapInfo(590, 410, 1000, 200, 180, this.getGameDataV());
        this.unitInfo = new WindowMapUnitInfo(590, 210, 1000, 200, 180, this.getGameDataV());
        this.unitInfo.setDaimyo(this.getDaimyo());
        this.borderConflictSprites = new ArrayList<BorderConflictSprite>();
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        Texture texture = (Texture)graphicPool.getResource("borderoff.png");
        Texture texture2 = (Texture)graphicPool.getResource("borderon.png");
        this.borderOption = new ToggleButtonSprite(5, 65, 2000, 25, 25, texture, texture2);
        this.borderOption.setValueChanged(bl -> this.getGameTemp().setBorderView((boolean)bl));
        Texture texture3 = (Texture)graphicPool.getResource("buildoff.png");
        Texture texture4 = (Texture)graphicPool.getResource("buildon.png");
        this.buildOption = new ToggleButtonSprite(5, 95, 2000, 25, 25, texture3, texture4);
        this.buildOption.setValueChanged(bl -> this.getGameTemp().setBuildView((boolean)bl));
    }

    @Override
    public void load() {
        super.load();
        this.updateSumCost();
        this.optionUse = false;
        this.visibles = GameTacticsUtil.getVisibleSpotIds(this.getGameDataV(), this.getDaimyo().getId());
        this.worldMapSpriteSet.refreshBuildsLayer(this.getGameData(), this.getGameDataV());
        this.year.needUpdate();
        this.borderOption.setFlag(this.getGameTemp().isBorderView());
        this.buildOption.setFlag(this.getGameTemp().isBuildView());
    }

    protected void shiftCapital() {
        SpotV spotV = ((CountryV)this.getPlayerClient().getDaimyoV().getCountries().get(0)).getCapitalSpot();
        MapPosition mapPosition = spotV.getPosition();
        this.shift(mapPosition.getX(), mapPosition.getY());
    }

    protected void createConflicts() {
        this.borderConflictSprites.clear();
        for (BorderConflictV borderConflictV : this.getGameDataV().getBorderConflicts()) {
            MapPosition mapPosition = borderConflictV.getSpot1().getPosition();
            MapPosition mapPosition2 = borderConflictV.getSpot2().getPosition();
            BorderConflictSprite borderConflictSprite = new BorderConflictSprite((mapPosition.getX() + mapPosition2.getX()) / 2 + x - 12, (mapPosition.getY() + mapPosition2.getY()) / 2 + y - 12, 200, borderConflictV);
            borderConflictSprite.setMouseEnter(windowClickable -> this.info.setBorderConflict(borderConflictV));
            borderConflictSprite.setMouseExit(windowClickable -> this.info.setBorderConflict(null));
            this.borderConflictSprites.add(borderConflictSprite);
        }
    }

    protected void createUnits() {
        MapPosition mapPosition;
        this.units.clear();
        this.uniteffects.clear();
        for (UnitV unitV2 : this.getGameDataV().getUnits().values()) {
            if (!this.visibles.contains(unitV2.getSpotId())) continue;
            mapPosition = unitV2.getSpot().getPosition();
            UnitSprite unitSprite = new UnitSprite(mapPosition.getX() + x - 12, mapPosition.getY() + y - 12, 200, this.getDaimyo(), unitV2);
            unitSprite.setMouseEnter(windowClickable -> {
                this.overUnitId = unitV2.getId();
            });
            unitSprite.setMouseExit(windowClickable -> {
                if (this.overUnitId == unitV2.getId()) {
                    this.overUnitId = -1;
                }
            });
            unitSprite.setPrimaryClicked(windowClickable -> this.selectUnit(unitSprite));
            UnitEffectSprite unitEffectSprite = new UnitEffectSprite(mapPosition.getX() + x - 17, mapPosition.getY() + y - 17, 200, unitSprite);
            this.units.put(unitV2.getId(), unitSprite);
            this.uniteffects.put(unitV2.getId(), unitEffectSprite);
        }
        Iterator<Object> iterator = this.visibles.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            mapPosition = (SpotV)this.getGameDataV().getSpots().get(n2);
            mapPosition.updateUnits();
            GameUtil.eachWithIndex(mapPosition.getUnits(), (n, unitV) -> {
                UnitSprite unitSprite = this.units.get(unitV.getId());
                if (n != 0 && n < 5) {
                    int n2 = n - 1;
                    unitSprite.setX(unitSprite.getX() - 12 + 24 * (n2 % 2));
                    unitSprite.setY(unitSprite.getY() - 12 + 24 * (n2 / 2));
                }
            });
        }
    }

    protected void createSpotSymbols() {
        this.spotSymbols.clear();
        this.getGameData().getMap().getPositions().forEach((n, mapPosition) -> this.createSpotSymbol((int)n, mapPosition.getX(), mapPosition.getY()));
    }

    private void createSpotSymbol(int n, int n2, int n3) {
        HasIDSymbol hasIDSymbol = new HasIDSymbol(n2 - 12, n3 - 12, 25, 25, MouseSymbolLayerManager.LAYER_NORMAL, this, n);
        hasIDSymbol.setMouseEnter(commonSymbol -> {
            this.overSpotId = ((HasIDSymbol)commonSymbol).getId();
            this.overBuildId = -1;
        });
        hasIDSymbol.setPrimaryClicked(commonSymbol -> {
            this.overSpotId = ((HasIDSymbol)commonSymbol).getId();
            this.overBuildId = -1;
            this.selectSpot(this.overSpotId);
        });
        this.spotSymbols.add(hasIDSymbol);
    }

    protected void createBuildSymbols() {
        this.buildSymbols.clear();
        this.getGameDataV().getSpots().forEach((n, spotV) -> {
            MapPosition mapPosition = (MapPosition)this.getGameData().getMap().getPositions().get(n);
            int n2 = 0;
            List<Build> list = GameCommandUtil.getVisibleBuilds(spotV);
            for (Build build : list) {
                this.createBuildSymbol(mapPosition.getX(), mapPosition.getY(), build, n2);
                ++n2;
            }
        });
    }

    private void createBuildSymbol(int n, int n2, Build build, int n3) {
        int[] nArray = this.worldMapSpriteSet.createBuildRect(n, n2, n3, build);
        HasIDSymbol hasIDSymbol = new HasIDSymbol(nArray[0], nArray[1], nArray[2], nArray[3], MouseSymbolLayerManager.LAYER_NORMAL, this, build.getId());
        hasIDSymbol.setMouseEnter(commonSymbol -> {
            this.overBuildId = ((HasIDSymbol)commonSymbol).getId();
            this.overSpotId = -1;
        });
        this.buildSymbols.add(hasIDSymbol);
    }

    @Override
    public void update() {
        Object object;
        super.update();
        if (this.enableDrag && MouseSymbolLayerManager.LAYER_NORMAL.isActive()) {
            object = KessenMain.getInstance().getInput();
            if (object.isDragged()) {
                x += object.getMouseDraggedX() * 5;
                y += object.getMouseDraggedY() * 5;
            }
            int n2 = x > 0 ? 0 : (x = -3200 > x ? -3200 : x);
            y = y > 0 ? 0 : (-2400 > y ? -2400 : y);
        }
        this.spotSymbols.forEach(hasIDSymbol -> hasIDSymbol.update());
        this.buildSymbols.forEach(hasIDSymbol -> hasIDSymbol.update());
        this.units.forEach((n, unitSprite) -> {
            if (!unitSprite.isFixed()) {
                MapPosition mapPosition = unitSprite.getUnit().getSpot().getPosition();
                unitSprite.setX(mapPosition.getX() + x - 12);
                unitSprite.setY(mapPosition.getY() + y - 12);
            }
        });
        object = this.visibles.iterator();
        while (object.hasNext()) {
            int n3 = (Integer)object.next();
            SpotV spotV = (SpotV)this.getGameDataV().getSpots().get(n3);
            GameUtil.eachWithIndex(spotV.getUnits(), (n, unitV) -> {
                UnitSprite unitSprite = this.units.get(unitV.getId());
                if (unitSprite != null && !unitSprite.isFixed() && n != 0 && n < 5) {
                    int n2 = n - 1;
                    unitSprite.setX(unitSprite.getX() - 12 + 24 * (n2 % 2));
                    unitSprite.setY(unitSprite.getY() - 12 + 24 * (n2 / 2));
                }
            });
        }
        this.units.forEach((n, unitSprite) -> unitSprite.update());
        this.uniteffects.forEach((n, unitEffectSprite) -> unitEffectSprite.update());
        object = this.uniteffects.keySet();
        Iterator<Integer> iterator = object.iterator();
        while (iterator.hasNext()) {
            int n4 = iterator.next();
            if (this.units.containsKey(n4)) continue;
            this.uniteffects.remove(n4);
        }
        this.borderConflictSprites.forEach(borderConflictSprite -> {
            BorderConflictV borderConflictV = borderConflictSprite.getBorderConflict();
            MapPosition mapPosition = borderConflictV.getSpot1().getPosition();
            MapPosition mapPosition2 = borderConflictV.getSpot2().getPosition();
            borderConflictSprite.setX((mapPosition.getX() + mapPosition2.getX()) / 2 + x - 12);
            borderConflictSprite.setY((mapPosition.getY() + mapPosition2.getY()) / 2 + y - 12);
            borderConflictSprite.update();
        });
        this.info.setId(this.overSpotId, this.overBuildId);
        this.info.update();
        this.year.update();
        this.unitInfo.setUnitId(this.overUnitId);
        this.unitInfo.setVisible(0 < this.overUnitId);
        this.unitInfo.update();
        this.borderOption.update();
        this.buildOption.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.worldMapSpriteSet.getBackgroundLayer(), -x, -y, 800, 600, 0, 0, 10);
        this.bcontext.drawImage(this.worldMapSpriteSet.getSpotLayer(), -x, -y, 800, 600, 0, 0, 20);
        if (this.getGameTemp().isBuildView()) {
            this.bcontext.drawImage(this.worldMapSpriteSet.getBuildsLayer(), -x, -y, 800, 600, 0, 0, 30);
        } else {
            this.bcontext.drawImage(this.worldMapSpriteSet.getCastleLayer(), -x, -y, 800, 600, 0, 0, 30);
        }
        if (this.getGameTemp().isBorderView()) {
            this.bcontext.drawImage(this.worldMapSpriteSet.getBorderLayer(), -x, -y, 800, 600, 0, 0, 40);
        }
        this.units.forEach((n, unitSprite) -> unitSprite.draw(this.bcontext));
        this.uniteffects.forEach((n, unitEffectSprite) -> unitEffectSprite.draw(this.bcontext));
        this.borderConflictSprites.forEach(borderConflictSprite -> borderConflictSprite.draw(this.bcontext));
        this.info.draw(this.bcontext);
        this.year.draw(this.bcontext);
        this.unitInfo.draw(this.bcontext);
        this.borderOption.draw(this.bcontext);
        this.buildOption.draw(this.bcontext);
    }

    @Override
    protected void shiftToSpot(int n) {
        super.shiftToSpot(n);
        MapPosition mapPosition = (MapPosition)this.getGameData().getMap().getPositions().get(n);
        if (mapPosition != null) {
            this.shift(mapPosition.getX(), mapPosition.getY(), false);
        }
    }

    protected void shift(int n, int n2) {
        if (this.getGameTemp() != null) {
            this.shift(n, n2, this.getGameTemp().isForceShift());
            this.getGameTemp().setForceShift(false);
        } else {
            this.shift(n, n2, false);
        }
    }

    protected void shift(int n, int n2, boolean bl) {
        if (!bl && -x + 50 <= n && n <= -x + 800 - 50 && -y + 30 <= n2 && n2 <= -y + 600 - 30) {
            return;
        }
        x = -(n - 400);
        y = -(n2 - 300);
        int n3 = x > 0 ? 0 : (x = -3200 > x ? -3200 : x);
        y = y > 0 ? 0 : (-2400 > y ? -2400 : y);
    }

    @Override
    public int getX() {
        return x;
    }

    @Override
    public int getY() {
        return y;
    }

    @Override
    public HasXY getParent() {
        return null;
    }

    public void selectSpot(int n) {
        MapPosition mapPosition = (MapPosition)this.getGameData().getMap().getPositions().get(n);
        this.shift(mapPosition.getX(), mapPosition.getY());
    }

    public void selectUnit(UnitSprite unitSprite) {
    }
}

