/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.base.input.InputInterface;
import game.sengoku.common.AudioUtil;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameUtil;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameData;
import game.sengoku.data.GameHistory;
import game.sengoku.data.WorldDataV;
import game.sengoku.main.KessenMain;
import game.sengoku.window.WindowMessage;
import java.util.ArrayList;
import java.util.List;

public class SceneGameFinal
extends SceneCommon {
    private Texture backGraund;
    private Texture minimap;
    private DaimyoV daimyo;
    private boolean scroll = false;
    private boolean scrollend = false;
    private boolean backToTitle = false;
    private List<WindowMessage> histories;

    public SceneGameFinal() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        GameData gameData = this.getGameData();
        this.minimap = (Texture)graphicPool.getResource(gameData.getMap().getImageMini());
        this.histories = new ArrayList<WindowMessage>();
    }

    @Override
    public void load() {
        super.load();
        boolean bl = this.getDaimyo().getId() == this.getGameTemp().getConquerDaimyoId();
        AudioUtil.musicPlay(bl ? 9 : 7);
        this.scroll = false;
        this.scrollend = false;
        this.backToTitle = false;
        this.histories.clear();
        this.daimyo = (DaimyoV)this.getGameDataV().getDaimyos().get(this.getGameTemp().getConquerDaimyoId());
        WorldDataV worldDataV = this.getGameDataV().getWorld();
        if (bl) {
            if (this.daimyo.getFame() < 0) {
                this.alert(0, () -> this.alert(0, () -> this.startScroll(), null, "game clear(dark side)"), null, worldDataV.getGengo() + worldDataV.getGengoYear() + "\u5e74\u3001" + "\u5929\u4e0b\u306f" + this.daimyo.getName() + "\u306b\u3088\u3063\u3066\u7d71\u4e00\u3055\u308c\u307e\u3057\u305f\u3002", this.daimyo.getKnight().getFullName() + "\u3068\u305d\u306e\u5a01\u5149\u3092\u7b20\u306b\u7740\u305f\u5bb6\u81e3\u305f\u3061\u306b\u3088\u3063\u3066\u3001\u5929\u4e0b\u306b\u306f\u60aa\u653f\u304c\u6577\u304b\u308c\u3001" + "\u6c11\u306f\u6028\u55df\u306e\u58f0\u3092\u4e0a\u3052\u307e\u3057\u305f\u3002", "\u9577\u304f\u82e6\u3057\u3044\u6642\u4ee3\u306e\u59cb\u307e\u308a\u3067\u3059\u3002");
            } else {
                this.alert(0, () -> this.alert(0, () -> this.startScroll(), null, "game clear"), null, worldDataV.getGengo() + worldDataV.getGengoYear() + "\u5e74\u3001" + "\u5929\u4e0b\u306f" + this.daimyo.getName() + "\u306b\u3088\u3063\u3066\u7d71\u4e00\u3055\u308c\u307e\u3057\u305f\u3002", this.daimyo.getKnight().getFullName() + "\u3068\u305d\u306e\u5bb6\u81e3\u305f\u3061\u306e\u5584\u653f\u306b\u3088\u3063\u3066\u3001\u9577\u304f\u5e73\u548c\u306a\u6642\u4ee3\u304c\u59cb\u307e\u308a\u307e\u3057\u305f\u3002");
            }
        } else if (this.daimyo != null) {
            this.alert(0, () -> this.alert(0, () -> {
                this.scrollend = true;
            }, null, "game over"), null, worldDataV.getGengo() + worldDataV.getGengoYear() + "\u5e74\u3001" + "\u5929\u4e0b\u306f" + this.daimyo.getName() + "\u306b\u3088\u3063\u3066\u7d71\u4e00\u3055\u308c\u307e\u3057\u305f\u3002");
        } else {
            this.alert(0, () -> this.alert(0, () -> {
                this.scrollend = true;
            }, null, "game clear?"), null, worldDataV.getYear() + "\u5e74\u306b\u306a\u308a\u307e\u3057\u305f\u3002", "\u3042\u306a\u305f\u306e\u52e2\u529b\u306f\u3001\u9577\u3044\u6226\u4e71\u306e\u4e16\u3092\u751f\u304d\u629c\u304f\u3053\u3068\u306f\u51fa\u6765\u307e\u3057\u305f\u304c\u3001\u6b8b\u5ff5\u306a\u304c\u3089\u5929\u4e0b\u3092\u624b\u4e2d\u306b\u304a\u3055\u3081\u308b\u306b\u306f\u81f3\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u4e71\u4e16\u306f\u3053\u308c\u304b\u3089\u3082\u7d9a\u304d\u307e\u3059\u3002\u679c\u305f\u3057\u3066\u3001\u3042\u306a\u305f\u306e\u52e2\u529b\u306f\u4eca\u5f8c\u3082\u751f\u304d\u6b8b\u308a\u7d9a\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u308b\u306e\u3067\u3057\u3087\u3046\u304b\uff1f");
        }
        this.setReceiveNotice(false);
    }

    @Override
    public void update() {
        super.update();
        if (this.backToTitle) {
            this.restart();
        } else if (this.scrollend) {
            InputInterface inputInterface = KessenMain.getInstance().getInput();
            inputInterface.setActive(true);
            if (inputInterface.isMouseSecondaryClicked() || inputInterface.isMousePrimaryClicked()) {
                this.alert(0, () -> {
                    this.backToTitle = true;
                }, null, "\u30bf\u30a4\u30c8\u30eb\u753b\u9762\u306b\u623b\u308a\u307e\u3059\u3002");
            }
        } else if (this.scroll) {
            this.histories.forEach(windowMessage -> {
                windowMessage.setY(windowMessage.getY() - 1);
                windowMessage.setVisible(10 <= windowMessage.getY() && windowMessage.getY() <= 450);
                windowMessage.update();
            });
            this.histories.removeIf(windowMessage -> windowMessage.getY() < 10);
            if (this.histories.isEmpty()) {
                this.scrollend = true;
                this.scroll = false;
            }
        }
    }

    protected void startScroll() {
        this.scroll = true;
        AudioUtil.musicPlay(8);
        this.createHistories();
    }

    private String getYMD(GameHistory gameHistory) {
        return gameHistory.getGengo() + gameHistory.getGengoYear() + "\u5e74" + (gameHistory.isIntercalary() ? "\u958f" : "") + gameHistory.getMonth() + "\u6708" + gameHistory.getDay() + "\u65e5";
    }

    private void createHistories() {
        this.histories.clear();
        List list = this.getPlayer().getHistories();
        int n = 10;
        for (GameHistory gameHistory : list) {
            String[] stringArray;
            if (!gameHistory.getMessages().isEmpty()) {
                stringArray = (String)gameHistory.getMessages().get(0);
                gameHistory.getMessages().remove(0);
                gameHistory.getMessages().add(0, this.getYMD(gameHistory) + "  " + (String)stringArray);
            }
            stringArray = GameUtil.splitMessages(29, gameHistory.getMessages());
            this.histories.add(new WindowMessage(50, n * 50, 100, 700, 100, 0, GameFontUtil.FONT20, -319753729, stringArray));
            ++n;
        }
        this.histories.forEach(windowMessage -> windowMessage.setVisible(false));
    }

    protected void restart() {
        KessenMain.getInstance().restart();
    }

    @Override
    public void unLoad() {
        super.unLoad();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.scroll || this.scrollend) {
            this.bcontext.drawImage(this.backGraund, 0, 0, -100);
            this.histories.forEach(windowMessage -> {
                if (windowMessage.isVisible()) {
                    windowMessage.draw(this.bcontext);
                }
            });
        } else {
            this.bcontext.drawImage(this.backGraund, 0, 0, -100);
            this.bcontext.drawImage(this.minimap, 150, 10, 10);
        }
    }

    @Override
    protected void exit() {
    }
}

