/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.AudioUtil;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.GameData;
import game.sengoku.main.KessenMain;

public class SceneDaimyoFall
extends SceneCommon {
    private Texture backGraund;
    private Texture minimap;
    private boolean isEnd = false;

    public SceneDaimyoFall() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        GameData gameData = this.getGameData();
        this.minimap = (Texture)graphicPool.getResource(gameData.getMap().getImageMini());
    }

    @Override
    public void load() {
        super.load();
        this.isEnd = true;
        AudioUtil.musicPlay(7);
        this.alert(0, () -> {
            this.isEnd = true;
        }, () -> {
            this.isEnd = true;
        }, "\u3042\u306a\u305f\u306f\u6ec5\u4ea1\u3057\u307e\u3057\u305f\u3002");
        this.setReceiveNotice(false);
    }

    @Override
    public void update() {
        super.update();
        if (!this.isMessageExists() && this.isEnd) {
            KessenMain.getInstance().restart();
        }
    }

    @Override
    protected void exit() {
    }

    @Override
    public void unLoad() {
        super.unLoad();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.bcontext.drawImage(this.minimap, 150, 10, 10);
    }
}

