/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.sengoku.common.AINegotiationUtil;
import game.sengoku.common.TacticsActionEntryValueRecord;
import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.KnightV;
import game.sengoku.data.RoleV;
import game.sengoku.data.TechnologyV;
import game.sengoku.game.diplomacy.NegotiationAction;
import game.sengoku.game.diplomacy.NegotiationActionEntry;
import game.sengoku.game.diplomacy.NegotiationValueTable;
import game.sengoku.server.GameMessage;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GameDebugUtil {
    static PrintWriter printWriter;
    private static int centerServerStatus;
    private static int serverStatus;
    private static Map<Integer, Integer> clientStatus;

    public static void printSpots(GameDataV gameDataV, List<Integer> list) {
    }

    public static void print(GameMessage gameMessage) {
    }

    public static void printCenterServerStatus(int n, int n2) {
    }

    public static void printServerStatus(int n, int n2) {
    }

    public static void printClientStatus(int n, int n2) {
    }

    public static void printNegotiation(GameDataV gameDataV, NegotiationAction negotiationAction) {
        System.out.print("[");
        GameDebugUtil.printNegotiationEntry(gameDataV, negotiationAction.getSelfEntry());
        GameDebugUtil.printNegotiationEntry(gameDataV, negotiationAction.getTargetEntry());
        int n = negotiationAction.getSelfEntry().getDaimyoId();
        int n2 = negotiationAction.getTargetEntry().getDaimyoId();
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        NegotiationValueTable negotiationValueTable = new NegotiationValueTable(gameDataV, daimyoV);
        NegotiationValueTable negotiationValueTable2 = new NegotiationValueTable(gameDataV, daimyoV2);
        ArrayList<TacticsActionEntryValueRecord> arrayList = new ArrayList<TacticsActionEntryValueRecord>();
        AINegotiationUtil.valuing(gameDataV, negotiationAction, daimyoV, daimyoV2, negotiationValueTable, negotiationValueTable2, arrayList);
        int n3 = arrayList.stream().mapToInt(tacticsActionEntryValueRecord -> tacticsActionEntryValueRecord.getSelfMerit()).sum();
        int n4 = arrayList.stream().mapToInt(tacticsActionEntryValueRecord -> tacticsActionEntryValueRecord.getSelfDemerit()).sum();
        int n5 = arrayList.stream().mapToInt(tacticsActionEntryValueRecord -> tacticsActionEntryValueRecord.getTargetMerit()).sum();
        int n6 = arrayList.stream().mapToInt(tacticsActionEntryValueRecord -> tacticsActionEntryValueRecord.getTargetDemerit()).sum();
        int n7 = n5 - n6 - (n3 - n4);
        int n8 = AINegotiationUtil.negotiationLower(gameDataV, daimyoV2, daimyoV);
        System.out.println("SelfMerit:" + n3 + " SelfDemerit:" + n4 + " TargetMerit:" + n5 + " TargetDemerit:" + n6 + " Total:" + n8 + " < " + n7 + "]");
    }

    public static void printNegotiationEntry(GameDataV gameDataV, NegotiationActionEntry negotiationActionEntry) {
        TechnologyV technologyV;
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(negotiationActionEntry.getDaimyoId());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(daimyoV.getName() + "[");
        if (negotiationActionEntry.isAlliance()) {
            stringBuilder.append("\u540c\u76df,");
        }
        if (negotiationActionEntry.isNonAggression()) {
            stringBuilder.append("\u505c\u6226,");
        }
        if (negotiationActionEntry.isSurrender()) {
            stringBuilder.append("\u964d\u4f0f,");
        }
        if (negotiationActionEntry.isBreakWith()) {
            stringBuilder.append("\u624b\u5207\u308a,");
        }
        if (negotiationActionEntry.isBorder()) {
            stringBuilder.append("\u56fd\u5883\u7d1b\u4e89\u89e3\u6c7a,");
        }
        if (negotiationActionEntry.isDetente()) {
            stringBuilder.append("\u548c\u89e3,");
        }
        if (0 < negotiationActionEntry.getMoney()) {
            stringBuilder.append("\u91d1 " + negotiationActionEntry.getMoney() + ",");
        }
        if (0 < negotiationActionEntry.getGun()) {
            stringBuilder.append("\u9244\u7832 " + negotiationActionEntry.getGun() + ",");
        }
        if (0 < negotiationActionEntry.getHorse()) {
            stringBuilder.append("\u99ac " + negotiationActionEntry.getHorse() + ",");
        }
        if (0 < negotiationActionEntry.getIron()) {
            stringBuilder.append("\u9244 " + negotiationActionEntry.getIron() + ",");
        }
        if (0 < negotiationActionEntry.getSaltpeter()) {
            stringBuilder.append("\u785d\u77f3 " + negotiationActionEntry.getSaltpeter() + ",");
        }
        if (0 < negotiationActionEntry.getGunpowder()) {
            stringBuilder.append("\u706b\u85ac " + negotiationActionEntry.getGunpowder() + ",");
        }
        for (int n : negotiationActionEntry.getTechnologyIds()) {
            technologyV = (TechnologyV)gameDataV.getTechnologies().get(n);
            stringBuilder.append(technologyV.getName() + ",");
        }
        for (int n : negotiationActionEntry.getCultureIds()) {
            technologyV = (CultureV)gameDataV.getCultures().get(n);
            stringBuilder.append(technologyV.getName() + ",");
        }
        for (int n : negotiationActionEntry.getRoleIds()) {
            technologyV = (RoleV)gameDataV.getRoles().get(n);
            stringBuilder.append(technologyV.getName() + ",");
        }
        for (int n : negotiationActionEntry.getRentalKnightIds()) {
            technologyV = (KnightV)gameDataV.getKnights().get(n);
            stringBuilder.append("\u4eba\u8cea(" + technologyV.getFullName() + "),");
        }
        for (int n : negotiationActionEntry.getRentalReturnKnightIds()) {
            technologyV = (KnightV)gameDataV.getKnights().get(n);
            stringBuilder.append("\u4eba\u8cea\u8fd4\u9084(" + technologyV.getFullName() + "),");
        }
        for (int n : negotiationActionEntry.getBreakIds()) {
            technologyV = (DaimyoV)gameDataV.getDaimyos().get(n);
            stringBuilder.append("\u624b\u5207\u308a(" + technologyV.getName() + "),");
        }
        for (int n : negotiationActionEntry.getEnemyToIds()) {
            technologyV = (DaimyoV)gameDataV.getDaimyos().get(n);
            stringBuilder.append("\u6575\u5bfe(" + technologyV.getName() + "),");
        }
        for (int n : negotiationActionEntry.getToubatsuToIds()) {
            technologyV = (DaimyoV)gameDataV.getDaimyos().get(n);
            stringBuilder.append("\u8a0e\u4f10\u4ee4(" + technologyV.getName() + "),");
        }
        for (int n : negotiationActionEntry.getToubatsuRemoveIds()) {
            technologyV = (DaimyoV)gameDataV.getDaimyos().get(n);
            stringBuilder.append("\u8a0e\u4f10\u4ee4\u89e3\u9664(" + technologyV.getName() + "),");
        }
        stringBuilder.append("]");
        System.out.println(stringBuilder.toString());
    }

    public static String getCenterServerStatusName(int n) {
        switch (n) {
            case 1: {
                return "\u30b2\u30fc\u30e0\u53c2\u52a0\u8981\u6c42\u5f85\u53d7\u72b6\u614b";
            }
            case 24: {
                return "\u30b2\u30fc\u30e0\u53c2\u52a0\u8981\u6c42\u5f85\u53d7\u72b6\u614b(AI)";
            }
            case 21: {
                return "\u30b7\u30ca\u30ea\u30aa\u9078\u629e\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 22: {
                return "\u5927\u540d\u9078\u629e\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 23: {
                return "\u30ed\u30fc\u30c9\u30c7\u30fc\u30bf\u9078\u629e\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 2: {
                return "\u30b2\u30fc\u30e0\u958b\u59cb\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 25: {
                return "\u30b2\u30fc\u30e0\u30c7\u30fc\u30bf\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
        }
        return "";
    }

    public static String getServerStatusName(int n) {
        switch (n) {
            case 1: {
                return "\u30b2\u30fc\u30e0\u958b\u59cb\u8981\u6c42\u5f85\u53d7\u72b6\u614b";
            }
            case 2: {
                return "\u30b2\u30fc\u30e0\u958b\u59cb\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 31: {
                return "\u5185\u653f\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u8981\u6c42\u4e2d";
            }
            case 3: {
                return "\u5185\u653f\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 25: {
                return "\u5185\u653f\u30a4\u30d9\u30f3\u30c8\u63d0\u51fa\u8981\u6c42\u4e2d";
            }
            case 24: {
                return "\u5185\u653f\u30a4\u3079\u30f3\u30c8\u63d0\u51fa\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 12: {
                return "\u5185\u653f\u884c\u52d5\u63d0\u51fa\u8981\u6c42\u4e2d";
            }
            case 21: {
                return "\u5185\u653f\u7d50\u679c\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 4: {
                return "\u5185\u653f\u884c\u52d5\u63d0\u51fa\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 5: {
                return "\u5916\u4ea4\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 13: {
                return "\u5916\u4ea4\u884c\u52d5\u63d0\u51fa\u8981\u6c42\u4e2d";
            }
            case 15: {
                return "\u5916\u4ea4\u884c\u52d5\u63d0\u51fa\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 32: {
                return "\u5916\u4ea4\u8981\u6c42\u63d0\u51fa\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 6: {
                return "\u5916\u4ea4\u30c1\u30e3\u30f3\u30cd\u30eb\u30aa\u30fc\u30d7\u30f3\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 7: {
                return "\u5916\u4ea4\u8981\u6c42\u63d0\u51fa\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 8: {
                return "\u4ea4\u6e09\u59a5\u7d50/\u6c7a\u88c2\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 9: {
                return "\u884c\u8ecd\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 14: {
                return "\u884c\u8ecd\u63d0\u51fa\u8981\u6c42\u4e2d";
            }
            case 10: {
                return "\u884c\u8ecd\u63d0\u51fa\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 11: {
                return "\u884c\u8ecd\u53cd\u6620\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 22: {
                return "\u884c\u8ecd\u7d42\u4e86\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 26: {
                return "\u5e55\u9593\u884c\u52d5\u63d0\u51fa\u8981\u6c42\u4e2d";
            }
            case 27: {
                return "\u5e55\u9593\u884c\u52d5\u63d0\u51fa\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 28: {
                return "\u30b2\u30fc\u30e0\u7d42\u4e86\u8981\u6c42\u4e2d";
            }
            case 29: {
                return "\u30b2\u30fc\u30e0\u7d42\u4e86\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
        }
        return "";
    }

    public static String getClientStatusName(int n) {
        switch (n) {
            case 0: {
                return "\u30b2\u30fc\u30e0\u53c2\u52a0\u5165\u529b\u4e2d";
            }
            case 1: {
                return "\u30b2\u30fc\u30e0\u53c2\u52a0\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 21: {
                return "\u30b7\u30ca\u30ea\u30aa\u9078\u629e\u4e2d";
            }
            case 24: {
                return "\u5927\u540d\u9078\u629e\u8981\u6c42\u5f85\u53d7\u72b6\u614b";
            }
            case 22: {
                return "\u5927\u540d\u9078\u629e\u4e2d";
            }
            case 23: {
                return "\u30ed\u30fc\u30c9\u30c7\u30fc\u30bf\u9078\u629e\u4e2d";
            }
            case 2: {
                return "\u30b2\u30fc\u30e0\u958b\u59cb\u5f85\u53d7\u72b6\u614b";
            }
            case 3: {
                return "\u5185\u653f\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u4e2d";
            }
            case 4: {
                return "\u5185\u653f\u884c\u52d5\u63d0\u51fa\u8981\u6c42\u5f85\u53d7\u72b6\u614b";
            }
            case 41: {
                return "\u5185\u653f\u884c\u52d5\u5165\u529b\u4e2d";
            }
            case 5: {
                return "\u5185\u653f\u884c\u52d5\u5165\u529b\u4e2d";
            }
            case 36: {
                return "\u5185\u653f\u7d50\u679c\u5165\u529b\u4e2d";
            }
            case 37: {
                return "\u5916\u4ea4\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u4e2d";
            }
            case 17: {
                return "\u5916\u4ea4\u884c\u52d5\u63d0\u51fa\u8981\u6c42\u5f85\u53d7\u72b6\u614b";
            }
            case 18: {
                return "\u5916\u4ea4\u884c\u52d5\u5165\u529b\u4e2d";
            }
            case 8: {
                return "\u5916\u4ea4\u30c1\u30e3\u30f3\u30cd\u30eb\u30aa\u30fc\u30d7\u30f3\u4e2d";
            }
            case 9: {
                return "\u5916\u4ea4\u8981\u6c42\u63d0\u51fa\u8981\u6c42\u5f85\u53d7\u72b6\u614b";
            }
            case 10: {
                return "\u5916\u4ea4\u8981\u6c42\u63d0\u51fa\u4e2d";
            }
            case 44: {
                return "\u8cfc\u5165\u8981\u6c42\u63d0\u51fa\u4e2d";
            }
            case 11: {
                return "\u4ea4\u6e09\u7d50\u679c\u53cd\u6620\u4e2d";
            }
            case 12: {
                return "\u884c\u8ecd\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u4e2d";
            }
            case 13: {
                return "\u884c\u8ecd\u884c\u52d5\u63d0\u51fa\u8981\u6c42\u5f85\u53d7\u72b6\u614b";
            }
            case 14: {
                return "\u884c\u8ecd\u884c\u52d5\u5165\u529b\u4e2d";
            }
            case 15: {
                return "\u884c\u8ecd\u53cd\u6620\u8981\u6c42\u5f85\u53d7\u72b6\u614b";
            }
            case 16: {
                return "\u884c\u8ecd\u7d50\u679c\u53cd\u6620\u4e2d";
            }
            case 52: {
                return "\u884c\u8ecd\u7d42\u4e86\u53cd\u6620\u4e2d";
            }
            case 38: {
                return "\u5e55\u9593\u884c\u52d5\u5165\u529b\u4e2d";
            }
            case 39: {
                return "\u5e55\u9593\u884c\u52d5\u8981\u6c42\u5f85\u53d7\u72b6\u614b";
            }
            case 42: {
                return "\u30b2\u30fc\u30e0\u7d42\u4e86\u5165\u529b\u4e2d";
            }
            case 43: {
                return "\u30b2\u30fc\u30e0\u7d42\u4e86\u8981\u6c42\u5f85\u53d7\u72b6\u614b";
            }
            case 32: {
                return "\u30bb\u30fc\u30d6\u30c7\u30fc\u30bf\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 33: {
                return "\u30b2\u30fc\u30e0\u30bb\u30fc\u30d6\u5fdc\u7b54\u5f85\u53d7\u72b6\u614b";
            }
            case 34: {
                return "\u30b2\u30fc\u30e0\u30bb\u30fc\u30d6\u5165\u529b\u4e2d";
            }
            case 35: {
                return "\u30b2\u30fc\u30e0\u30bb\u30fc\u30d6\u5165\u529b\u4e2d";
            }
            case 30: {
                return "\u30b2\u30fc\u30e0\u7d42\u4e86";
            }
        }
        return "";
    }

    public static String getMessageName(int n) {
        switch (n) {
            case 1: {
                return "\u30b2\u30fc\u30e0\u53c2\u52a0\u8981\u6c42";
            }
            case 2: {
                return "\u30b2\u30fc\u30e0\u53c2\u52a0\u8981\u6c42(AI)";
            }
            case 3: {
                return "\u30b2\u30fc\u30e0\u53c2\u52a0\u5fdc\u7b54";
            }
            case 4: {
                return "\u30b2\u30fc\u30e0\u53c2\u52a0\u5fdc\u7b54(AI)";
            }
            case 5: {
                return "\u30b7\u30ca\u30ea\u30aa\u9078\u629e\u8981\u6c42";
            }
            case 6: {
                return "\u30b7\u30ca\u30ea\u30aa\u9078\u629e\u5fdc\u7b54";
            }
            case 7: {
                return "\u5927\u540d\u9078\u629e\u8981\u6c42";
            }
            case 8: {
                return "\u5927\u540d\u9078\u629e\u5fdc\u7b54";
            }
            case 9: {
                return "\u30ed\u30fc\u30c9\u30c7\u30fc\u30bf\u9078\u629e\u8981\u6c42";
            }
            case 10: {
                return "\u30ed\u30fc\u30c9\u30c7\u30fc\u30bf\u9078\u629e\u5fdc\u7b54";
            }
            case 11: {
                return "\u30b2\u30fc\u30e0\u958b\u59cb\u8981\u6c42";
            }
            case 12: {
                return "\u30b2\u30fc\u30e0\u958b\u59cb\u5fdc\u7b54";
            }
            case 13: {
                return "\u5185\u653f\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u8981\u6c42";
            }
            case 14: {
                return "\u5185\u653f\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u5fdc\u7b54";
            }
            case 15: {
                return "\u5185\u653f\u30a4\u30d9\u30f3\u30c8\u63d0\u51fa\u8981\u6c42";
            }
            case 16: {
                return "\u5185\u653f\u30a4\u30d9\u30f3\u30c8\u63d0\u51fa\u5fdc\u7b54";
            }
            case 17: {
                return "\u5185\u653f\u884c\u52d5\u63d0\u51fa\u8981\u6c42";
            }
            case 18: {
                return "\u5185\u653f\u884c\u52d5\u63d0\u51fa\u5fdc\u7b54";
            }
            case 19: {
                return "\u5185\u653f\u7d50\u679c\u8981\u6c42";
            }
            case 20: {
                return "\u5185\u653f\u7d50\u679c\u5fdc\u7b54";
            }
            case 21: {
                return "\u5916\u4ea4\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u8981\u6c42";
            }
            case 22: {
                return "\u5916\u4ea4\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u5fdc\u7b54";
            }
            case 23: {
                return "\u5916\u4ea4\u884c\u52d5\u63d0\u51fa\u8981\u6c42";
            }
            case 24: {
                return "\u5916\u4ea4\u884c\u52d5\u63d0\u51fa\u5fdc\u7b54";
            }
            case 25: {
                return "\u8cfc\u5165\u8981\u6c42\u63d0\u51fa\u8981\u6c42";
            }
            case 26: {
                return "\u8cfc\u5165\u8981\u6c42\u63d0\u51fa\u5fdc\u7b54";
            }
            case 27: {
                return "\u5916\u4ea4\u30c1\u30e3\u30f3\u30cd\u30eb\u30aa\u30fc\u30d7\u30f3\u8981\u6c42";
            }
            case 28: {
                return "\u5916\u4ea4\u30c1\u30e3\u30f3\u30cd\u30eb\u30aa\u30fc\u30d7\u30f3\u5fdc\u7b54";
            }
            case 29: {
                return "\u5916\u4ea4\u8981\u6c42\u63d0\u51fa\u8981\u6c42";
            }
            case 30: {
                return "\u5916\u4ea4\u8981\u6c42\u63d0\u51fa\u5fdc\u7b54";
            }
            case 31: {
                return "\u4ea4\u6e09\u59a5\u7d50/\u6c7a\u88c2\u8981\u6c42";
            }
            case 32: {
                return "\u4ea4\u6e09\u59a5\u7d50/\u6c7a\u88c2\u5fdc\u7b54";
            }
            case 33: {
                return "\u884c\u8ecd\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u8981\u6c42";
            }
            case 34: {
                return "\u884c\u8ecd\u30d5\u30a7\u30fc\u30ba\u958b\u59cb\u5fdc\u7b54";
            }
            case 35: {
                return "\u884c\u8ecd\u884c\u52d5\u63d0\u51fa\u8981\u6c42";
            }
            case 36: {
                return "\u884c\u8ecd\u884c\u52d5\u63d0\u51fa\u5fdc\u7b54";
            }
            case 37: {
                return "\u884c\u8ecd\u53cd\u6620\u8981\u6c42";
            }
            case 38: {
                return "\u884c\u8ecd\u53cd\u6620\u5fdc\u7b54";
            }
            case 39: {
                return "\u884c\u8ecd\u7d42\u4e86\u8981\u6c42";
            }
            case 40: {
                return "\u884c\u8ecd\u7d42\u4e86\u5fdc\u7b54";
            }
            case 41: {
                return "\u30b2\u30fc\u30e0\u7d42\u4e86\u8981\u6c42";
            }
            case 42: {
                return "\u30b2\u30fc\u30e0\u7d42\u4e86\u5fdc\u7b54";
            }
            case 43: {
                return "\u30bb\u30fc\u30d6\u30c7\u30fc\u30bf\u8981\u6c42";
            }
            case 44: {
                return "\u30bb\u30fc\u30d6\u30c7\u30fc\u30bf\u5fdc\u7b54";
            }
            case 45: {
                return "\u30b2\u30fc\u30e0\u30bb\u30fc\u30d6\u8981\u6c42";
            }
            case 46: {
                return "\u30b2\u30fc\u30e0\u30bb\u30fc\u30d6\u5fdc\u7b54";
            }
            case 47: {
                return "\u30b2\u30fc\u30e0\u30c7\u30fc\u30bf\u8981\u6c42";
            }
            case 48: {
                return "\u30b2\u30fc\u30e0\u30c7\u30fc\u30bf\u5fdc\u7b54";
            }
            case 49: {
                return "\u5e55\u9593\u884c\u52d5\u63d0\u51fa\u8981\u6c42";
            }
            case 50: {
                return "\u5e55\u9593\u884c\u52d5\u63d0\u51fa\u5fdc\u7b54";
            }
            case 51: {
                return "\u30b2\u30fc\u30e0\u7d42\u4e86\u8981\u6c42";
            }
            case 52: {
                return "\u30b2\u30fc\u30e0\u7d42\u4e86\u5fdc\u7b54";
            }
            case 80: {
                return "\u30b2\u30fc\u30e0\u958b\u59cb\u8981\u6c42(\u30b5\u30fc\u30d0\u30fc)";
            }
            case 98: {
                return "\u30e1\u30c3\u30bb\u30fc\u30b8\u8981\u6c42";
            }
            case 99: {
                return "\u30e1\u30c3\u30bb\u30fc\u30b8\u5fdc\u7b54";
            }
        }
        return "";
    }

    static {
        centerServerStatus = -1;
        serverStatus = -1;
        clientStatus = new HashMap<Integer, Integer>();
    }
}

