/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.common;

import game.base.graphic.BatchGraphicContext;
import game.base.graphic.DrawableTexture;
import game.base.graphic.TextureFactory;
import game.sengoku.common.GameTemp;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameAIData;
import game.sengoku.data.GameData;
import game.sengoku.data.GameDataV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.WorldDataV;
import game.sengoku.main.FlowControler;
import game.sengoku.server.GameClient;

public abstract class Scene {
    protected BatchGraphicContext bcontext;
    private DrawableTexture content = new TextureFactory().create(800, 600);

    public Scene() {
        this.bcontext = new BatchGraphicContext(this.content);
    }

    public void load() {
    }

    public void unLoad() {
    }

    public void update() {
    }

    public void draw(BatchGraphicContext batchGraphicContext) {
        if (this.needUpdate()) {
            this.bcontext.clear(0);
            this.updateContent();
            this.bcontext.commit();
        }
        batchGraphicContext.drawImage(this.content, 0, 0, 0);
    }

    protected abstract void updateContent();

    protected boolean needUpdate() {
        return true;
    }

    protected void forceReLoad() {
        this.getGameTemp().setForceReLoad(true);
    }

    protected GameTemp getGameTemp() {
        return FlowControler.getInstance().getPlayerClient().getGameTemp();
    }

    protected GameClient getPlayerClient() {
        return FlowControler.getInstance().getPlayerClient();
    }

    protected PlayerV getPlayer() {
        return this.getPlayerClient().getPlayer();
    }

    protected DaimyoV getDaimyo() {
        return this.getPlayer().getDaimyo();
    }

    protected int getDiscount() {
        return this.getDaimyo().getDiscount();
    }

    public GameData getGameData() {
        return this.getPlayerClient().getGameData();
    }

    public GameDataV getGameDataV() {
        return this.getPlayerClient().getGameDataV();
    }

    public GameAIData getGameAiData() {
        return this.getPlayerClient().getGameAiData();
    }

    public WorldDataV getWorld() {
        return this.getGameDataV().getWorld();
    }

    public abstract boolean withHolding();
}

