/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.common;

import game.sengoku.common.JusticeUtil;
import game.sengoku.data.Build;
import game.sengoku.data.CountryV;
import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.GiantV;
import game.sengoku.data.Justice;
import game.sengoku.data.KnightV;
import game.sengoku.data.Rank;
import game.sengoku.data.RoleV;
import game.sengoku.data.SpotV;
import game.sengoku.data.StoreV;
import game.sengoku.data.Technique;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.TreasureV;
import game.sengoku.data.UnitV;
import game.sengoku.data.UnmodifiableReration;
import game.sengoku.game.Notice;
import java.util.List;

public class GameNoticeCreator {
    private GameNoticeCreator() {
    }

    public static Notice disableShot(Technique technique) {
        String string = "\u706b\u85ac\u304c\u8db3\u308a\u306a\u3044\u305f\u3081\u3001" + technique.getName() + "\u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002";
        return new Notice(2, 12, string);
    }

    public static Notice stopBuild(CountryV countryV, Build build) {
        String string = countryV.getName() + "\u56fd\u306b\u3066\u8cc7\u91d1\u4e0d\u8db3\u306b\u3088\u308a" + build.getName() + "\u306e\u5efa\u8a2d\u304c\u4e2d\u65ad\u3057\u3066\u3044\u307e\u3059\u3002";
        return new Notice(3, 12, string);
    }

    public static Notice brokenBuild(CountryV countryV, Build build) {
        String string = countryV.getName() + "\u56fd\u306e" + build.getName() + "\u304c\u7834\u58ca\u3055\u308c\u307e\u3057\u305f\u3002";
        return new Notice(2, 12, string);
    }

    public static Notice brokenShrine(CountryV countryV) {
        String string = countryV.getName() + "\u56fd\u306e\u30ad\u30ea\u30b7\u30bf\u30f3\u305f\u3061\u304c\u56fd\u5185\u306e\u795e\u793e\u4ecf\u95a3\u3092\u7834\u58ca\u3057\u3066\u3044\u307e\u3059\u3002";
        return new Notice(2, 12, string);
    }

    public static Notice newGengo(String string) {
        String string2 = "\u6539\u5143\u306e\u52c5\u304c\u767a\u305b\u3089\u308c\u307e\u3057\u305f\u3002\u5143\u53f7\u304c" + string + "\u306b\u5909\u308f\u308a\u307e\u3059\u3002";
        return new Notice(3, 32, string2);
    }

    public static Notice completeBuild(CountryV countryV, Build build) {
        String string = countryV.getName() + "\u56fd\u3067" + build.getName() + "\u306e\u5efa\u8a2d\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, string);
    }

    public static Notice stopKnight(KnightV knightV) {
        String string = "\u7d66\u6599\u304c\u652f\u6255\u308f\u308c\u306a\u304b\u3063\u305f\u305f\u3081\u3001" + knightV.getFullName() + "\u306f\u5f53\u5bb6\u3092\u53bb\u308a\u307e\u3057\u305f\u3002";
        return new Notice(3, 12, string);
    }

    public static Notice fairPost(KnightV knightV) {
        String string = "\u7d66\u6599\u304c\u652f\u6255\u308f\u308c\u306a\u304b\u3063\u305f\u305f\u3081\u3001" + knightV.getFullName() + "\u306e\u696d\u52d9\u304c\u6ede\u3063\u3066\u3044\u308b\u3088\u3046\u3067\u3059\u3002";
        return new Notice(3, 12, string);
    }

    public static Notice stopGiant(GiantV giantV) {
        String string = "\u7d66\u6599\u304c\u652f\u6255\u308f\u308c\u306a\u304b\u3063\u305f\u305f\u3081\u3001" + giantV.getFullName() + "\u306f\u5f53\u5bb6\u3092\u53bb\u308a\u307e\u3057\u305f\u3002";
        return new Notice(3, 12, string);
    }

    public static Notice stopGun() {
        String string = "\u9244\u4e0d\u8db3\u306e\u305f\u3081\u3001\u9244\u7832\u306e\u7523\u51fa\u304c\u4f4e\u4e0b\u3057\u3066\u3044\u307e\u3059\u3002";
        return new Notice(1, string);
    }

    public static Notice stopGunpowder() {
        String string = "\u785d\u77f3\u4e0d\u8db3\u306e\u305f\u3081\u3001\u706b\u85ac\u306e\u7523\u51fa\u304c\u4f4e\u4e0b\u3057\u3066\u3044\u307e\u3059\u3002";
        return new Notice(1, string);
    }

    public static Notice growUpDomestic(KnightV knightV) {
        String string = knightV.getFullName() + "\u306e\u5185\u653f\u80fd\u529b\u304c" + (knightV.getKnight().getDomestic() + knightV.getDomesticPlus()) + "\u306b\u306a\u308a\u307e\u3057\u305f\u3002";
        return new Notice(2, 11, string);
    }

    public static Notice growUpTactics(KnightV knightV) {
        String string = knightV.getFullName() + "\u306e\u6226\u8853\u80fd\u529b\u304c" + (knightV.getKnight().getTactics() + knightV.getTacticsPlus()) + "\u306b\u306a\u308a\u307e\u3057\u305f\u3002";
        return new Notice(2, 11, string);
    }

    public static Notice growUpCulture(KnightV knightV) {
        String string = knightV.getFullName() + "\u306e\u6559\u990a\u304c" + (knightV.getKnight().getCulture() + knightV.getCulturePlus()) + "\u306b\u306a\u308a\u307e\u3057\u305f\u3002";
        return new Notice(2, 11, string);
    }

    public static Notice canResearchTechnology(TechnologyV technologyV) {
        String string = technologyV.getName() + "\u306e\u6280\u8853\u7814\u7a76\u304c\u53ef\u80fd\u306b\u306a\u308a\u307e\u3057\u305f\u3002";
        return new Notice(3, string);
    }

    public static Notice getTechnology(TechnologyV technologyV) {
        String string = technologyV.getName() + "\u306e\u6280\u8853\u3092\u7fd2\u5f97\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, 11, string);
    }

    public static Notice getTechnology(StoreV storeV, TechnologyV technologyV) {
        String string = storeV.getName() + "\u5546\u4eba\u304b\u3089" + technologyV.getName() + "\u306e\u6280\u8853\u3092\u53d7\u3051\u53d6\u308a\u307e\u3057\u305f\u3002";
        return new Notice(3, 11, string);
    }

    public static Notice getTechnology(GiantV giantV, TechnologyV technologyV) {
        String string = giantV.getFullName() + "\u306b\u3088\u308a" + technologyV.getName() + "\u306e\u6280\u8853\u304c\u8a95\u751f\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, 11, string);
    }

    public static Notice getCulture(GiantV giantV, CultureV cultureV) {
        String string = giantV.getFullName() + "\u306b\u3088\u308a" + cultureV.getName() + "\u306e\u6587\u5316\u304c\u8a95\u751f\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, 11, string);
    }

    public static Notice getTreasure(GiantV giantV, TreasureV treasureV) {
        String string = giantV.getFullName() + "\u306b\u3088\u308a" + treasureV.getName() + "\u306e\u5bb6\u5b9d\u304c\u8a95\u751f\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, 11, string);
    }

    public static Notice updateLevel(CountryV countryV, int n) {
        String string = countryV.getName() + "\u56fd\u3067\u5175\u58eb\u30ec\u30d9\u30eb\u304c" + n + "\u306b\u4e0a\u304c\u308a\u307e\u3057\u305f\u3002";
        return new Notice(1, string);
    }

    public static Notice disaster(CountryV countryV, int n, int n2) {
        String string = (new String[]{"\u5730\u9707", "\u5d50", "\u75ab\u75c5"})[n % 3];
        int n3 = (new int[]{24, 23, 25})[n % 3];
        String string2 = countryV.getName() + "\u56fd\u3067" + string + "\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
        String string3 = "\u91d1\u92ad" + n2 + "\u306e\u88ab\u5bb3\u304c\u767a\u751f\u3057\u3066\u3044\u307e\u3059\u3002";
        return new Notice(3, countryV.getCapitalSpot().getId(), n3, string2, string3);
    }

    public static Notice ikkou(CountryV countryV, int n) {
        String string = countryV.getName() + "\u56fd\u3067\u4e00\u5411\u5b97\u304c\u4e00\u63c6\u3092\u8d77\u3053\u3057\u3066\u3044\u307e\u3059\u3002";
        String string2 = "\u91d1\u92ad" + n + "\u306e\u88ab\u5bb3\u304c\u767a\u751f\u3057\u3066\u3044\u307e\u3059\u3002";
        return new Notice(3, countryV.getCapitalSpot().getId(), 12, string, string2);
    }

    public static Notice ruin(CountryV countryV, String string) {
        String string2 = string + "\u306e\u305f\u3081\u3001" + countryV.getName() + "\u56fd\u3067\u8352\u5ec3\u304c\u767a\u751f\u3057\u3066\u3044\u307e\u3059\u3002";
        return new Notice(3, 12, string2);
    }

    public static Notice flowPopulation(CountryV countryV, CountryV countryV2) {
        String string = countryV2.getName() + "\u56fd\u306e\u5584\u653f\u306b\u61a7\u308c\u3066\u3001\u5f53\u5bb6\u306e" + countryV.getName() + "\u56fd\u304b\u3089\u8fb2\u6c11\u304c\u6d41\u51fa\u3057\u3066\u3044\u307e\u3059\u3002";
        return new Notice(3, 12, string);
    }

    public static Notice disappearKnight(KnightV knightV) {
        String string = knightV.getFullName() + "\u304c\u6b7b\u4ea1\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, 13, string);
    }

    public static Notice absorpKnight(KnightV knightV) {
        String string = knightV.getFullName() + "\u3092\u53d6\u8fbc\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice releaseKnight(KnightV knightV) {
        String string = knightV.getFullName() + "\u3092\u89e3\u96c7\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice retire(KnightV knightV, KnightV knightV2) {
        String string = knightV.getFullName() + "\u306f\u5f15\u9000\u3057\u3066\u3001" + knightV2.getFullName() + "\u306b\u5bb6\u7763\u3092\u8b72\u308a\u307e\u3057\u305f\u3002";
        return new Notice(3, 14, string);
    }

    public static Notice assignKnight(CountryV countryV, KnightV knightV) {
        String string = countryV.getName() + "\u56fd\u3067" + knightV.getFullName() + "\u3092\u96c7\u7528\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice newFaceKnight(KnightV knightV) {
        String string = knightV.getFullName() + "\u304c\u914d\u4e0b\u306b\u52a0\u308f\u308a\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice assignGiant(CountryV countryV, GiantV giantV) {
        String string = countryV.getName() + "\u56fd\u3067" + giantV.getFullName() + "\u3092\u96c7\u7528\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice assignGiantNg(DaimyoV daimyoV, GiantV giantV) {
        String string = "\u5f53\u5bb6\u306e\u6587\u5316\u5ea6\u304c\u4f4e\u3044\u305f\u3081\u3001 " + giantV.getFullName() + "\u306f\u4ed5\u5b98\u3092\u62d2\u5426\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice alliance(DaimyoV daimyoV, DaimyoV daimyoV2) {
        String string = daimyoV.getName() + "\u3068" + daimyoV2.getName() + "\u304c\u540c\u76df\u3092\u7d50\u3073\u307e\u3057\u305f\u3002";
        return new Notice(1, string);
    }

    public static Notice allianceTo(DaimyoV daimyoV) {
        String string = "\u5f53\u5bb6\u306f" + daimyoV.getName() + "\u3068\u540c\u76df\u3092\u7d50\u3073\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice war(DaimyoV daimyoV, DaimyoV daimyoV2) {
        String string = daimyoV.getName() + "\u3068" + daimyoV2.getName() + "\u304c\u4ea4\u6226\u72b6\u614b\u306b\u306a\u308a\u307e\u3057\u305f\u3002";
        return new Notice(1, string);
    }

    public static Notice warTo(DaimyoV daimyoV) {
        String string = "\u5f53\u5bb6\u306f" + daimyoV.getName() + "\u3068\u4ea4\u6226\u72b6\u614b\u306b\u306a\u308a\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice detente(DaimyoV daimyoV, DaimyoV daimyoV2) {
        String string = daimyoV.getName() + "\u3068" + daimyoV2.getName() + "\u304c\u548c\u89e3\u3057\u307e\u3057\u305f\u3002";
        return new Notice(1, string);
    }

    public static Notice detenteTo(DaimyoV daimyoV) {
        String string = "\u5f53\u5bb6\u306f" + daimyoV.getName() + "\u3068\u548c\u89e3\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice enemy(DaimyoV daimyoV, DaimyoV daimyoV2) {
        String string = daimyoV.getName() + "\u3068" + daimyoV2.getName() + "\u304c\u6575\u5bfe\u72b6\u614b\u306b\u306a\u308a\u307e\u3057\u305f\u3002";
        return new Notice(1, string);
    }

    public static Notice enemyTo(DaimyoV daimyoV) {
        String string = "\u5f53\u5bb6\u306f" + daimyoV.getName() + "\u3068\u6575\u5bfe\u72b6\u614b\u306b\u306a\u308a\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice nonAggression(DaimyoV daimyoV, DaimyoV daimyoV2) {
        String string = daimyoV.getName() + "\u3068" + daimyoV2.getName() + "\u304c\u505c\u6226\u3092\u7d50\u3073\u307e\u3057\u305f\u3002";
        return new Notice(1, string);
    }

    public static Notice nonAggressionTo(DaimyoV daimyoV) {
        String string = "\u5f53\u5bb6\u306f" + daimyoV.getName() + "\u3068\u505c\u6226\u3092\u7d50\u3073\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice surrender(DaimyoV daimyoV, DaimyoV daimyoV2) {
        String string = daimyoV2.getName() + "\u306f" + daimyoV.getName() + "\u306b\u5f93\u5c5e\u3057\u307e\u3057\u305f\u3002";
        return new Notice(1, string);
    }

    public static Notice breakWith(DaimyoV daimyoV, DaimyoV daimyoV2) {
        String string = daimyoV.getName() + "\u306f" + daimyoV2.getName() + "\u3068\u306e\u540c\u76df\u3092\u7834\u68c4\u3057\u307e\u3057\u305f\u3002";
        return new Notice(1, string);
    }

    public static Notice breakWith1(DaimyoV daimyoV) {
        String string = "\u5f53\u5bb6\u306f" + daimyoV.getName() + "\u3068\u306e\u540c\u76df\u3092\u7834\u68c4\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice breakWith2(DaimyoV daimyoV) {
        String string = daimyoV.getName() + "\u306f" + "\u5f53\u5bb6\u3068\u306e\u540c\u76df\u3092\u7834\u68c4\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice toubatsu(DaimyoV daimyoV) {
        String string = daimyoV.getName() + "\u306b\u8a0e\u4f10\u4ee4\u304c\u767a\u4ee4\u3055\u308c\u307e\u3057\u305f\u3002";
        return new Notice(3, 12, string);
    }

    public static Notice toubatsuRemove(DaimyoV daimyoV) {
        String string = daimyoV.getName() + "\u306e\u8a0e\u4f10\u4ee4\u304c\u89e3\u9664\u3055\u308c\u307e\u3057\u305f\u3002";
        return new Notice(3, string);
    }

    public static Notice borderConflict(int n, DaimyoV daimyoV) {
        String string = daimyoV.getName() + "\u3068\u306e\u56fd\u5883\u3067\u8fb2\u6c11\u304c\u7d1b\u4e89\u3092\u8d77\u3053\u3057\u3066\u3044\u308b\u3088\u3046\u3067\u3059\u3002";
        return new Notice(3, n, 12, string);
    }

    public static Notice borderConflictJustice(DaimyoV daimyoV) {
        String string = daimyoV.getName() + "\u3078\u4fb5\u653b\u3059\u308b\u5927\u7fa9\u540d\u5206\u3092\u624b\u306b\u5165\u308c\u307e\u3057\u305f\u3002";
        return new Notice(3, string);
    }

    public static Notice christTreat(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "\u5968\u52b1";
                break;
            }
            case 0: {
                string = "\u901a\u5e38";
                break;
            }
            case -1: {
                string = "\u5f3e\u5727";
                break;
            }
        }
        String string2 = "\u5f53\u5bb6\u306e\u57fa\u7763\u6559\u306b\u5bfe\u3059\u308b\u614b\u5ea6\u304c" + string + "\u306b\u306a\u308a\u307e\u3057\u305f\u3002";
        return new Notice(3, string2);
    }

    public static Notice rankUp(Rank rank) {
        String string = "\u5f53\u5bb6\u306e\u6587\u5316\u5ea6\u304c\u9ad8\u304f\u306a\u3063\u305f\u305f\u3081\u3001" + rank.getName() + " " + rank.getRoleName() + "\u306b\u6607\u9032\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, 11, string);
    }

    public static Notice role(DaimyoV daimyoV, RoleV roleV) {
        String string = daimyoV.getName() + "\u306f\u3001" + roleV.getName() + "\u306b\u4efb\u547d\u3055\u308c\u307e\u3057\u305f\u3002";
        return new Notice(3, string);
    }

    public static Notice negotiationAgreement() {
        String string = "\u4ea4\u6e09\u304c\u6210\u7acb\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, 11, string);
    }

    public static Notice negotiationBreak() {
        String string = "\u4ea4\u6e09\u306f\u6c7a\u88c2\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, 12, string);
    }

    public static Notice lostMoney() {
        String string = "\u8cc7\u91d1\u4e0d\u8db3\u306e\u305f\u3081\u4e00\u90e8\u306e\u30b3\u30de\u30f3\u30c9\u304c\u5b9f\u884c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice negotiationRefused(DaimyoV daimyoV) {
        String string = daimyoV.getName() + "\u306f\u4ea4\u6e09\u306b\u5fdc\u3058\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
        return new Notice(2, 12, string);
    }

    public static Notice updateSalary() {
        String string = "\u6b66\u5c06\u3001\u6587\u5316\u4eba\u306e\u7d66\u6599\u304c\u6539\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002";
        return new Notice(1, string);
    }

    public static Notice countryOwnerChange(DaimyoV daimyoV, DaimyoV daimyoV2, CountryV countryV) {
        String string = daimyoV.getName() + "\u304c" + countryV.getName() + "\u56fd\u3092\u624b\u306b\u5165\u308c\u307e\u3057\u305f\u3002";
        return new Notice(3, countryV.getCapitalSpot().getId(), 10, string);
    }

    public static Notice daimyoFall(DaimyoV daimyoV, DaimyoV daimyoV2) {
        String string = daimyoV2.getName() + "\u304c" + daimyoV.getName() + "\u306b\u6ec5\u307c\u3055\u308c\u307e\u3057\u305f\u3002";
        return new Notice(3, 17, string);
    }

    public static Notice bakubuClose(DaimyoV daimyoV, DaimyoV daimyoV2) {
        String string = daimyoV2.getKnight().getKnight().getFamily() + "\u5e55\u5e9c\u306f\u6ec5\u4ea1\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, 17, string);
    }

    public static Notice collapseArmy(UnitV unitV) {
        String string = "\u58eb\u6c17\u304c\u4f4e\u4e0b\u3057\u305f\u305f\u3081" + unitV.getName() + "\u968a\u306f\u5d29\u58ca\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, unitV.getSpotId(), 12, string);
    }

    public static Notice releaseUnitOn(DaimyoV daimyoV) {
        String string = daimyoV.getName() + "\u306e\u9818\u5185\u306b\u3044\u308b\u5f53\u5bb6\u306e\u30e6\u30cb\u30c3\u30c8\u3092\u3059\u3079\u3066\u89e3\u6563\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice plunder(UnitV unitV, int n) {
        String string = unitV.getName() + "\u968a\u306e\u7565\u596a\u306b\u3088\u308a\u3001\u91d1\u92ad" + n + "\u306e\u88ab\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, unitV.getSpotId(), 12, string);
    }

    public static Notice plunderGet(UnitV unitV, int n) {
        String string = unitV.getName() + "\u968a\u306e\u7565\u596a\u306b\u3088\u308a\u3001\u91d1\u92ad" + n + "\u3092\u7372\u5f97\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, unitV.getSpotId(), 11, string);
    }

    public static Notice lose(UnitV unitV) {
        String string = unitV.getName() + "\u968a\u306f\u5d29\u58ca\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, unitV.getSpotId(), 12, string);
    }

    public static Notice breakPirate(int n, int n2) {
        String string = "\u6d77\u8cca\u3092\u8a0e\u4f10\u3057\u307e\u3057\u305f\u3002";
        String string2 = "\u91d1\u92ad" + n + "\u3092\u624b\u306b\u5165\u308c\u307e\u3057\u305f\u3002";
        String string3 = "\u540d\u58f0\u304c" + n2 + "\u4e0a\u304c\u308a\u307e\u3057\u305f\u3002";
        return new Notice(2, 11, string, string2, string3);
    }

    public static Notice breakIkkou() {
        String string = "\u4e00\u5411\u4e00\u63c6\u3092\u93ae\u5727\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice appearField(CountryV countryV, SpotV spotV, Build build) {
        String string = countryV.getName() + "\u56fd\u306e" + spotV.getName() + "\u306b\u53e4\u6226\u5834" + build.getName() + "\u304c\u51fa\u73fe\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, spotV.getId(), 10, string);
    }

    public static Notice baptism(KnightV knightV, String string) {
        String string2 = knightV.getFullName() + "\u306f\u6d17\u793c\u3092\u53d7\u3051\u3066" + string + "\u306b\u6539\u540d\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, string2);
    }

    public static Notice appearPirate(SpotV spotV) {
        String string = spotV.getName() + "\u306b\u6d77\u8cca\u304c\u51fa\u73fe\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, spotV.getId(), 12, string);
    }

    public static Notice appearIkkou(CountryV countryV) {
        String string = countryV.getName() + "\u56fd\u3067\u4e00\u5411\u4e00\u63c6\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
        return new Notice(3, countryV.getCapitalSpot().getId(), 12, string);
    }

    public static Notice incomeYear(int n) {
        String string = "\u9818\u6c11\u304b\u3089\u5e74\u8ca2\u3068\u3057\u3066\u91d1\u92ad" + n + "\u304c\u53ce\u3081\u3089\u308c\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice incomeMission(int n) {
        String string = "\u5168\u56fd\u306e\u4fe1\u8005\u304b\u3089\u304a\u5e03\u65bd\u3068\u3057\u3066\u91d1\u92ad" + n + "\u304c\u53ce\u3081\u3089\u308c\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice escapeKnight(KnightV knightV) {
        String string = knightV.getFullName() + "\u306f\u9003\u8d70\u3057\u307e\u3057\u305f\u3002";
        return new Notice(2, string);
    }

    public static Notice soubuji(DaimyoV daimyoV) {
        String string = daimyoV.getName() + "\u306b\u3088\u3063\u3066\u60e3\u7121\u4e8b\u4ee4\u304c\u767a\u305b\u3089\u308c\u307e\u3057\u305f\u3002";
        return new Notice(3, 10, string);
    }

    public static Notice declarationOfWar(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2, CountryV countryV) {
        List list = gameDataV.getJusticeList(daimyoV.getId(), daimyoV2.getId());
        if (list.isEmpty()) {
            UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
            String string = "";
            if (unmodifiableReration.getHate() > 0) {
                string = daimyoV2.getName() + "\u306b\u5bfe\u3059\u308b\u7a4d\u5e74\u306e\u6068\u307f\u3001\u4eca\u3053\u305d\u6674\u3089\u3059\u3002";
                return new Notice(2, 0, 12, daimyoV.getKnight(), string);
            }
            if (daimyoV2.getArmyPower() * 3 <= daimyoV.getArmyPower()) {
                string = daimyoV2.getName() + "\u306a\u3069\u53d6\u308b\u306b\u8db3\u3089\u3093\u5b58\u5728\u3088\u3002\u93a7\u8896\u4e00\u89e6\u8e74\u6563\u3089\u3057\u3066\u304f\u308c\u3088\u3046\u3002";
                return new Notice(2, 0, 12, daimyoV.getKnight(), string);
            }
        } else {
            Justice justice = (Justice)list.get(0);
            String string = JusticeUtil.getJusticeDeclaration(gameDataV, justice, daimyoV, daimyoV2);
            return new Notice(2, 0, 12, daimyoV.getKnight(), string);
        }
        return null;
    }

    public static Notice declarationOfEnemy(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        for (DaimyoV daimyoV3 : daimyoV.getAlliances()) {
            if (!gameDataV.isEnemy(daimyoV3.getId(), daimyoV2.getId())) continue;
            String string = "\u540c\u76df\u56fd" + daimyoV3.getName() + "\u306e\u6575\u306f\u3001\u5f53\u5bb6\u306e\u6575\u3082\u540c\u7136\u3002";
            return new Notice(2, 0, 12, daimyoV.getKnight(), string);
        }
        return null;
    }
}

