/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.common;

import game.base.sound.Music;
import game.base.sound.MusicPlayer;
import game.base.sound.MusicPlayerFactory;
import game.base.sound.Sound;
import game.base.sound.SoundPlayer;
import game.base.sound.SoundPlayerFactory;
import game.sengoku.data.BgMusic;
import game.sengoku.data.SoundEffect;
import game.sengoku.data.SystemData;
import game.sengoku.main.FlowControler;
import game.sengoku.main.KessenMain;
import game.sengoku.server.GameClient;

public class AudioUtil {
    public static final int MUSIC_OPENING = 1;
    public static final int MUSIC_DOMESTIC = 2;
    public static final int MUSIC_DIPLOMACY = 3;
    public static final int MUSIC_NEGOTIATE = 4;
    public static final int MUSIC_TACTICS = 5;
    public static final int MUSIC_TACTICS_WAR = 6;
    public static final int MUSIC_FALL = 7;
    public static final int MUSIC_ENDING = 8;
    public static final int MUSIC_WIN = 9;
    public static final int SE_NEW_GAME = 1;
    public static final int SE_APPEAR_WINDOW = 2;
    public static final int SE_CLOSE_WINDOW = 3;
    public static final int SE_DECISION = 4;
    public static final int SE_SELECT = 5;
    public static final int SE_CANCEL = 6;
    public static final int SE_ADD_ITEM = 7;
    public static final int SE_REMOVE_ITEM = 8;
    public static final int SE_ALERT = 9;
    public static final int SE_NEWS = 10;
    public static final int SE_GOOD_NEWS = 11;
    public static final int SE_BAD_NEWS = 12;
    public static final int SE_DEAD = 13;
    public static final int SE_RETIRE = 14;
    public static final int SE_GROWN = 15;
    public static final int SE_GOOUT = 16;
    public static final int SE_FALL = 17;
    public static final int SE_WAR = 18;
    public static final int SE_LANCE = 19;
    public static final int SE_HORSE_DASH = 20;
    public static final int SE_SHOT = 21;
    public static final int SE_GUNSHOT = 22;
    public static final int SE_STORM = 23;
    public static final int SE_EARTHQUAKE = 24;
    public static final int SE_EPIDEMIC = 25;
    public static final int SE_SPRING = 26;
    public static final int SE_RAINSEASON = 27;
    public static final int SE_SUMMER = 28;
    public static final int SE_AUTUMN = 29;
    public static final int SE_WINTER = 30;
    public static final int SE_SAVE = 31;
    public static final int SE_NEW_GENGO = 32;
    private static SoundPlayer soundPlayer = null;
    private static MusicPlayer musicPlayer = null;
    private static int musicId = 0;

    public static SoundPlayer getSoundPlayer() {
        if (soundPlayer == null) {
            soundPlayer = new SoundPlayerFactory().create();
        }
        return soundPlayer;
    }

    public static MusicPlayer getMusicPlayer() {
        if (musicPlayer == null) {
            musicPlayer = new MusicPlayerFactory().create();
        }
        return musicPlayer;
    }

    public static void sePlay(int n) {
        GameClient gameClient = FlowControler.getInstance().getPlayerClient();
        if (gameClient != null) {
            double d = gameClient.getGameTemp().getSeVolume();
            AudioUtil.sePlay(n, d);
        }
    }

    public static void sePlay(int n, double d) {
        SystemData systemData = KessenMain.getInstance().getSystemData();
        if (systemData.isSeMute()) {
            return;
        }
        SoundEffect soundEffect = (SoundEffect)systemData.getSounds().get(n);
        if (soundEffect == null) {
            return;
        }
        Sound sound = (Sound)KessenMain.getInstance().getSoundPool().getResource(soundEffect.getName());
        if (sound == null) {
            return;
        }
        AudioUtil.getSoundPlayer().play(sound, d);
    }

    public static void musicPlay(int n) {
        AudioUtil.musicPlay(n, false);
    }

    public static void musicPlay(int n, boolean bl) {
        GameClient gameClient = FlowControler.getInstance().getPlayerClient();
        if (gameClient != null) {
            double d = gameClient.getGameTemp().getMusicVolume();
            AudioUtil.musicPlay(n, d, bl);
        }
    }

    public static void volumeChange(double d) {
        AudioUtil.getMusicPlayer().changeVolume(d);
    }

    public static void setMusicMute(boolean bl) {
        SystemData systemData = KessenMain.getInstance().getSystemData();
        if (systemData.isMusicMute() != bl) {
            systemData.setMusicMute(bl);
            if (bl) {
                AudioUtil.getMusicPlayer().stop();
            } else {
                AudioUtil.musicPlay(musicId, true);
            }
        }
    }

    public static void musicPlay(int n, double d, boolean bl) {
        SystemData systemData;
        BgMusic bgMusic;
        if (n == musicId && !bl) {
            return;
        }
        if (n == 0) {
            AudioUtil.getMusicPlayer().stop();
            musicId = n;
        }
        if ((bgMusic = (BgMusic)(systemData = KessenMain.getInstance().getSystemData()).getBgms().get(n)) == null) {
            return;
        }
        Music music = (Music)KessenMain.getInstance().getMusicPool().getResource(bgMusic.getName());
        if (music == null) {
            return;
        }
        musicId = n;
        if (systemData.isMusicMute()) {
            return;
        }
        AudioUtil.getMusicPlayer().play(music, d);
    }
}

