/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.common;

import game.base.common.Pair;
import game.base.common.Tuple;
import game.sengoku.common.GameCommandCreator;
import game.sengoku.common.GameTemp;
import game.sengoku.common.GameUtil;
import game.sengoku.data.AIType;
import game.sengoku.data.Build;
import game.sengoku.data.CommandV;
import game.sengoku.data.CountryV;
import game.sengoku.data.Culture;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameData;
import game.sengoku.data.GameDataV;
import game.sengoku.data.GiantV;
import game.sengoku.data.KnightV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.SpotV;
import game.sengoku.data.Technology;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.TreasureV;
import game.sengoku.data.UnitV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.domestic.DomesticResearchUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AIDomesticUtil {
    public static final int DOMESTIC_TERGET_FOOD_RATE = 1;
    public static final int DOMESTIC_TERGET_COMMERCE_RATE = 2;
    public static final int DOMESTIC_TERGET_POPULATION_RATE = 3;
    public static final int DOMESTIC_TERGET_NEXT_RANK = 4;
    public static final int DOMESTIC_TERGET_NEXT_LEVEL = 5;
    public static final int DOMESTIC_TERGET_NEAR_LEVEL = 6;
    public static final int DOMESTIC_TERGET_NEAR_TAMICHU = 7;
    public static final int DOMESTIC_TERGET_MAX_CHRIST = 8;
    public static final int DOMESTIC_TERGET_CHRIST = 9;
    public static final int DOMESTIC_TERGET_TAMICHU = 10;
    public static final int DOMESTIC_TERGET_DEFENSE = 11;
    public static final int DOMESTIC_TERGET_MONEY_PLUS = 12;
    public static final int DOMESTIC_TERGET_GUN_PLUS = 13;
    public static final int DOMESTIC_TERGET_HORSE_PLUS = 14;
    public static final int DOMESTIC_TERGET_IRON_PLUS = 15;
    public static final int DOMESTIC_TERGET_GUNPOWDER_PLUS = 16;
    public static final int DOMESTIC_TERGET_SALTPETER_PLUS = 17;
    public static final int DOMESTIC_STORE = 18;
    public static final int DOMESTIC_TERGET_OVER_POPULATION_RATE = 22;
    public static final int DOMESTIC_TERGET_OVER_COMMERCE_RATE = 25;

    public static void createDomesticAction(GameDataV gameDataV, DaimyoV daimyoV, PlayerV playerV) {
        AIType aIType = daimyoV.getAiType();
        int n = daimyoV.getAiType().getSavingRate();
        int n2 = daimyoV.getMoney() * (100 - n) / 100;
        n2 = AIDomesticUtil.soubuji(gameDataV, daimyoV, playerV, n2);
        n2 = AIDomesticUtil.researchTechnology(gameDataV, daimyoV, aIType, playerV, n2);
        n2 = AIDomesticUtil.build(gameDataV, daimyoV, aIType, playerV, n2);
        if (daimyoV.isCanHongan()) {
            n2 = AIDomesticUtil.propagate(gameDataV, daimyoV, aIType, playerV, n2);
        }
        n2 = AIDomesticUtil.employGiant(gameDataV, daimyoV, aIType, playerV, n2);
        n2 = AIDomesticUtil.employKnight(gameDataV, daimyoV, aIType, playerV, n2);
        n2 = AIDomesticUtil.releaseKnight(gameDataV, daimyoV, aIType, playerV, n2);
        n2 = AIDomesticUtil.assignTreasure(gameDataV, daimyoV, aIType, playerV, n2);
    }

    public static void createDomesticAction(GameDataV gameDataV, DaimyoV daimyoV, PlayerV playerV, GameTemp gameTemp, int n) {
        AIType aIType = daimyoV.getAiType();
        int n2 = daimyoV.getAiType().getSavingRate();
        int n3 = n * (100 - n2) / 100;
        if (gameTemp.isChargeTechnology()) {
            n3 = AIDomesticUtil.researchTechnology(gameDataV, daimyoV, aIType, playerV, n3);
        }
        if (gameTemp.isChargeBuild()) {
            n3 = AIDomesticUtil.build(gameDataV, daimyoV, aIType, playerV, n3);
        }
        if (gameTemp.isChargeEmployKnight()) {
            n3 = AIDomesticUtil.employKnight(gameDataV, daimyoV, aIType, playerV, n3);
        }
        if (gameTemp.isChargeEmployGiant()) {
            n3 = AIDomesticUtil.employGiant(gameDataV, daimyoV, aIType, playerV, n3);
        }
        if (gameTemp.isChargeRelease()) {
            n3 = AIDomesticUtil.releaseKnight(gameDataV, daimyoV, aIType, playerV, n3);
        }
        if (gameTemp.isChargeTreasure()) {
            n3 = AIDomesticUtil.assignTreasure(gameDataV, daimyoV, aIType, playerV, n3);
        }
    }

    private static List<Tuple<Integer, Integer, Integer>> calcPriority(GameDataV gameDataV, DaimyoV daimyoV2, AIType aIType, CountryV countryV3) {
        int n;
        int n2;
        int n3;
        ArrayList<Tuple<Integer, Integer, Integer>> arrayList = new ArrayList<Tuple<Integer, Integer, Integer>>();
        int n4 = 0;
        int n5 = 0;
        if (countryV3.getFoodRate() < aIType.getFoodRateTarget()) {
            n4 = countryV3.getMaxFood() * (countryV3.getFoodRate() + 10) / 100;
            n5 = countryV3.getFoodPlus() == 0 ? 9999 : (n4 - countryV3.getFood()) / countryV3.getFoodPlus();
            n5 = n5 * aIType.getDemandFood() / 100;
            arrayList.add(new Tuple<Integer, Integer, Integer>(1, n5, n4));
        }
        if (countryV3.getCommerceRate() < aIType.getCommerceRateTarget()) {
            n4 = countryV3.getMaxCommerce() * (countryV3.getCommerceRate() + 10) / 100;
            n5 = countryV3.getCommercePlus() == 0 ? 9999 : (n4 - countryV3.getCommerce()) / countryV3.getCommercePlus();
            n5 = n5 * aIType.getDemandCommerce() / 100;
            arrayList.add(new Tuple<Integer, Integer, Integer>(2, n5, n4));
        }
        if (countryV3.getPopulationRate() < aIType.getPopulationRateTarget()) {
            n4 = countryV3.getMaxPopulation() * (countryV3.getPopulationRate() + 10) / 100;
            n5 = countryV3.getPopulationPlus() == 0 ? 9999 : (n4 - countryV3.getPopulation()) / countryV3.getPopulationPlus();
            n5 = n5 * aIType.getDemandPopulation() / 100;
            arrayList.add(new Tuple<Integer, Integer, Integer>(3, n5, n4));
        }
        if (countryV3.getPopulationRate() >= 80) {
            n4 = countryV3.getPopulation() * 100 / 70;
            n5 = countryV3.getFoodPlus() == 0 ? 9999 : (n4 - countryV3.getFood()) / countryV3.getFoodPlus();
            n5 = n5 * aIType.getDemandPopulation() / 100;
            arrayList.add(new Tuple<Integer, Integer, Integer>(22, n5, n4));
        }
        if (countryV3.getCommerceRate() >= 80) {
            n4 = countryV3.getCommerce() * 100 / 70;
            n5 = countryV3.getPopulationPlus() == 0 ? 9999 : (n4 - countryV3.getPopulation()) / countryV3.getPopulationPlus();
            n5 = n5 * aIType.getDemandCommerce() / 100;
            arrayList.add(new Tuple<Integer, Integer, Integer>(25, n5, n4));
        }
        int n6 = GameCommandUtil.getForNextRank(gameDataV, daimyoV2);
        n4 = n6 + countryV3.getCulture();
        n4 = n4 * aIType.getDemandCulture() / 100;
        n5 = countryV3.getCulturePlus() == 0 ? 9999 : (n4 - countryV3.getCulture()) / countryV3.getCulturePlus();
        arrayList.add(new Tuple<Integer, Integer, Integer>(4, n5, n4));
        n4 = n3 = GameCommandUtil.getForNextLevel(gameDataV, countryV3.getCulture(), countryV3.getArmyLevel());
        n4 = n4 * aIType.getDemandArmyExp() / 100;
        n5 = countryV3.getArmyExpPlus() == 0 ? 9999 : (n4 - countryV3.getArmyExp()) / countryV3.getArmyExpPlus();
        arrayList.add(new Tuple<Integer, Integer, Integer>(5, n5, n4));
        List list = gameDataV.getCountries().values().stream().filter(countryV2 -> gameDataV.distanceCountry(countryV3.getId(), countryV2.getId()) == 1).collect(Collectors.toList());
        n4 = n2 = (int)list.stream().mapToInt(countryV -> countryV.getArmyExp()).average().orElse(0.0);
        n4 = n4 * aIType.getDemandArmyExp() / 100;
        n5 = countryV3.getArmyExpPlus() == 0 ? 9999 : (n4 - countryV3.getArmyExp()) / countryV3.getArmyExpPlus();
        arrayList.add(new Tuple<Integer, Integer, Integer>(6, n5, n4));
        int n7 = (int)list.stream().mapToInt(countryV -> countryV.getTamichu()).average().orElse(0.0);
        n5 = countryV3.getTamichuPlus() == 0 ? 9999 : (n7 - countryV3.getTamichu()) / countryV3.getTamichuPlus();
        arrayList.add(new Tuple<Integer, Integer, Integer>(7, n5, n7));
        if (countryV3.getMaxTamichu() < n7) {
            arrayList.add(new Tuple<Integer, Integer, Integer>(10, n5 *= 2, n7));
        }
        if (daimyoV2.getChristTreat() != -1) {
            n4 = n = (int)Math.ceil(gameDataV.getCountries().values().stream().mapToInt(countryV -> countryV.getMaxChrist()).average().orElse(0.0));
            n4 = n4 * aIType.getDemandChrist() / 100;
            n5 = (n4 - countryV3.getMaxChrist()) * 9999 / (countryV3.getMaxChrist() * 10 + 1);
            arrayList.add(new Tuple<Integer, Integer, Integer>(8, n5, n4));
            n5 = countryV3.getChristPlus() == 0 ? 9999 : (countryV3.getMaxChrist() - countryV3.getChrist()) / countryV3.getChristPlus();
            arrayList.add(new Tuple<Integer, Integer, Integer>(9, n5, countryV3.getMaxChrist()));
        }
        n = (int)Math.ceil(gameDataV.getSpots().values().stream().mapToInt(spotV -> spotV.getDefense()).average().orElse(0.0));
        int n8 = (int)Math.ceil(countryV3.getSpots().stream().mapToInt(spotV -> spotV.getDefense()).average().orElse(0.0));
        n5 = (n - n8) * 9999 / (n8 + 1);
        arrayList.add(new Tuple<Integer, Integer, Integer>(11, n5, n));
        if (countryV3.getDaimyo().getIncomeExpect() < countryV3.getDaimyo().getExpressExpect()) {
            int n9 = countryV3.getDaimyo().getExpressExpect() - countryV3.getDaimyo().getIncomeExpect();
            n5 = 12 - countryV3.getDaimyo().getMoney() / n9;
            arrayList.add(new Tuple<Integer, Integer, Integer>(12, n5, n9));
        }
        n4 = countryV3.getMaxArmy() * 100;
        n4 = n4 * aIType.getDemandGun() / 100;
        n5 = daimyoV2.getGunPlus() == 0 ? 9999 : (n4 - daimyoV2.getGun()) / daimyoV2.getGunPlus();
        arrayList.add(new Tuple<Integer, Integer, Integer>(13, n5, n4));
        n4 = countryV3.getMaxArmy() * 100;
        n4 = n4 * aIType.getDemandHorse() / 100;
        n5 = daimyoV2.getHorsePlus() == 0 ? 9999 : (n4 - daimyoV2.getHorse()) / daimyoV2.getHorsePlus();
        n5 = n5 * aIType.getDemandHorse() / 100;
        arrayList.add(new Tuple<Integer, Integer, Integer>(14, n5, n4));
        n4 = countryV3.getMaxArmy() * 300;
        n5 = daimyoV2.getGunpowderPlus() == 0 ? 9999 : (n4 - daimyoV2.getGunpowder()) / daimyoV2.getGunpowderPlus();
        arrayList.add(new Tuple<Integer, Integer, Integer>(16, n5, n4 - daimyoV2.getGunpowder()));
        n4 = daimyoV2.getGunPlus() * 6;
        n5 = daimyoV2.getIronPlus() == 0 ? 9999 : (n4 - daimyoV2.getIron()) / daimyoV2.getIronPlus();
        arrayList.add(new Tuple<Integer, Integer, Integer>(15, n5, n4 - daimyoV2.getIron()));
        n4 = daimyoV2.getGunpowderPlus() * 6;
        n5 = daimyoV2.getSaltpeterPlus() == 0 ? 9999 : (n4 - daimyoV2.getSaltpeter()) / daimyoV2.getSaltpeterPlus();
        arrayList.add(new Tuple<Integer, Integer, Integer>(17, n5, n4 - daimyoV2.getSaltpeter()));
        double d = gameDataV.getDaimyos().values().stream().mapToInt(daimyoV -> daimyoV.getStoreIds().size()).average().orElse(0.0);
        double d2 = countryV3.getDaimyo().getStoreIds().size();
        n5 = (int)((d - d2) * 9999.0 / d2);
        arrayList.add(new Tuple<Integer, Integer, Integer>(18, n5, n5));
        arrayList.sort((tuple, tuple2) -> {
            if (tuple.getSecond() == tuple2.getSecond()) {
                return (Integer)tuple.getFirst() - (Integer)tuple2.getFirst();
            }
            return (Integer)tuple2.getSecond() - (Integer)tuple.getSecond();
        });
        return arrayList;
    }

    private static Pair<Build, Integer> selectBuild(GameDataV gameDataV, DaimyoV daimyoV, AIType aIType, CountryV countryV, Tuple<Integer, Integer, Integer> tuple, int n) {
        GameData gameData = gameDataV.getGameData();
        double d = gameDataV.getWorld().getInflationRate();
        Map<Integer, List<Integer>> map = GameCommandUtil.getMakableBuilds(gameDataV, countryV.getId());
        ArrayList arrayList = new ArrayList();
        map.forEach((n2, list2) -> {
            if (!list2.isEmpty()) {
                Build build = (Build)gameData.getBuilds().get(n2);
                if (countryV.getPower() * 9 >= build.getPower() && AIDomesticUtil.getCost(d, daimyoV.getDiscount(), build) <= n) {
                    double d2 = AIDomesticUtil.calcCostPerform(gameDataV, daimyoV, aIType, countryV, tuple, build);
                    arrayList.add(new Pair<Build, Double>(build, d2));
                }
            }
        });
        if (arrayList.isEmpty()) {
            return null;
        }
        arrayList.sort((pair, pair2) -> (int)Math.signum((Double)pair.getSecond() - (Double)pair2.getSecond()));
        Build build = (Build)((Pair)arrayList.get(0)).getFirst();
        int n3 = 0;
        List<Integer> list = map.get(build.getId());
        if (!list.isEmpty()) {
            n3 = list.size() == 1 ? list.get(0).intValue() : GameUtil.getRandom(list).intValue();
        }
        Pair<Build, Integer> pair3 = new Pair<Build, Integer>(build, n3);
        return pair3;
    }

    private static double calcCostPerform(GameDataV gameDataV, DaimyoV daimyoV, AIType aIType, CountryV countryV, Tuple<Integer, Integer, Integer> tuple, Build build) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (tuple.getFirst()) {
            case 1: {
                d = countryV.getFood();
                d2 = countryV.getFoodPlus();
                d4 = build.getEffect().getFoodPlus();
                break;
            }
            case 2: {
                d = countryV.getCommerce();
                d2 = countryV.getCommercePlus();
                d4 = build.getEffect().getCommercePlus();
                break;
            }
            case 3: {
                d = countryV.getPopulation();
                d2 = countryV.getPopulationPlus();
                d4 = build.getEffect().getPopulationPlus();
                break;
            }
            case 22: {
                d = countryV.getFood();
                d2 = countryV.getFoodPlus();
                d4 = build.getEffect().getFoodPlus();
                break;
            }
            case 25: {
                d = countryV.getPopulation();
                d2 = countryV.getPopulationPlus();
                d4 = build.getEffect().getPopulationPlus();
                break;
            }
            case 4: {
                d = countryV.getCulture();
                d2 = countryV.getCulturePlus();
                d4 = build.getEffect().getCulturePlus();
                break;
            }
            case 5: {
                d = countryV.getArmyExp();
                d2 = countryV.getArmyExpPlus();
                d4 = build.getEffect().getArmyExpPlus();
                break;
            }
            case 6: {
                d = countryV.getArmyExp();
                d2 = countryV.getArmyExpPlus();
                d4 = build.getEffect().getArmyExpPlus();
                break;
            }
            case 8: {
                d = countryV.getMaxChrist();
                d2 = 0.0;
                d4 = 0.0;
                d3 = build.getEffect().getMaxChristRate();
                break;
            }
            case 9: {
                d = countryV.getChrist();
                d2 = countryV.getChristPlus();
                d4 = build.getEffect().getChristPlus();
                break;
            }
            case 7: {
                d = countryV.getTamichu();
                d2 = countryV.getTamichuPlus();
                d4 = build.getEffect().getTamichuPlus();
                break;
            }
            case 10: {
                double d5 = gameDataV.getGameData().getParameters().getTamichuDiv1();
                double d6 = gameDataV.getGameData().getParameters().getTamichuDiv2();
                d = countryV.getMaxTamichu();
                d2 = 0.0;
                d4 = (double)build.getEffect().getCulturePlus() / d5 + (double)build.getEffect().getCommercePlus() / d6;
                d3 = build.getEffect().getMaxTamichuPlus();
                break;
            }
            case 11: {
                d = countryV.getCapitalSpot().getDefense();
                d2 = 0.0;
                d4 = 0.0;
                d3 = build.getEffect().getDefensePlus();
                break;
            }
            case 12: {
                d = countryV.getAmountEffect().getMoneyPlus() + countryV.getAmountEffect().getGoldMountainPlus();
                d2 = 0.0;
                d4 = build.getEffect().getMoneyPlus();
                break;
            }
            case 13: {
                d = daimyoV.getGun();
                d2 = countryV.getAmountEffect().getGunPlus();
                d4 = build.getEffect().getGunPlus();
                break;
            }
            case 14: {
                d = daimyoV.getHorse();
                d2 = countryV.getAmountEffect().getHorsePlus();
                d4 = build.getEffect().getHorsePlus();
                break;
            }
            case 15: {
                d = daimyoV.getIron();
                d2 = countryV.getAmountEffect().getIronPlus();
                d4 = build.getEffect().getIronPlus();
                break;
            }
            case 16: {
                d = daimyoV.getGunpowder();
                d2 = countryV.getAmountEffect().getGunpowderPlus();
                d4 = build.getEffect().getGunpowderPlus();
                break;
            }
            case 17: {
                d = daimyoV.getSaltpeter();
                d2 = countryV.getAmountEffect().getSaltpeterPlus();
                d4 = build.getEffect().getSaltpeterPlus();
                break;
            }
            case 18: {
                return build.getStoreId() == 0 ? 9999 : 1;
            }
        }
        return AIDomesticUtil.calcCostPerform(tuple.getThird(), d, d2, d3, d4, build.getPower() / countryV.getPower() + 1, build.getHeadCost(), build.getCost());
    }

    private static double calcCostPerform(int n, double d, double d2, double d3, double d4, int n2, int n3, int n4) {
        int n5;
        double d5;
        if (d4 <= 0.0) {
            return 999.0;
        }
        if ((double)n <= d) {
            return (double)(n3 + n2 * n4) * 1.0 / (double)n2 * d4;
        }
        int n6 = 0;
        while (!((double)n <= d + (d5 = (double)n6 * d2 + (double)(n6 * (n5 = n6 / n2)) * d4 + (double)n5 * d3 - (double)(n5 * (n5 + 1) / 2 * n2) * d4))) {
            ++n6;
        }
        return n6;
    }

    private static boolean employGiant(GameDataV gameDataV, AIType aIType, DaimyoV daimyoV, GiantV giantV) {
        int n = giantV.getGiant().getCultureMonths();
        int n2 = giantV.getHeadPay();
        int n3 = giantV.getPay();
        int n4 = daimyoV.getIncomeExpect();
        int n5 = daimyoV.getExpressExpect();
        int n6 = daimyoV.getMoney();
        return n6 + n * n4 - n * n5 - (n2 + n * n3) > 0;
    }

    private static boolean employKnight(GameDataV gameDataV, AIType aIType, DaimyoV daimyoV, KnightV knightV) {
        int n = knightV.getHeadPay();
        int n2 = knightV.getPay();
        int n3 = daimyoV.getIncomeExpect();
        int n4 = daimyoV.getExpressExpect();
        int n5 = daimyoV.getMoney();
        return n <= n5 && n4 + n2 <= n3;
    }

    private static int soubuji(GameDataV gameDataV, DaimyoV daimyoV, PlayerV playerV, int n) {
        if (GameCommandUtil.canSoubuji(gameDataV, daimyoV.getId())) {
            CommandV commandV = GameCommandCreator.commandSoubuji(0, daimyoV.getId());
            playerV.getCommands().add(commandV);
        }
        return n;
    }

    private static int propagate(GameDataV gameDataV, DaimyoV daimyoV, AIType aIType, PlayerV playerV, int n) {
        SpotV spotV;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (CountryV countryV2 : daimyoV.getCountries()) {
            object = countryV2.getSpots().iterator();
            while (object.hasNext()) {
                spotV = (SpotV)object.next();
                for (UnitV unitV : spotV.getUnits()) {
                    if (!gameDataV.isBattleTerget(daimyoV.getId(), unitV.getOperationDaimyoId()) || arrayList.contains(unitV.getCountry())) continue;
                    arrayList.add(unitV.getCountry());
                }
            }
        }
        for (DaimyoV daimyoV2 : daimyoV.getWars()) {
            object = daimyoV2.getCountries().iterator();
            while (object.hasNext()) {
                spotV = (CountryV)object.next();
                if (arrayList.contains(spotV)) continue;
                arrayList.add(spotV);
            }
        }
        for (DaimyoV daimyoV3 : daimyoV.getNearbyDaimyo()) {
            object = daimyoV3.getCountries().iterator();
            while (object.hasNext()) {
                spotV = (CountryV)object.next();
                if (arrayList.contains(spotV)) continue;
                arrayList.add(spotV);
            }
        }
        arrayList.removeIf(countryV -> countryV == null);
        for (CountryV countryV2 : arrayList) {
            if (countryV2.getMaxArmy() * 50 < countryV2.getMissionary() && !countryV2.isBeIkkou() && (object = gameDataV.getRelation(daimyoV.getId(), countryV2.getDaimyoId())) != null && object.getFriendShipType() != 1 && object.getFriendShipType() != 2) {
                CommandV commandV = GameCommandCreator.commandAgitate(0, countryV2.getId());
                playerV.getCommands().add(commandV);
                continue;
            }
            object = GameCommandUtil.calcMission(countryV2);
            Object object2 = object[0];
            Object object3 = object[1];
            Object object4 = object[2];
            Object object5 = object[3];
            Object object6 = object[4];
            if (n < object6 || object5 + countryV2.getChrist() > 100) continue;
            CommandV commandV = GameCommandCreator.commandPropagate((int)object6, countryV2.getId(), (int)object2, (int)object3, (int)object4, (int)object5);
            playerV.getCommands().add(commandV);
            n -= object6;
        }
        return n;
    }

    private static Pair<Build, Integer> selectPrioryBuild(GameDataV gameDataV, DaimyoV daimyoV, AIType aIType, CountryV countryV, int n) {
        GameData gameData = gameDataV.getGameData();
        double d = gameDataV.getWorld().getInflationRate();
        Map<Integer, List<Integer>> map = GameCommandUtil.getMakableBuilds(gameDataV, countryV.getId());
        ArrayList arrayList = new ArrayList();
        map.forEach((n2, list2) -> {
            Build build;
            if (!(!aIType.getPriorBuilds().contains(n2) || list2.isEmpty() || (build = (Build)gameData.getBuilds().get(n2)).getStoreId() != 0 && daimyoV.getStoreIds().contains(build.getStoreId()) || countryV.getPower() * 6 < build.getPower() || AIDomesticUtil.getCost(d, daimyoV.getDiscount(), build) > n)) {
                int n3 = (Integer)GameUtil.getRandom(list2);
                arrayList.add(new Pair<Build, Integer>(build, n3));
            }
        });
        if (arrayList.isEmpty()) {
            return null;
        }
        Pair pair = (Pair)GameUtil.getRandom(arrayList);
        return pair;
    }

    private static int build(GameDataV gameDataV, DaimyoV daimyoV, AIType aIType, PlayerV playerV, int n) {
        for (CountryV countryV : daimyoV.getCountries()) {
            n = AIDomesticUtil.build(gameDataV, countryV, daimyoV, aIType, playerV, n);
        }
        return n;
    }

    private static int build(GameDataV gameDataV, CountryV countryV, DaimyoV daimyoV, AIType aIType, PlayerV playerV, int n) {
        Tuple<Integer, Integer, Integer> tuple;
        double d = gameDataV.getWorld().getInflationRate();
        if (!countryV.getBuildPlans().isEmpty()) {
            return n;
        }
        boolean bl = playerV.getCommands().stream().filter(commandV -> commandV.getKind() == 2).anyMatch(commandV -> countryV.getId() == ((Integer)commandV.getArgs().get(0)).intValue());
        if (bl) {
            return n;
        }
        Pair<Build, Integer> pair = AIDomesticUtil.selectPrioryBuild(gameDataV, daimyoV, aIType, countryV, n);
        Pair<Build, Integer> pair2 = null;
        List<Tuple<Integer, Integer, Integer>> list = AIDomesticUtil.calcPriority(gameDataV, daimyoV, aIType, countryV);
        Object object = list.iterator();
        while (object.hasNext() && (pair2 = AIDomesticUtil.selectBuild(gameDataV, daimyoV, aIType, countryV, tuple = object.next(), n)) == null) {
        }
        if (pair2 == null && pair == null) {
            return n;
        }
        object = GameCommandUtil.getKnightBuilds(gameDataV, daimyoV.getId(), playerV);
        int n2 = object.stream().sorted((knightV, knightV2) -> knightV2.getDomestic() - knightV.getDomestic()).mapToInt(knightV -> knightV.getId()).findFirst().orElse(0);
        int n3 = AIDomesticUtil.getCost(d, daimyoV.getDiscount(), pair2.getFirst());
        playerV.getCommands().add(GameCommandCreator.commandBuildPlan(n3, countryV.getId(), pair2.getFirst().getId(), pair2.getSecond(), n2));
        return n -= n3;
    }

    private static int researchTechnology(GameDataV gameDataV, DaimyoV daimyoV, AIType aIType, PlayerV playerV, int n) {
        List<KnightV> list = GameCommandUtil.getKnightResearchs(gameDataV, daimyoV.getId(), playerV);
        list.sort((knightV, knightV2) -> knightV2.getCulture() - knightV.getCulture());
        List<TechnologyV> list2 = GameCommandUtil.getProgressTechnology(gameDataV, daimyoV.getId());
        list2.sort((technologyV, technologyV2) -> AIDomesticUtil.priprityOfTechnology(daimyoV, aIType, technologyV2.getTechnology()) - AIDomesticUtil.priprityOfTechnology(daimyoV, aIType, technologyV.getTechnology()));
        for (TechnologyV technologyV3 : list2) {
            if (list.isEmpty()) break;
            int n2 = DomesticResearchUtil.getStatus(technologyV3.getId(), playerV);
            if (n2 != 2 && n2 != 3) continue;
            DomesticResearchUtil.start(technologyV3.getId(), list.get(0).getId(), playerV);
            list.remove(0);
        }
        return n;
    }

    public static int priprityOfTechnology(DaimyoV daimyoV, AIType aIType, Technology technology) {
        if (daimyoV.getTechnologyIds().contains(technology.getId())) {
            return 0;
        }
        if (aIType.getPriorTechnologies().contains(technology.getId())) {
            return 1000;
        }
        return technology.getEffect().getValue();
    }

    public static int priprityOfCulture(DaimyoV daimyoV, AIType aIType, Culture culture) {
        if (daimyoV.getCultureIds().contains(culture.getId())) {
            return 0;
        }
        if (aIType.getPriorCultures().contains(culture.getId())) {
            return 1000;
        }
        return culture.getEffect().getValue();
    }

    private static int employGiant(GameDataV gameDataV, DaimyoV daimyoV, AIType aIType, PlayerV playerV, int n) {
        List<GiantV> list = GameCommandUtil.getGiantEmploies(gameDataV, daimyoV.getId());
        for (GiantV giantV : list) {
            boolean bl = playerV.getCommands().stream().filter(commandV -> commandV.getKind() == 7).anyMatch(commandV -> giantV.getId() == ((Integer)commandV.getArgs().get(0)).intValue());
            if (bl || daimyoV.getCultureArv() < giantV.getGiant().getMinCulture() || giantV.getHeadPay() >= n || !AIDomesticUtil.employGiant(gameDataV, aIType, daimyoV, giantV)) continue;
            SpotV spotV = (SpotV)gameDataV.getSpots().get(giantV.getSpotId());
            CommandV commandV2 = GameCommandCreator.commandEmployGiant(giantV.getHeadPay(), giantV.getId(), spotV.getCountryId());
            playerV.getCommands().add(commandV2);
            n -= giantV.getHeadPay();
            break;
        }
        return n;
    }

    private static boolean shouldEmployee(DaimyoV daimyoV, AIType aIType, KnightV knightV, int n, int n2, int n3) {
        return n <= knightV.getDomestic() || n2 <= knightV.getTactics() || n3 <= knightV.getCulture();
    }

    private static int maxValue(KnightV knightV) {
        return Math.max(knightV.getDomestic(), Math.max(knightV.getTactics(), knightV.getCulture()));
    }

    private static int employKnight(GameDataV gameDataV, DaimyoV daimyoV, AIType aIType, PlayerV playerV, int n) {
        int n2;
        List<KnightV> list = GameCommandUtil.getKnightEmploies(gameDataV, daimyoV.getId());
        List<KnightV> list2 = GameCommandUtil.getKnightAbsorb(gameDataV, daimyoV.getId());
        list.addAll(list2);
        list.sort((knightV, knightV2) -> AIDomesticUtil.maxValue(knightV2) - AIDomesticUtil.maxValue(knightV));
        if ((double)daimyoV.getEmployeeKnights().size() >= (double)daimyoV.getCountries().size() * 2.5) {
            int n3 = daimyoV.getEmployeeKnights().stream().mapToInt(knightV -> knightV.getDomestic()).max().orElse(0);
            int n4 = daimyoV.getEmployeeKnights().stream().mapToInt(knightV -> knightV.getTactics()).max().orElse(0);
            n2 = daimyoV.getEmployeeKnights().stream().mapToInt(knightV -> knightV.getCulture()).max().orElse(0);
            list.removeIf(knightV -> !AIDomesticUtil.shouldEmployee(daimyoV, aIType, knightV, n3, n4, n2));
        }
        for (KnightV knightV3 : list) {
            n2 = playerV.getCommands().stream().filter(commandV -> commandV.getKind() == 6 || commandV.getKind() == 10).anyMatch(commandV -> knightV3.getId() == ((Integer)commandV.getArgs().get(0)).intValue());
            if (n2 != 0 || knightV3.getHeadPay() >= n || !AIDomesticUtil.employKnight(gameDataV, aIType, daimyoV, knightV3)) continue;
            if (knightV3.getDaimyoId() == 0) {
                SpotV spotV = (SpotV)gameDataV.getSpots().get(knightV3.getSpotId());
                CommandV commandV2 = GameCommandCreator.commandEmployKnight(knightV3.getHeadPay(), knightV3.getId(), spotV.getCountryId());
                playerV.getCommands().add(commandV2);
                n -= knightV3.getHeadPay();
                break;
            }
            CommandV commandV3 = GameCommandCreator.commandAbsorp(knightV3.getHeadPay(), knightV3.getId());
            playerV.getCommands().add(commandV3);
            n -= knightV3.getHeadPay();
            break;
        }
        return n;
    }

    private static int assignTreasure(GameDataV gameDataV, DaimyoV daimyoV, AIType aIType, PlayerV playerV, int n) {
        CommandV commandV2;
        KnightV knightV2;
        KnightV knightV3;
        Object object2;
        playerV.getCommands().removeIf(commandV -> commandV.getKind() == 16);
        List<TreasureV> list = GameCommandUtil.getTreasures(gameDataV, playerV.getDaimyoId());
        ArrayList<KnightV> arrayList = new ArrayList<KnightV>();
        for (Object object2 : daimyoV.getResearches().values()) {
            knightV3 = (KnightV)gameDataV.getKnights().get(object2.getKnightId());
            if (knightV3 == null || !GameCommandUtil.isKnightTreasures(gameDataV, daimyoV.getId(), knightV3)) continue;
            arrayList.add(knightV3);
        }
        if (!arrayList.isEmpty()) {
            int n2 = 0;
            object2 = list.iterator();
            while (object2.hasNext()) {
                knightV3 = (TreasureV)object2.next();
                if (knightV3.getTreasure().getCulturePlus() <= 0) continue;
                knightV2 = (KnightV)arrayList.get(n2 % arrayList.size());
                commandV2 = GameCommandCreator.commandTreasure(0, knightV2.getId(), knightV3.getId());
                playerV.getCommands().add(commandV2);
                ++n2;
                object2.remove();
            }
        }
        arrayList.clear();
        daimyoV.getCountries().stream().flatMap(countryV -> countryV.getBuildPlans().stream()).forEach(buildPlan -> {
            if (buildPlan.getKnight() != null && GameCommandUtil.isKnightTreasures(gameDataV, daimyoV.getId(), buildPlan.getKnight())) {
                arrayList.add(buildPlan.getKnight());
            }
        });
        if (!arrayList.isEmpty()) {
            int n3 = 0;
            object2 = list.iterator();
            while (object2.hasNext()) {
                knightV3 = (TreasureV)object2.next();
                if (knightV3.getTreasure().getDomesticPlus() <= 0) continue;
                knightV2 = (KnightV)arrayList.get(n3 % arrayList.size());
                commandV2 = GameCommandCreator.commandTreasure(0, knightV2.getId(), knightV3.getId());
                playerV.getCommands().add(commandV2);
                ++n3;
                object2.remove();
            }
        }
        arrayList.clear();
        daimyoV.getEmployeeKnights().stream().filter(knightV -> knightV.isGoOut()).forEach(knightV -> {
            if (knightV != null && GameCommandUtil.isKnightTreasures(gameDataV, daimyoV.getId(), knightV)) {
                arrayList.add((KnightV)knightV);
            }
        });
        if (!arrayList.isEmpty()) {
            int n4 = 0;
            object2 = list.iterator();
            while (object2.hasNext()) {
                knightV3 = (TreasureV)object2.next();
                if (knightV3.getTreasure().getTacticsPlus() <= 0) continue;
                knightV2 = (KnightV)arrayList.get(n4 % arrayList.size());
                commandV2 = GameCommandCreator.commandTreasure(0, knightV2.getId(), knightV3.getId());
                playerV.getCommands().add(commandV2);
                ++n4;
                object2.remove();
            }
        }
        return n;
    }

    private static int releaseKnight(GameDataV gameDataV, DaimyoV daimyoV, AIType aIType, PlayerV playerV, int n) {
        List<KnightV> list = GameCommandUtil.getKnightRelease(gameDataV, daimyoV.getId());
        list.removeIf(knightV -> playerV.getCommands().stream().filter(commandV -> commandV.getKind() == 8).anyMatch(commandV -> knightV.getId() == ((Integer)commandV.getArgs().get(0)).intValue()));
        if ((double)daimyoV.getEmployeeKnights().size() < (double)daimyoV.getCountries().size() * 3.5) {
            return n;
        }
        list.sort((knightV, knightV2) -> AIDomesticUtil.maxValue(knightV) - AIDomesticUtil.maxValue(knightV2));
        CommandV commandV = GameCommandCreator.commandReleaseKnight(0, list.get(0).getId());
        playerV.getCommands().add(commandV);
        return n;
    }

    private static int getCost(double d, int n, Build build) {
        double d2 = (double)(100 - n) / 100.0;
        return (int)Math.ceil((double)build.getHeadCost() * d * d2);
    }
}

