/*
 * Decompiled with CFR 0.152.
 */
package game.base.sprite;

import game.base.calc.AffineMatrix;
import game.base.common.HasAbsoluteXY;
import game.base.graphic.BatchGraphicContext;
import game.base.graphic.ColorSpace;
import game.base.graphic.Drawable;
import game.base.graphic.DrawableTexture;
import java.util.ArrayList;
import java.util.List;

public abstract class Sprite
implements HasAbsoluteXY {
    protected int x = 0;
    protected int y = 0;
    protected int z = 0;
    protected int opacity = 255;
    protected boolean visible = true;
    private boolean needUpdate = true;
    protected int rotate = 0;
    protected DrawableTexture content;
    protected AffineMatrix af = new AffineMatrix();
    protected List<Sprite> children = new ArrayList<Sprite>();
    protected Sprite parent;

    public void draw(BatchGraphicContext batchGraphicContext) {
        if (this.isVisible() && 0 < this.opacity && this.content != null) {
            if (this.checkNeedUpdate()) {
                this.updateContent();
                if (this.opacity < 255) {
                    this.updateOpacity();
                }
            }
            if (this.rotate == 0) {
                batchGraphicContext.setAffine(null);
                batchGraphicContext.drawImage(this.content, this.x, this.y, this.z);
            } else {
                this.af.initialize();
                int n = this.content.getWidth();
                int n2 = this.content.getHeight();
                int n3 = (int)((double)this.x + (double)n / 2.0 - (double)n / 2.0 * Math.cos(Math.toRadians(this.rotate)) + (double)n2 / 2.0 * Math.sin(Math.toRadians(this.rotate)));
                int n4 = (int)((double)this.y + (double)n2 / 2.0 - (double)n / 2.0 * Math.sin(Math.toRadians(this.rotate)) - (double)n2 / 2.0 * Math.cos(Math.toRadians(this.rotate)));
                this.af.translate(n3, n4);
                this.af.rotate(this.rotate);
                batchGraphicContext.setAffine(this.af);
                batchGraphicContext.drawImage(this.content, 0, 0, this.z);
                batchGraphicContext.setAffine(null);
            }
        }
        this.needUpdate = false;
    }

    public void draw(Drawable drawable) {
        if (this.isVisible() && 0 < this.opacity && this.content != null) {
            if (this.checkNeedUpdate()) {
                this.updateContent();
                if (this.opacity < 255) {
                    this.updateOpacity();
                }
            }
            if (this.rotate == 0) {
                drawable.setAffine(null);
                drawable.drawImage(this.content, this.x, this.y);
            } else {
                this.af.initialize();
                this.af.translate(this.x, this.y);
                this.af.rotate(this.rotate);
                drawable.setAffine(this.af);
                drawable.drawImage(this.content, 0, 0);
                drawable.setAffine(null);
            }
        }
        this.needUpdate = false;
    }

    public abstract void update();

    protected abstract void updateContent();

    protected void updateOpacity() {
        byte by = (byte)(0xFF & this.opacity);
        byte[] byArray = this.content.getBytes(ColorSpace.RGB_ALPHA);
        for (int i = 0; i < byArray.length; ++i) {
            if (i % 4 != 3 || byArray[i] == 0) continue;
            byArray[i] = by;
        }
        this.content.reset(byArray, ColorSpace.RGB_ALPHA);
    }

    @Override
    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int n) {
        this.z = n;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int n) {
        if (this.opacity != n) {
            this.opacity = n;
            this.needUpdate();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.needUpdate();
        }
    }

    public int getRotate() {
        return this.rotate;
    }

    public void setRotate(int n) {
        if (this.rotate != n) {
            this.rotate = n;
            this.needUpdate();
        }
    }

    @Override
    public Sprite getParent() {
        return this.parent;
    }

    public void setParent(Sprite sprite) {
        this.parent = sprite;
    }

    protected boolean checkNeedUpdate() {
        return this.needUpdate || this.children.parallelStream().anyMatch(sprite -> sprite.checkNeedUpdate());
    }

    public void needUpdate() {
        this.needUpdate = true;
    }
}

