/*
 * Decompiled with CFR 0.152.
 */
package game.base.graphic;

import game.base.calc.AffineMatrix;
import game.base.font.Font;
import game.base.graphic.DrawEvent;
import game.base.graphic.DrawFillEvent;
import game.base.graphic.DrawImageEvent;
import game.base.graphic.DrawTextEvent;
import game.base.graphic.GraphicContext;
import game.base.graphic.Texture;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class BatchGraphicContext {
    private List<DrawEvent> events;
    private int clearColor;
    private GraphicContext gcontext;
    private AffineMatrix affine;

    public BatchGraphicContext() {
        this.events = new ArrayList<DrawEvent>();
    }

    public BatchGraphicContext(GraphicContext graphicContext) {
        this.gcontext = graphicContext;
        this.events = new LinkedList<DrawEvent>();
    }

    public void clear(int n) {
        this.events.clear();
        this.clearColor = n;
    }

    private void addEvent(DrawEvent drawEvent) {
        drawEvent.setAffine(this.affine);
        ListIterator<DrawEvent> listIterator = this.events.listIterator();
        while (listIterator.hasNext()) {
            DrawEvent drawEvent2 = listIterator.next();
            if (drawEvent2.getZ() <= drawEvent.getZ()) continue;
            listIterator.previous();
            break;
        }
        listIterator.add(drawEvent);
    }

    public void fill(int n, int n2, int n3, int n4, int n5, int n6) {
        DrawFillEvent drawFillEvent = new DrawFillEvent(n, n2, n3, n4, n5, n6);
        this.addEvent(drawFillEvent);
    }

    public void drawImage(Texture texture, int n, int n2, int n3) {
        this.drawImage(texture, 0, 0, texture.getWidth(), texture.getHeight(), n, n2, n3);
    }

    public void drawImage(Texture texture, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        DrawImageEvent drawImageEvent = new DrawImageEvent(texture, n, n2, n3, n4, n5, n6, n3, n4, n7);
        this.addEvent(drawImageEvent);
    }

    public void drawImage(Texture texture, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        DrawImageEvent drawImageEvent = new DrawImageEvent(texture, n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.addEvent(drawImageEvent);
    }

    public void drawText(String string, Font font, int n, int n2, int n3, int n4) {
        DrawTextEvent drawTextEvent = new DrawTextEvent(string, font, n, n2, n3, n4);
        this.addEvent(drawTextEvent);
    }

    public void setAffine(AffineMatrix affineMatrix) {
        this.affine = affineMatrix;
    }

    public void commit() {
        this.gcontext.clear(this.clearColor);
        for (DrawEvent drawEvent : this.events) {
            this.gcontext.setAffine(drawEvent.getAffine());
            switch (drawEvent.getEventType()) {
                case FILL: {
                    DrawFillEvent drawFillEvent = (DrawFillEvent)drawEvent;
                    this.gcontext.fill(drawFillEvent.getRgba(), drawFillEvent.getTargetX(), drawFillEvent.getTargetY(), drawFillEvent.getTargetWidth(), drawFillEvent.getTargetHeight());
                    break;
                }
                case IMAGE: {
                    DrawImageEvent drawImageEvent = (DrawImageEvent)drawEvent;
                    this.gcontext.drawImage(drawImageEvent.getTexture(), drawImageEvent.getSrcX(), drawImageEvent.getSrcY(), drawImageEvent.getSrcWidth(), drawImageEvent.getSrcHeight(), drawImageEvent.getTargetX(), drawImageEvent.getTargetY(), drawImageEvent.getTargetWidth(), drawImageEvent.getTargetHeight());
                    break;
                }
                case TEXT: {
                    DrawTextEvent drawTextEvent = (DrawTextEvent)drawEvent;
                    this.gcontext.drawText(drawTextEvent.getText(), drawTextEvent.getFont(), drawTextEvent.getRgba(), drawTextEvent.getTargetX(), drawTextEvent.getTargetY());
                    break;
                }
            }
            this.gcontext.setAffine(null);
        }
        this.gcontext.commit();
    }
}

