/*
 * Decompiled with CFR 0.152.
 */
package game.base.common;

import game.base.common.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ResourcePool<T extends Resource> {
    private Map<String, T> map = new HashMap<String, T>();
    private List<String> calls = new ArrayList<String>();
    private long totalSize = 0L;
    private static final long maxSize = 0xC800000L;
    private static final long fitSize = 0x6400000L;

    public T getResource(String string) {
        if (!this.map.containsKey(string)) {
            T t = this.load(string);
            if (this.totalSize + (long)t.getSize() > 0xC800000L) {
                this.gc();
            }
            this.map.put(string, t);
            this.totalSize += (long)t.getSize();
        }
        this.updateCall(string);
        return (T)((Resource)this.map.get(string));
    }

    public void gc() {
        Iterator<String> iterator = this.calls.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!this.map.containsKey(string)) {
                iterator.remove();
                continue;
            }
            Integer n = ((Resource)this.map.get(string)).getSize();
            this.release(string);
            iterator.remove();
            this.totalSize -= (long)n.intValue();
            if (this.totalSize > 0x6400000L) continue;
            break;
        }
    }

    protected abstract T load(String var1);

    private void updateCall(String string) {
        this.calls.remove(string);
        this.calls.add(string);
    }

    private void release(String string) {
        this.map.remove(string);
    }
}

