/*
 * Decompiled with CFR 0.152.
 */
package game.base.calc;

import game.base.exception.ApplicationRuntimeException;

public class PixelConvert {
    public static void toBytes4(int[] nArray, byte[] byArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            byArray[i * 4 + 2] = (byte)(0xFF & n);
            byArray[i * 4 + 1] = (byte)(0xFF & n >>> 8);
            byArray[i * 4 + 0] = (byte)(0xFF & n >>> 16);
            byArray[i * 4 + 3] = (byte)(0xFF & n >>> 24);
        }
    }

    public static void toBytes3(int[] nArray, byte[] byArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            byArray[i * 3 + 2] = (byte)(0xFF & n);
            byArray[i * 3 + 1] = (byte)(0xFF & n >>> 8);
            byArray[i * 3 + 0] = (byte)(0xFF & n >>> 16);
        }
    }

    public static void toInts4(byte[] byArray, int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = byArray[n++] & 0xFF;
            int n3 = byArray[n++] & 0xFF;
            int n4 = byArray[n++] & 0xFF;
            int n5 = byArray[n++] & 0xFF;
            nArray[i] = n5 << 24 | n2 << 16 | n3 << 8 | n4;
        }
    }

    public static void toInts3(byte[] byArray, int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = byArray[n++] & 0xFF;
            int n3 = byArray[n++] & 0xFF;
            int n4 = byArray[n++] & 0xFF;
            int n5 = 255;
            nArray[i] = n5 << 24 | n2 << 16 | n3 << 8 | n4;
        }
    }

    public static void convertRGB2BGR(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length || byArray.length % 3 != 0 || byArray2.length % 3 != 0) {
            throw new ApplicationRuntimeException("format error");
        }
        for (int i = 0; i < byArray.length; i += 3) {
            byArray2[i] = byArray[i + 2];
            byArray2[i + 1] = byArray[i + 1];
            byArray2[i + 2] = byArray[i];
        }
    }

    public static void convertBGR2RGB(byte[] byArray, byte[] byArray2) {
        PixelConvert.convertRGB2BGR(byArray, byArray2);
    }

    public static void convertRGBA2BGRA(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length || byArray.length % 4 != 0 || byArray2.length % 4 != 0) {
            throw new ApplicationRuntimeException("format error");
        }
        for (int i = 0; i < byArray.length; i += 4) {
            byArray2[i] = byArray[i + 2];
            byArray2[i + 1] = byArray[i + 1];
            byArray2[i + 2] = byArray[i];
            byArray2[i + 3] = byArray[i + 3];
        }
    }

    public static void convertBGRA2RGBA(byte[] byArray, byte[] byArray2) {
        PixelConvert.convertRGBA2BGRA(byArray, byArray2);
    }
}

