/*
 * Decompiled with CFR 0.152.
 */
package game.java2d.graphic;

import game.base.exception.ApplicationRuntimeException;
import game.java2d.graphic.DrawableJ2D;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageJ2D
extends DrawableJ2D {
    private int size;
    private BufferedImage image;

    public ImageJ2D(InputStream inputStream) {
        try {
            this.size = inputStream.available();
            this.image = ImageIO.read(inputStream);
            if (this.image.getType() != 2) {
                BufferedImage bufferedImage = this.image;
                this.image = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
                Graphics2D graphics2D = this.image.createGraphics();
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                graphics2D.dispose();
            }
        }
        catch (IOException iOException) {
            throw new ApplicationRuntimeException((Throwable)iOException);
        }
    }

    public ImageJ2D(int n, int n2) {
        this.image = new BufferedImage(n, n2, 2);
        this.size = 4 * n * n2;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }
}

