/*
 * Decompiled with CFR 0.152.
 */
package game.java2d.graphic;

import game.base.calc.AffineMatrix;
import game.base.calc.PixelConvert;
import game.base.font.Font;
import game.base.graphic.ColorSpace;
import game.base.graphic.DrawableTexture;
import game.base.graphic.Texture;
import game.java2d.font.FontJ2D;
import game.java2d.graphic.ImageJ2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public abstract class DrawableJ2D
extends DrawableTexture {
    protected AffineTransform affine;

    public byte[] getBytes(ColorSpace colorSpace, int n, int n2, int n3, int n4) {
        int[] nArray = new int[n3 * n4];
        this.getImage().getRGB(n, n2, n3, n4, nArray, 0, n3);
        byte[] byArray = new byte[]{};
        switch (colorSpace) {
            case BGR: {
                byte[] byArray2 = new byte[n3 * n4 * 3];
                PixelConvert.toBytes3((int[])nArray, (byte[])byArray2);
                byArray = new byte[n3 * n4 * 3];
                PixelConvert.convertRGB2BGR((byte[])byArray2, (byte[])byArray);
                break;
            }
            case BGR_ALPHA: {
                byte[] byArray3 = new byte[n3 * n4 * 4];
                byArray = new byte[n3 * n4 * 4];
                PixelConvert.toBytes4((int[])nArray, (byte[])byArray3);
                PixelConvert.convertBGRA2RGBA((byte[])byArray3, (byte[])byArray);
                break;
            }
            case RGB: {
                byArray = new byte[n3 * n4 * 3];
                PixelConvert.toBytes3((int[])nArray, (byte[])byArray);
                break;
            }
            case RGB_ALPHA: {
                byArray = new byte[n3 * n4 * 4];
                PixelConvert.toBytes4((int[])nArray, (byte[])byArray);
                break;
            }
        }
        return byArray;
    }

    public int getWidth() {
        return this.getImage().getWidth();
    }

    public int getHeight() {
        return this.getImage().getHeight();
    }

    public void close() throws Exception {
    }

    public void reset(byte[] byArray, ColorSpace colorSpace, int n, int n2, int n3, int n4) {
        int[] nArray = new int[n3 * n4];
        switch (colorSpace) {
            case BGR: {
                byte[] byArray2 = new byte[n3 * n4 * 3];
                PixelConvert.convertBGR2RGB((byte[])byArray, (byte[])byArray2);
                PixelConvert.toInts3((byte[])byArray2, (int[])nArray);
                break;
            }
            case BGR_ALPHA: {
                byte[] byArray3 = new byte[n3 * n4 * 4];
                PixelConvert.convertBGRA2RGBA((byte[])byArray, (byte[])byArray3);
                PixelConvert.toInts4((byte[])byArray3, (int[])nArray);
                break;
            }
            case RGB: {
                PixelConvert.toInts3((byte[])byArray, (int[])nArray);
                break;
            }
            case RGB_ALPHA: {
                PixelConvert.toInts4((byte[])byArray, (int[])nArray);
                break;
            }
        }
        this.getImage().setRGB(n, n2, n3, n4, nArray, 0, n3);
    }

    public void clear(int n) {
        Graphics2D graphics2D = this.getGraphics2D();
        int n2 = this.RGBA2ARGB(n);
        graphics2D.setBackground(new Color(n2, true));
        graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.dispose();
    }

    public void fill(int n, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = this.getGraphics2D();
        if (this.affine != null) {
            graphics2D.transform(this.affine);
        }
        int n6 = this.RGBA2ARGB(n);
        graphics2D.setColor(new Color(n6, true));
        graphics2D.fillRect(n2, n3, n4, n5);
        graphics2D.dispose();
    }

    public void drawImage(Texture texture, int n, int n2) {
        this.drawImage(texture, 0, 0, texture.getWidth(), texture.getHeight(), n, n2);
    }

    public void drawImage(Texture texture, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawImage(texture, n, n2, n3, n4, n5, n6, n3, n4);
    }

    public void drawImage(Texture texture, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Graphics2D graphics2D = this.getGraphics2D();
        if (this.affine != null) {
            graphics2D.transform(this.affine);
        }
        ImageJ2D imageJ2D = (ImageJ2D)texture;
        graphics2D.drawImage(imageJ2D.getImage(), n5, n6, n5 + n7, n6 + n8, n, n2, n + n3, n2 + n4, null);
        graphics2D.dispose();
    }

    public void drawText(String string, Font font, int n, int n2, int n3) {
        if (string == null || string.length() == 0) {
            return;
        }
        int n4 = ((FontJ2D)font).getAwtFont().getSize();
        int n5 = ((FontJ2D)font).getAwtFont().getSize() * string.length() * 2;
        BufferedImage bufferedImage = new BufferedImage(n5, n4 * 2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (this.affine != null) {
            graphics2D.transform(this.affine);
        }
        graphics2D.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        graphics2D.fillRect(0, 0, n5, n4 * 2);
        graphics2D.setFont(((FontJ2D)font).getAwtFont());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n6 = this.RGBA2ARGB(n);
        graphics2D.setColor(new Color(n6, true));
        graphics2D.drawString(string, 0, n4 + n4 / 2);
        graphics2D.dispose();
        graphics2D = this.getGraphics2D();
        graphics2D.drawImage(bufferedImage, n2, n3 - (n4 + n4 / 2), n2 + n5, n3 + n4 / 2, 0, 0, n5, n4 * 2, null);
        graphics2D.dispose();
    }

    private int RGBA2ARGB(int n) {
        int n2 = n >>> 8;
        int n3 = 0xFF & n;
        int n4 = n3 * 0x1000000 + n2;
        return n4;
    }

    public void setAffine(AffineMatrix affineMatrix) {
        if (affineMatrix == null) {
            this.affine = null;
        } else {
            double[][] dArray = affineMatrix.getMatrix();
            double[] dArray2 = new double[]{dArray[0][0], dArray[1][0], dArray[0][1], dArray[1][1], dArray[0][2], dArray[1][2]};
            AffineTransform affineTransform = new AffineTransform(dArray2);
            if (this.affine == null) {
                this.affine = affineTransform;
            } else {
                this.affine.concatenate(affineTransform);
            }
        }
    }

    public abstract BufferedImage getImage();

    public Graphics2D getGraphics2D() {
        return this.getImage().createGraphics();
    }

    class ImageObserverJ2D
    implements ImageObserver {
        ImageObserverJ2D() {
        }

        @Override
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            return (n & 0x20) == 0;
        }
    }
}

