/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.Present;
import game.sengoku.data.StoreV;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.TreasureV;
import game.sengoku.game.GameCostUtil;
import game.sengoku.window.WindowBase;
import java.util.ArrayList;
import java.util.List;

public class WindowStoreEntry
extends WindowBase {
    private Font font;
    private int fontColor = -319753729;
    private int daimyoId;
    private int storeId;
    private GameDataV datav;
    private int price;
    private int friendShip;
    private int gun;
    private int horse;
    private int iron;
    private int gunpowder;
    private int saltpeter;
    private List<Integer> treasures;
    protected List<Integer> introduces;
    protected List<Present> presents;
    private int usableMoney;

    public WindowStoreEntry(int n, int n2, int n3, int n4, int n5, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.font = GameFontUtil.FONT16;
        this.fontColor = -319753729;
        this.datav = gameDataV;
        this.treasures = new ArrayList<Integer>();
        this.introduces = new ArrayList<Integer>();
        this.presents = new ArrayList<Present>();
    }

    public void clear() {
        this.price = 0;
        this.friendShip = 0;
        this.gun = 0;
        this.horse = 0;
        this.iron = 0;
        this.gunpowder = 0;
        this.saltpeter = 0;
        this.treasures.clear();
        this.introduces.clear();
        this.presents.clear();
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        if (this.daimyoId != n) {
            this.daimyoId = n;
            this.needUpdate();
        }
    }

    public int getStoreId() {
        return this.storeId;
    }

    public void setStoreId(int n) {
        if (this.storeId != n) {
            this.storeId = n;
            this.needUpdate();
        }
    }

    public int getPrice() {
        return this.price;
    }

    public int getFriendShip() {
        return this.friendShip;
    }

    public int getGun() {
        return this.gun;
    }

    public void setGun(int n) {
        if (this.gun != n) {
            this.gun = n;
            this.needUpdate();
        }
    }

    public int getHorse() {
        return this.horse;
    }

    public void setHorse(int n) {
        if (this.horse != n) {
            this.horse = n;
            this.needUpdate();
        }
    }

    public int getIron() {
        return this.iron;
    }

    public void setIron(int n) {
        if (this.iron != n) {
            this.iron = n;
            this.needUpdate();
        }
    }

    public int getGunpowder() {
        return this.gunpowder;
    }

    public void setGunpowder(int n) {
        if (this.gunpowder != n) {
            this.gunpowder = n;
            this.needUpdate();
        }
    }

    public int getSaltpeter() {
        return this.saltpeter;
    }

    public void setSaltpeter(int n) {
        if (this.saltpeter != n) {
            this.saltpeter = n;
            this.needUpdate();
        }
    }

    public int getUsableMoney() {
        return this.usableMoney;
    }

    public void setUsableMoney(int n) {
        if (this.usableMoney != n) {
            this.usableMoney = n;
            this.needUpdate();
        }
    }

    public List<Integer> getTreasures() {
        return this.treasures;
    }

    public List<Integer> getIntroduces() {
        return this.introduces;
    }

    public List<Present> getPresents() {
        return this.presents;
    }

    public void forceUpdate() {
        super.needUpdate();
    }

    @Override
    protected void updateContent() {
        TreasureV treasureV;
        super.updateContent();
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        StoreV storeV = (StoreV)this.datav.getStores().get(this.storeId);
        if (daimyoV == null || storeV == null) {
            return;
        }
        this.price = GameCostUtil.price(this.datav, this.daimyoId, this.storeId, this.getGun(), this.getHorse(), this.getIron(), this.getGunpowder(), this.getSaltpeter(), this.getTreasures());
        int n = 1;
        this.content.drawText(storeV.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
        ++n;
        int n2 = 0;
        if (storeV.getFriendship().containsKey(this.daimyoId)) {
            n2 = (Integer)storeV.getFriendship().get(this.daimyoId);
        }
        int n3 = GameCostUtil.storeFriendShip(this.datav, this.storeId, this.price);
        for (Present present : this.presents) {
            n3 -= present.getFriendship();
        }
        int n4 = 60;
        this.friendShip = n2 + (n3 -= this.introduces.size() * n4);
        int n5 = this.fontColor;
        if (this.friendShip < 0) {
            n5 = -16776961;
        }
        this.content.drawText("\u53cb\u597d\u5ea6 " + n2 + " \u2192 " + this.friendShip, this.font, n5, 6, 6 + 20 * n);
        ++n;
        ++n;
        n5 = this.fontColor;
        if (this.usableMoney < this.price) {
            n5 = -16776961;
        }
        this.content.drawText("\u5408\u8a08 " + this.price, this.font, n5, 6, 6 + 20 * n);
        ++n;
        ++n;
        if (0 < this.getGun()) {
            this.content.drawText("\u9244\u7832 " + this.getGun(), this.font, this.fontColor, 6, 6 + 20 * n);
            ++n;
        }
        if (0 < this.getHorse()) {
            this.content.drawText("\u99ac " + this.getHorse(), this.font, this.fontColor, 6, 6 + 20 * n);
            ++n;
        }
        if (0 < this.getIron()) {
            this.content.drawText("\u9244 " + this.getIron(), this.font, this.fontColor, 6, 6 + 20 * n);
            ++n;
        }
        if (0 < this.getGunpowder()) {
            this.content.drawText("\u706b\u85ac " + this.getGunpowder(), this.font, this.fontColor, 6, 6 + 20 * n);
            ++n;
        }
        if (0 < this.getSaltpeter()) {
            this.content.drawText("\u785d\u77f3 " + this.getSaltpeter(), this.font, this.fontColor, 6, 6 + 20 * n);
            ++n;
        }
        for (int n6 : this.getTreasures()) {
            treasureV = (TreasureV)this.datav.getTreasures().get(n6);
            this.content.drawText(treasureV.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
            ++n;
        }
        for (Present present : this.presents) {
            treasureV = (TechnologyV)this.datav.getTechnologies().get(present.getTechnologyId());
            this.content.drawText(treasureV.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
            ++n;
        }
        for (int n7 : this.introduces) {
            treasureV = (StoreV)this.datav.getStores().get(n7);
            this.content.drawText(treasureV.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
            ++n;
        }
    }
}

