/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameFriendShipUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.RelationUtil;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.UnmodifiableReration;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowBase;
import java.util.Map;

public class WindowRelationInfo
extends WindowBase {
    private static final int INTERVAL = 20;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -319753729;
    private int daimyoId;
    private int targetDaimyoId;
    private String defaultMessage;
    private GameDataV datav;
    private ButtonSprite relationLabel;
    private ButtonSprite friendshipLabel;
    private ButtonSprite toubatsu;
    private ButtonSprite border;

    public WindowRelationInfo(int n, int n2, int n3, int n4, int n5, int n6, String string, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.daimyoId = n6;
        this.defaultMessage = string;
        this.datav = gameDataV;
        this.relationLabel = new ButtonSprite(n4 - 275, 6, 100, 50, 20, 388883421, 388883421, GameFontUtil.FONT16, "", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.relationLabel.setFontColor(-319753729);
        this.friendshipLabel = new ButtonSprite(n4 - 330, 6, 100, 50, 20, 388883421, 388883421, GameFontUtil.FONT16, "", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.friendshipLabel.setFontColor(-319753729);
        this.toubatsu = new ButtonSprite(n4 - 220, 6, 100, 50, 20, -1069995009, -1069995009, GameFontUtil.FONT16, "\u8a0e\u4f10", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.toubatsu.setFontColor(-319753729);
        this.border = new ButtonSprite(n4 - 165, 6, 100, 75, 20, -414434049, -414434049, GameFontUtil.FONT16, "\u56fd\u5883\u7d1b\u4e89", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.border.setFontColor(-319753729);
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        if (this.daimyoId != n) {
            this.daimyoId = n;
            this.needUpdate();
        }
    }

    public int getTargetDaimyoId() {
        return this.targetDaimyoId;
    }

    public void setTargetDaimyoId(int n) {
        if (this.targetDaimyoId != n) {
            this.targetDaimyoId = n;
            this.needUpdate();
        }
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    public UnmodifiableReration getRelation() {
        return this.datav.getRelation(this.targetDaimyoId, this.daimyoId);
    }

    private String sgn(int n) {
        return 0 < n ? "+" : " ";
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        DaimyoV daimyoV2 = (DaimyoV)this.datav.getDaimyos().get(this.targetDaimyoId);
        UnmodifiableReration unmodifiableReration = this.getRelation();
        if (daimyoV == null || daimyoV2 == null || unmodifiableReration == null) {
            int n = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 20 * n);
            return;
        }
        int n = 1;
        this.content.drawText(daimyoV2.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
        this.content.drawText("\u53cb\u597d\u5ea6  " + unmodifiableReration.getFriendShip(), this.font, this.fontColor, 106, 6 + 20 * n);
        this.friendshipLabel.setText(RelationUtil.friendShipName(unmodifiableReration));
        this.friendshipLabel.setBgColor(RelationUtil.friendShipColor(unmodifiableReration));
        this.friendshipLabel.draw(this.content);
        if (unmodifiableReration.getStatus() != 0) {
            this.relationLabel.setText(RelationUtil.relationName(unmodifiableReration));
            this.relationLabel.setBgColor(RelationUtil.relationColor(unmodifiableReration));
            this.relationLabel.draw(this.content);
        }
        if (0 < daimyoV2.getToubatsuLeave()) {
            this.toubatsu.draw(this.content);
        }
        if (0 < unmodifiableReration.getBorder()) {
            this.border.draw(this.content);
        }
        n = 0;
        for (Map.Entry entry : unmodifiableReration.getDiplomacyFactor().entrySet()) {
            String string = GameFriendShipUtil.getFactorExplanation((Integer)entry.getKey(), (Integer)entry.getValue(), daimyoV.getName());
            this.content.drawText(string + " " + this.sgn((Integer)entry.getValue()) + entry.getValue(), this.font, this.fontColor, 6 + 300 * (n / 5), 6 + 20 * (n % 5 + 2));
            ++n;
        }
        if (0 < unmodifiableReration.getNonAggression()) {
            this.content.drawText("\u505c\u6226\u671f\u9593", this.font, this.fontColor, this.width - 150 - 6, 46);
            this.content.drawText("" + unmodifiableReration.getNonAggression() + "\u30f6\u6708", this.font, this.fontColor, this.width - 50 - 6, 46);
        }
    }
}

