/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowBase;

public class WindowMessageEx
extends WindowBase {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_YES_NO = 1;
    private Font font;
    private String[] messages = new String[0];
    private int pageIndex = 0;
    protected ButtonSprite okButton;
    protected ButtonSprite ngButton;
    private int type = 0;
    protected Runnable yesSelected;
    protected Runnable noSelected;
    private static final int BUTTON_WIDTH = 32;
    private static final int BUTTON_HEIGHT = 20;

    public WindowMessageEx(int n, int n2) {
        super(n, n2);
    }

    public WindowMessageEx(int n, int n2, int n3, int n4, int n5, int n6, Font font, int n7) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(n6);
        this.font = font;
        this.type = n7;
    }

    public WindowMessageEx(int n, int n2, int n3, int n4, int n5, int n6, Font font) {
        this(n, n2, n3, n4, n5, n6, font, 0);
    }

    public void refresh() {
        this.pageIndex = 0;
        this.messages = new String[0];
        this.yesSelected = null;
        this.noSelected = null;
    }

    @Override
    protected void init() {
        this.children.clear();
        this.okButton = new ButtonSprite(this.width / 2 + 5, this.height - 6 - 17, 100, 32, 20, 388883421, -1380583425, this.font, "\u6b21", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.okButton.setPrimaryClicked(windowClickable -> this.onOkClicked());
        this.okButton.setFontColor(-319753729);
        this.okButton.setParent(this);
        this.children.add(this.okButton);
        this.ngButton = new ButtonSprite(this.width / 2 + 5 - 32 - 5, this.height - 6 - 17, 100, 32, 20, 388883421, -1380583425, this.font, "\u623b", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.ngButton.setPrimaryClicked(windowClickable -> this.onNgClicked());
        this.ngButton.setFontColor(-319753729);
        this.ngButton.setParent(this);
        this.children.add(this.ngButton);
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.messages != null) {
            int n = this.row();
            for (int i = 0; i < n; ++i) {
                int n2 = this.pageIndex * n + i;
                if (n2 >= this.messages.length) continue;
                this.content.drawText(this.messages[n2], this.font, 255, 6, 6 + (int)(this.font.getFontSize() * (float)(i + 1)));
            }
        }
    }

    private void onOkClicked() {
        if (this.isLast()) {
            if (this.yesSelected != null) {
                this.yesSelected.run();
            }
            this.setVisible(false);
            this.needUpdate();
            return;
        }
        if (!this.isLast()) {
            ++this.pageIndex;
            this.needUpdate();
        } else {
            this.setVisible(false);
            this.needUpdate();
        }
    }

    private String okString() {
        switch (this.type) {
            case 0: {
                return this.isLast() ? "\u9589" : "\u6b21";
            }
            case 1: {
                return this.isLast() ? "\u662f" : "\u6b21";
            }
        }
        return null;
    }

    private void onNgClicked() {
        if (this.type == 1 && this.isLast()) {
            if (this.noSelected != null) {
                this.noSelected.run();
            }
            this.setVisible(false);
            this.needUpdate();
            return;
        }
        if (!this.isFirst()) {
            --this.pageIndex;
            this.needUpdate();
        }
    }

    private String ngString() {
        switch (this.type) {
            case 0: {
                return this.isFirst() ? "\u623b" : "\u623b";
            }
            case 1: {
                return this.isLast() ? "\u5426" : "\u623b";
            }
        }
        return null;
    }

    @Override
    public void update() {
        if (this.okButton != null) {
            this.okButton.setText(this.okString());
        }
        if (this.ngButton != null) {
            if (!this.isFirst() || this.type == 1 && this.isLast()) {
                this.ngButton.setNormalColor(388883421);
            } else {
                this.ngButton.setNormalColor(-1380583425);
            }
            this.ngButton.setText(this.ngString());
        }
        super.update();
    }

    private boolean isFirst() {
        if (this.messages != null) {
            return this.pageIndex == 0;
        }
        return true;
    }

    private boolean isLast() {
        if (this.messages != null) {
            return (this.pageIndex + 1) * this.row() >= this.messages.length;
        }
        return true;
    }

    private int row() {
        if (this.font == null) {
            return 0;
        }
        return (this.height - 32) / (int)this.font.getFontSize();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.needUpdate();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
        this.needUpdate();
    }

    public String[] getMessages() {
        return this.messages;
    }

    public void setMessages(String[] stringArray) {
        this.messages = stringArray;
        this.needUpdate();
    }

    public void setYesSelected(Runnable runnable) {
        this.yesSelected = runnable;
    }

    public void setNoSelected(Runnable runnable) {
        this.noSelected = runnable;
    }
}

