/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.JusticeUtil;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.Justice;
import game.sengoku.data.PlayerV;
import game.sengoku.window.WindowBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WindowJusticeInfo
extends WindowBase {
    private static final int INTERVAL = 20;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -319753729;
    private int daimyoId;
    private Map<Integer, List<Justice>> justiceMap;
    private String defaultMessage;
    private GameDataV datav;
    private PlayerV player;

    public WindowJusticeInfo(int n, int n2, int n3, int n4, int n5, int n6, String string, GameDataV gameDataV, PlayerV playerV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.daimyoId = n6;
        this.defaultMessage = string;
        this.datav = gameDataV;
        this.player = playerV;
        this.justiceMap = new HashMap<Integer, List<Justice>>();
    }

    public Map<Integer, List<Justice>> getJusticeMap() {
        return this.justiceMap;
    }

    public void setJusticeMap(Map<Integer, List<Justice>> map) {
        this.justiceMap.clear();
        this.justiceMap.putAll(map);
        this.needUpdate();
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        if (this.daimyoId != n) {
            this.daimyoId = n;
            this.needUpdate();
        }
    }

    public PlayerV getPlayer() {
        return this.player;
    }

    public void setPlayer(PlayerV playerV) {
        this.player = playerV;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        String[] stringArray;
        super.updateContent();
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        if (daimyoV == null || this.justiceMap == null) {
            int n = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 20 * n);
            return;
        }
        int n = 1;
        this.content.drawText(daimyoV.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
        ++n;
        List<Justice> list = this.justiceMap.get(this.daimyoId);
        for (String string : stringArray = JusticeUtil.getJusticeNames(this.datav, list, daimyoV)) {
            this.content.drawText(string, this.font, this.fontColor, 6, 6 + 20 * n);
            ++n;
        }
    }
}

