/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.base.graphic.GraphicPool;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.GameDataV;
import game.sengoku.data.GameHistory;
import game.sengoku.data.PlayerV;
import game.sengoku.main.KessenMain;
import game.sengoku.window.VSliderSprite;
import game.sengoku.window.WindowBase;
import java.util.List;
import java.util.ListIterator;

public class WindowHistory
extends WindowBase {
    private Font font;
    private int fontColor = -319753729;
    private VSliderSprite slider;
    private GameDataV datav;
    private PlayerV player;
    private int historySize = -1;

    public WindowHistory(int n, int n2, int n3, int n4, int n5, GameDataV gameDataV, PlayerV playerV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.font = GameFontUtil.FONT16;
        this.fontColor = -319753729;
        this.player = playerV;
        this.datav = gameDataV;
        this.load();
    }

    private void load() {
        this.children.clear();
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.slider = new VSliderSprite(this.width - 35, 5, 100, 30, this.height - 20, MouseSymbolLayerManager.LAYER_NORMAL);
        this.slider.setParent(this);
        this.slider.setValueChanged(() -> this.needUpdate());
        this.children.add(this.slider);
    }

    @Override
    public void update() {
        super.update();
        if (this.historySize != this.player.getBackLogs().size()) {
            this.historySize = this.player.getBackLogs().size();
            this.slider.setValueMax(this.player.getBackLogs().size());
            this.needUpdate();
        }
    }

    @Override
    protected void updateContent() {
        GameHistory gameHistory;
        String[] stringArray;
        super.updateContent();
        int n = this.slider.getValue();
        List list = this.player.getBackLogs();
        int n2 = 1;
        ListIterator listIterator = list.listIterator(list.size() - n);
        while (listIterator.hasPrevious() && this.height >= 5 + (n2 + (stringArray = GameUtil.splitMessages((this.width - 160) / 18, (gameHistory = (GameHistory)listIterator.previous()).getMessages())).length) * 22) {
            this.content.drawText(gameHistory.getGengo() + gameHistory.getGengoYear() + "\u5e74" + (gameHistory.isIntercalary() ? "\u958f" : "") + gameHistory.getMonth() + "\u6708" + gameHistory.getDay() + "\u65e5", this.font, this.fontColor, 10, 5 + n2 * 22);
            for (String string : stringArray) {
                this.content.drawText(string, this.font, this.fontColor, 160, 5 + n2 * 22);
                ++n2;
            }
        }
    }
}

