/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.GameDataV;
import game.sengoku.data.GiantV;
import game.sengoku.window.WindowBase;

public class WindowGiantProgress
extends WindowBase {
    private static final int INTERVAL = 22;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -319753729;
    private int giantId;
    private String defaultMessage;
    private GameDataV datav;

    public WindowGiantProgress(int n, int n2, int n3, int n4, int n5, String string, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.giantId = 0;
        this.defaultMessage = string;
        this.datav = gameDataV;
    }

    public int getGiantId() {
        return this.giantId;
    }

    public void setGiantId(int n) {
        if (this.giantId != n) {
            this.giantId = n;
            this.needUpdate();
        }
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        GiantV giantV = (GiantV)this.datav.getGiants().get(this.giantId);
        if (giantV != null) {
            int n = 1;
            this.content.drawText(giantV.getGiant().getType() + "\u3000" + giantV.getFullName(), this.font, this.fontColor, 6, 6 + 22 * n);
            this.content.drawText("\u7814\u7a76\u5b8c\u4e86\u307e\u3067 " + (giantV.getGiant().getCultureMonths() - giantV.getMonth()) + "\u30f6\u6708", this.font, this.fontColor, 6, 6 + 22 * ++n);
            ++n;
            if (giantV.getGiant().getTechnologyId() != 0) {
                this.content.drawText("\u7814\u7a76\u4e2d\u306e\u6280\u8853   " + giantV.getTechnology().getName(), this.font, this.fontColor, 6, 6 + 22 * n);
                ++n;
            }
            if (giantV.getGiant().getCultureId() != 0) {
                this.content.drawText("\u7814\u7a76\u4e2d\u306e\u6587\u5316   " + giantV.getCulture().getName(), this.font, this.fontColor, 6, 6 + 22 * n);
                ++n;
            }
            if (giantV.getGiant().getCultureId() != 0) {
                this.content.drawText("\u958b\u767a\u4e2d\u306e\u5bb6\u5b9d   " + giantV.getTreasure().getName(), this.font, this.fontColor, 6, 6 + 22 * n);
                ++n;
            }
        } else {
            int n = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 22 * n);
        }
    }
}

