/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.RoleV;
import game.sengoku.window.WindowBase;

public class WindowDaimyoInfo
extends WindowBase {
    private static final int INTERVAL = 20;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -319753729;
    private int daimyoId;
    private String defaultMessage;
    private GameDataV datav;
    private PlayerV player;

    public WindowDaimyoInfo(int n, int n2, int n3, int n4, int n5, int n6, String string, GameDataV gameDataV, PlayerV playerV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.daimyoId = n6;
        this.defaultMessage = string;
        this.datav = gameDataV;
        this.player = playerV;
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        if (this.daimyoId != n) {
            this.daimyoId = n;
            this.needUpdate();
        }
    }

    public PlayerV getPlayer() {
        return this.player;
    }

    public void setPlayer(PlayerV playerV) {
        this.player = playerV;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        if (daimyoV == null) {
            int n = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 20 * n);
            return;
        }
        int n = 1;
        this.content.drawText(daimyoV.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
        this.content.drawText("\u5927\u540d " + daimyoV.getKnight().getFullName(), this.font, this.fontColor, 6, 6 + 20 * ++n);
        ++n;
        if (daimyoV.getRank() == null) {
            this.content.drawText("\u7121\u4f4d\u7121\u5b98", this.font, this.fontColor, 6, 6 + 20 * n);
        } else {
            this.content.drawText(daimyoV.getRank().getName() + " " + daimyoV.getRank().getRoleName(), this.font, this.fontColor, 6, 6 + 20 * n);
        }
        if (!daimyoV.getRoles().isEmpty()) {
            this.content.drawText(((RoleV)daimyoV.getRoles().get(0)).getName(), this.font, this.fontColor, 6, 6 + 20 * ++n);
        }
        n = 2;
        this.content.drawText("\u540d\u58f0", this.font, this.fontColor, 156, 6 + 20 * n);
        this.content.drawText("" + daimyoV.getFame(), this.font, this.fontColor, 226, 6 + 20 * n);
        this.content.drawText("\u6b66\u5a01", this.font, this.fontColor, 156, 6 + 20 * ++n);
        this.content.drawText("" + daimyoV.getImpact(), this.font, this.fontColor, 226, 6 + 20 * n);
        this.content.drawText("\u56fd\u6570", this.font, this.fontColor, 156, 6 + 20 * ++n);
        this.content.drawText("" + daimyoV.getCountries().size(), this.font, this.fontColor, 226, 6 + 20 * n);
        this.content.drawText("\u7dcf\u4eba\u53e3", this.font, this.fontColor, 156, 6 + 20 * ++n);
        this.content.drawText("" + daimyoV.getPopulationAmount(), this.font, this.fontColor, 226, 6 + 20 * n);
        this.content.drawText("\u7dcf\u77f3\u9ad8", this.font, this.fontColor, 156, 6 + 20 * ++n);
        this.content.drawText("" + daimyoV.getFoodAmount(), this.font, this.fontColor, 226, 6 + 20 * n);
        n = 2;
        this.content.drawText("\u5546\u696d", this.font, this.fontColor, 306, 6 + 20 * n);
        this.content.drawText("" + daimyoV.getCommerce(), this.font, this.fontColor, 376, 6 + 20 * n);
        this.content.drawText("\u6587\u5316\u5e73\u5747", this.font, this.fontColor, 306, 6 + 20 * ++n);
        this.content.drawText("" + daimyoV.getCultureArv(), this.font, this.fontColor, 376, 6 + 20 * n);
        this.content.drawText("\u7dcf\u5175\u6570", this.font, this.fontColor, 306, 6 + 20 * ++n);
        this.content.drawText("" + daimyoV.getArmyAmount(), this.font, this.fontColor, 376, 6 + 20 * n);
        this.content.drawText("\u91d1\u92ad", this.font, this.fontColor, 306, 6 + 20 * ++n);
        this.content.drawText("" + daimyoV.getMoney(), this.font, this.fontColor, 376, 6 + 20 * n);
        n = 2;
        this.content.drawText("\u9244\u7832", this.font, this.fontColor, 456, 6 + 20 * n);
        this.content.drawText("" + daimyoV.getGun(), this.font, this.fontColor, 526, 6 + 20 * n);
        this.content.drawText("\u9a0e\u99ac", this.font, this.fontColor, 456, 6 + 20 * ++n);
        this.content.drawText("" + daimyoV.getHorse(), this.font, this.fontColor, 526, 6 + 20 * n);
        this.content.drawText("\u9244", this.font, this.fontColor, 456, 6 + 20 * ++n);
        this.content.drawText("" + daimyoV.getIron(), this.font, this.fontColor, 526, 6 + 20 * n);
        this.content.drawText("\u786b\u9ec4", this.font, this.fontColor, 456, 6 + 20 * ++n);
        this.content.drawText("" + daimyoV.getSaltpeter(), this.font, this.fontColor, 526, 6 + 20 * n);
        this.content.drawText("\u706b\u85ac", this.font, this.fontColor, 456, 6 + 20 * ++n);
        this.content.drawText("" + daimyoV.getGunpowder(), this.font, this.fontColor, 526, 6 + 20 * n);
    }
}

