/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.common.HasAbsoluteXY;
import game.base.graphic.Texture;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.MapPosition;
import game.sengoku.data.UnitV;
import game.sengoku.game.GameUnitUtil;
import game.sengoku.window.ButtonSprite;

public class UnitSprite
extends ButtonSprite {
    private Texture texture;
    private DaimyoV daimyo;
    private UnitV unit;
    private int delta;
    private int degree;
    private int edge;
    private boolean fixed = false;

    public UnitSprite(int n, int n2, int n3, DaimyoV daimyoV, UnitV unitV) {
        this(n, n2, n3, 25, 25, daimyoV, unitV, null);
    }

    public UnitSprite(int n, int n2, int n3, int n4, int n5, DaimyoV daimyoV, UnitV unitV, HasAbsoluteXY hasAbsoluteXY) {
        super(n, n2, n3, n4, n5, -1, -1, null, "", false, MouseSymbolLayerManager.LAYER_NORMAL, hasAbsoluteXY);
        this.daimyo = daimyoV;
        this.unit = unitV;
        this.fixed = false;
        this.selectTexture();
        this.calcDegree();
    }

    private void selectTexture() {
        this.texture = GameUnitUtil.selectTexture(this.daimyo, this.unit);
    }

    @Override
    protected void updateBackGround() {
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.texture != null) {
            this.content.drawImage(this.texture, 0, 0, this.texture.getWidth(), this.texture.getHeight(), (this.width - this.edge) / 2, (this.height - this.edge) / 2, this.edge, this.edge);
        }
    }

    @Override
    public void update() {
        super.update();
        this.updateEdge();
        this.setRotate(this.degree + this.delta);
    }

    private void calcDegree() {
        if (this.unit.getBeforeSpot() == null) {
            this.degree = 0;
            return;
        }
        MapPosition mapPosition = this.unit.getSpot().getPosition();
        MapPosition mapPosition2 = this.unit.getBeforeSpot().getPosition();
        this.degree = GameUnitUtil.calcDegree(mapPosition, mapPosition2);
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int n) {
        this.degree = n;
    }

    public DaimyoV getDaimyo() {
        return this.daimyo;
    }

    public void setDaimyo(DaimyoV daimyoV) {
        this.daimyo = daimyoV;
        this.needUpdate();
    }

    public UnitV getUnit() {
        return this.unit;
    }

    public void setUnit(UnitV unitV) {
        this.unit = unitV;
        this.needUpdate();
    }

    public int getDelta() {
        return this.delta;
    }

    public void setDelta(int n) {
        if (this.delta != n) {
            this.delta = n;
            this.needUpdate();
        }
    }

    public int getEdge() {
        return this.edge;
    }

    public void setEdge(int n) {
        if (this.edge != n) {
            this.edge = n;
            this.needUpdate();
        }
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean bl) {
        this.fixed = bl;
    }

    public Texture getTexture() {
        return this.texture;
    }

    private void updateEdge() {
        this.setEdge(GameUnitUtil.calcEdge(this.unit));
    }
}

