/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.common.HasAbsoluteXY;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.UnitSprite;
import java.util.ArrayList;
import java.util.Iterator;

public class UnitEffectSprite
extends ButtonSprite {
    private Texture texNumber;
    private UnitSprite unit;

    public UnitEffectSprite(int n, int n2, int n3, UnitSprite unitSprite) {
        this(n, n2, n3, 35, 35, unitSprite, null);
    }

    public UnitEffectSprite(int n, int n2, int n3, int n4, int n5, UnitSprite unitSprite, HasAbsoluteXY hasAbsoluteXY) {
        super(n, n2, n3, n4, n5, -1, -1, null, "", false, MouseSymbolLayerManager.LAYER_NORMAL, hasAbsoluteXY);
        this.unit = unitSprite;
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.texNumber = (Texture)graphicPool.getResource("number_orng.png");
    }

    private void drawNumber(int n, int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 10000; i > 0; i /= 10) {
            if (n < i) continue;
            arrayList.add(n % (i * 10) / i);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            this.content.drawImage(this.texNumber, n4 % 5 * 15, n4 / 5 * 20, 15, 20, n2, n3, 9, 12);
            n2 += 9;
        }
    }

    @Override
    protected void updateBackGround() {
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.texNumber != null && this.unit != null && this.unit.getUnit() != null) {
            this.drawNumber(this.unit.getUnit().getMoveOrder(), 0, this.height - 12);
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.unit != null) {
            this.x = this.unit.getX() - 5;
            this.y = this.unit.getY() - 5;
            this.z = this.unit.getZ() + 10;
            this.setVisible(this.unit.isVisible());
        }
    }

    public UnitSprite getUnit() {
        return this.unit;
    }

    public void setUnit(UnitSprite unitSprite) {
        this.unit = unitSprite;
        this.needUpdate();
    }
}

