/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.common.HasAbsoluteXY;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.base.input.InputInterface;
import game.base.symbol.MouseSymbol;
import game.base.symbol.MouseSymbolLayer;
import game.base.symbol.SymbolRect;
import game.sengoku.common.AudioUtil;
import game.sengoku.data.DataUtil;
import game.sengoku.main.KessenMain;
import game.sengoku.window.WindowBase;

public class SliderSprite
extends WindowBase {
    protected MouseSymbol mouseSymbolMinus;
    protected MouseSymbol mouseSymbolGauge;
    protected MouseSymbol mouseSymbolPlus;
    protected MouseSymbol mouseSymbolShortCut;
    protected Texture texLeft;
    protected Texture texRight;
    protected Texture texLeftMono;
    protected Texture texRightMono;
    protected Texture texBoll;
    protected Texture texEmpty;
    protected Texture texHalf;
    protected Texture texFull;
    protected Texture texDisable;
    protected MouseSymbolLayer layer;
    protected int length;
    protected boolean useShortCut;
    protected HasAbsoluteXY origine;
    protected int value;
    protected int valueMax;
    protected int valueMin;
    private int counter = 0;
    private int shortCutType = 0;
    private Runnable valueChanged = null;
    protected int soundId = 7;

    public SliderSprite(int n, int n2, int n3, int n4, int n5, boolean bl, MouseSymbolLayer mouseSymbolLayer) {
        this(n, n2, n3, n4, n5, bl, mouseSymbolLayer, null);
    }

    public SliderSprite(int n, int n2, int n3, int n4, int n5, boolean bl, MouseSymbolLayer mouseSymbolLayer, HasAbsoluteXY hasAbsoluteXY) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        if (bl) {
            this.length = n4 - n5 * 3 - 5;
            this.shortCutType = 0;
        } else {
            this.length = n4 - n5 * 2;
        }
        this.layer = mouseSymbolLayer;
        this.useShortCut = bl;
        this.initializeSlider();
    }

    public SliderSprite(int n, int n2, int n3, int n4, int n5, MouseSymbolLayer mouseSymbolLayer, HasAbsoluteXY hasAbsoluteXY) {
        this(n, n2, n3, n4, n5, false, mouseSymbolLayer, hasAbsoluteXY);
    }

    protected void initializeSlider() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.texLeft = (Texture)graphicPool.getResource("iconLeft.png");
        this.texRight = (Texture)graphicPool.getResource("iconRight.png");
        this.texLeftMono = (Texture)graphicPool.getResource("iconLeftMono.png");
        this.texRightMono = (Texture)graphicPool.getResource("iconRightMono.png");
        this.texBoll = (Texture)graphicPool.getResource("boll.png");
        this.texEmpty = (Texture)graphicPool.getResource("slider_empty.png");
        this.texHalf = (Texture)graphicPool.getResource("slider_half.png");
        this.texFull = (Texture)graphicPool.getResource("slider_full.png");
        this.texDisable = (Texture)graphicPool.getResource("slider_disable.png");
        if (this.origine == null) {
            this.origine = this;
        }
        this.mouseSymbolMinus = new MouseSymbol(KessenMain.getInstance(), this.layer);
        this.mouseSymbolMinus.setOrigin(this.origine);
        this.mouseSymbolMinus.setActive(true);
        this.mouseSymbolMinus.getAreas().add(new SymbolRect(0, 0, this.height, this.height));
        this.mouseSymbolGauge = new MouseSymbol(KessenMain.getInstance(), this.layer);
        this.mouseSymbolGauge.setOrigin(this.origine);
        this.mouseSymbolGauge.setActive(true);
        this.mouseSymbolGauge.getAreas().add(new SymbolRect(this.height, 0, this.length, this.height));
        this.mouseSymbolPlus = new MouseSymbol(KessenMain.getInstance(), this.layer);
        this.mouseSymbolPlus.setOrigin(this.origine);
        this.mouseSymbolPlus.setActive(true);
        this.mouseSymbolPlus.getAreas().add(new SymbolRect(this.height + this.length, 0, this.height, this.height));
        if (this.useShortCut) {
            this.shortCutType = 0;
            this.mouseSymbolShortCut = new MouseSymbol(KessenMain.getInstance(), this.layer);
            this.mouseSymbolShortCut.setOrigin(this.origine);
            this.mouseSymbolShortCut.setActive(true);
            this.mouseSymbolShortCut.getAreas().add(new SymbolRect(this.height * 2 + this.length + 5, 0, this.height, this.height));
        } else {
            this.mouseSymbolShortCut = null;
        }
    }

    public void resetShortCut() {
        this.shortCutType = 0;
    }

    public Runnable getValueChanged() {
        return this.valueChanged;
    }

    public void setValueChanged(Runnable runnable) {
        this.valueChanged = runnable;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        if (this.value != n) {
            this.value = DataUtil.checkInteger((int)n, (int)this.valueMin, (int)this.valueMax);
            if (this.valueChanged != null) {
                this.valueChanged.run();
            }
            this.needUpdate();
        }
    }

    public int getValueMax() {
        return this.valueMax;
    }

    public void setValueMax(int n) {
        if (this.valueMax != n) {
            this.valueMax = n;
            this.needUpdate();
        }
    }

    public int getValueMin() {
        return this.valueMin;
    }

    public void setValueMin(int n) {
        if (this.valueMin != n) {
            this.valueMin = n;
            this.needUpdate();
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.value == this.valueMin) {
            this.content.drawImage(this.texLeftMono, 0, 0, this.texLeft.getWidth(), this.texLeft.getHeight(), 0, 0, this.height, this.height);
        } else {
            this.content.drawImage(this.texLeft, 0, 0, this.texLeft.getWidth(), this.texLeft.getHeight(), 0, 0, this.height, this.height);
        }
        if (this.value == this.valueMax) {
            this.content.drawImage(this.texRightMono, 0, 0, this.texRight.getWidth(), this.texRight.getHeight(), this.height + this.length, 0, this.height, this.height);
        } else {
            this.content.drawImage(this.texRight, 0, 0, this.texRight.getWidth(), this.texRight.getHeight(), this.height + this.length, 0, this.height, this.height);
        }
        if (this.valueMax == this.valueMin) {
            this.content.drawImage(this.texBoll, 0, 0, this.texBoll.getWidth(), this.texBoll.getHeight(), this.height + this.length / 2, (this.height - 8) / 2, 8, 8);
        } else {
            this.content.drawImage(this.texBoll, 0, 0, this.texBoll.getWidth(), this.texBoll.getHeight(), this.height + this.length * this.value / (this.valueMax - this.valueMin), (this.height - 8) / 2, 8, 8);
        }
        if (this.useShortCut) {
            if (this.valueMax == this.valueMin) {
                this.content.drawImage(this.texDisable, 0, 0, this.texDisable.getWidth(), this.texDisable.getHeight(), this.height * 2 + this.length + 5, 0, this.height, this.height);
            } else {
                switch (this.shortCutType) {
                    case 0: {
                        this.content.drawImage(this.texFull, 0, 0, this.texFull.getWidth(), this.texFull.getHeight(), this.height * 2 + this.length + 5, 0, this.height, this.height);
                        break;
                    }
                    case 1: {
                        this.content.drawImage(this.texHalf, 0, 0, this.texHalf.getWidth(), this.texHalf.getHeight(), this.height * 2 + this.length + 5, 0, this.height, this.height);
                        break;
                    }
                    case 2: {
                        this.content.drawImage(this.texEmpty, 0, 0, this.texEmpty.getWidth(), this.texEmpty.getHeight(), this.height * 2 + this.length + 5, 0, this.height, this.height);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void update() {
        super.update();
        InputInterface inputInterface = KessenMain.getInstance().getInput();
        this.mouseSymbolMinus.setActive(this.isVisible());
        this.mouseSymbolPlus.setActive(this.isVisible());
        this.mouseSymbolGauge.setActive(this.isVisible());
        this.mouseSymbolMinus.update();
        this.mouseSymbolPlus.update();
        this.mouseSymbolGauge.update();
        if (this.mouseSymbolShortCut != null) {
            this.mouseSymbolShortCut.setActive(this.isVisible());
            this.mouseSymbolShortCut.update();
        }
        if (inputInterface.isMousePrimaryPress()) {
            if (this.mouseSymbolMinus.isMousePrimaryClicked()) {
                this.setValue(this.value - 1);
                this.counter = 0;
            } else if (this.mouseSymbolMinus.isMouseOver()) {
                ++this.counter;
                if (this.counter % 5 == 0) {
                    this.setValue(this.value - 1);
                }
            }
            if (this.mouseSymbolPlus.isMousePrimaryClicked()) {
                this.setValue(this.value + 1);
                this.counter = 0;
            } else if (this.mouseSymbolPlus.isMouseOver()) {
                ++this.counter;
                if (this.counter % 5 == 0) {
                    this.setValue(this.value + 1);
                }
            }
        } else {
            this.counter = 0;
        }
        if (this.mouseSymbolGauge.isMousePrimaryClicked()) {
            int n = inputInterface.getMouseX() - this.getAbsoluteX() - this.height;
            this.setValue(this.valueMin + n * (this.valueMax - this.valueMin) / this.length);
        } else if (this.mouseSymbolShortCut != null && this.mouseSymbolShortCut.isMousePrimaryClicked()) {
            AudioUtil.sePlay(this.soundId);
            switch (this.shortCutType) {
                case 0: {
                    this.setValue(this.valueMax);
                    break;
                }
                case 1: {
                    this.setValue((this.valueMin + this.valueMax) / 2);
                    break;
                }
                case 2: {
                    this.setValue(this.valueMin);
                    break;
                }
            }
            ++this.shortCutType;
            this.shortCutType %= 3;
        }
    }
}

