/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.base.font.FontPool;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.SaveData;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;

public class SaveDataButton
extends ButtonSprite {
    private SaveData saveData;

    public SaveData getSaveData() {
        return this.saveData;
    }

    public void setSaveData(SaveData saveData) {
        this.saveData = saveData;
    }

    public SaveDataButton(int n, int n2, SaveData saveData) {
        super(n, n2, 100, 400, 112, -6710887, -6710785, null, null, false, MouseSymbolLayerManager.LAYER_NORMAL);
        this.saveData = saveData;
        KessenMain kessenMain = KessenMain.getInstance();
        FontPool fontPool = kessenMain.getFontPool();
        this.font = (Font)fontPool.getResource("ipam.ttf:16");
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.saveData != null) {
            this.content.drawText(this.saveData.getName(), this.font, -1, 6, 22);
            this.content.drawText(this.saveData.getTimestamp(), this.font, -1, 6, 38);
            String string = this.saveData.getExplain();
            int n = 0;
            for (int i = 0; i < string.length(); i += 24) {
                String string2 = string.substring(i, Math.min(i + 24, string.length()));
                this.content.drawText(string2, this.font, -1, 6, 60 + 16 * n);
                ++n;
            }
        }
    }
}

